/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDoublePlantBlock
extends JSPlantBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public JSDoublePlantBlock(BlockBehaviour.Properties p_52861_) {
        super(p_52861_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected static void preventDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER) {
            BlockPos blockpos = pos.below();
            BlockState blockstate = level.getBlockState(blockpos);
            if (blockstate.is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
                BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                level.setBlock(blockpos, blockstate1, 18);
                level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
            }
        } else {
            BlockPos blockpos = pos.above();
            BlockState blockstate = level.getBlockState(blockpos);
            if (blockstate.is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.UPPER) {
                BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                level.setBlock(blockpos, blockstate1, 18);
                level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
            }
        }
    }

    public static void placeAt(LevelAccessor levelAccessor, BlockState blockstate, BlockPos blockPos, int i) {
        BlockPos blockpos = blockPos.above();
        levelAccessor.setBlock(blockPos, JSDoublePlantBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockPos, (BlockState)blockstate.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)), i);
        levelAccessor.setBlock(blockpos, JSDoublePlantBlock.copyWaterloggedFrom((LevelReader)levelAccessor, blockpos, (BlockState)blockstate.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)), i);
    }

    public static BlockState copyWaterloggedFrom(LevelReader p_182454_, BlockPos p_182455_, BlockState p_182456_) {
        return p_182456_.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)p_182456_.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(p_182454_.isWaterAt(p_182455_))) : p_182456_;
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, Direction direction, @NotNull BlockState state2, @NotNull LevelAccessor accessor, @NotNull BlockPos pos, @NotNull BlockPos pos2) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)blockState.getValue(HALF);
        if (direction.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || state2.is((Block)this) && state2.getValue(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, state2, accessor, pos, pos2);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_52863_) {
        BlockPos blockpos = p_52863_.getClickedPos();
        Level level = p_52863_.getLevel();
        return blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(p_52863_) ? super.getStateForPlacement(p_52863_) : null;
    }

    public void setPlacedBy(Level p_52872_, BlockPos p_52873_, @NotNull BlockState p_52874_, LivingEntity p_52875_, @NotNull ItemStack p_52876_) {
        BlockPos blockpos = p_52873_.above();
        p_52872_.setBlock(blockpos, JSDoublePlantBlock.copyWaterloggedFrom((LevelReader)p_52872_, blockpos, (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader reader, @NotNull BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(state, reader, pos);
        }
        BlockState blockstate = reader.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, reader, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.isClientSide && player.isCreative()) {
            JSDoublePlantBlock.preventDropFromBottomPart(level, pos, state, player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    public void performSpread(Level level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos spreadTo = this.getSpreadPosition(level, random, pos, state, 5, 2);
        BlockState spr = level.getBlockState(spreadTo);
        if (spr.getBlock() != this && spr.isAir() && level.getBlockState(spreadTo.below()).is(BlockTags.DIRT)) {
            JSDoublePlantBlock.placeAt((LevelAccessor)level, state, spreadTo, 3);
        }
    }

    public void playerDestroy(@NotNull Level level, Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity entity, @NotNull ItemStack stack) {
        if (player.isCreative()) {
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            player.causeFoodExhaustion(0.005f);
            return;
        }
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), entity, stack);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF});
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }
}

