/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import java.util.stream.Stream;
import jp.jurassicsaga.server.base.block.obj.JSBlockStateProperties;
import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.SegmentPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTallPlantBlock
extends JSPlantBlock {
    public static final EnumProperty<SegmentPart> SEGMENT = JSBlockStateProperties.SEGMENTED;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected final int wantedSegmentCount;

    public JSTallPlantBlock(int wantedSegmentCount, BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
        this.wantedSegmentCount = wantedSegmentCount > 9 ? 8 : wantedSegmentCount;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(SEGMENT, (Comparable)((Object)SegmentPart.SEGMENT_1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SEGMENT});
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (level instanceof ServerLevel && state.getBlock() == this && state.hasProperty(JSBlockStateProperties.SEGMENTED) && state.getValue(JSBlockStateProperties.SEGMENTED) == SegmentPart.SEGMENT_1) {
            this.updateSegments(level, pos);
        }
    }

    @Override
    protected void randomTick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isLoaded(pos)) {
            return;
        }
        if (random.nextInt(50) < 50) {
            return;
        }
        if (level.getMaxLocalRawBrightness(pos.above()) >= 9 && random.nextInt(4) == 0 && level.getBlockState(pos.above()).isAir() && this.countSegments((BlockGetter)level, pos) < this.wantedSegmentCount) {
            level.setBlock(pos.above(), this.defaultBlockState(), 2);
        }
        if (state.getValue(JSBlockStateProperties.SEGMENTED) == SegmentPart.getSegment(this.wantedSegmentCount - 1)) {
            super.randomTick(state, level, pos, random);
        }
    }

    public void destroy(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.destroy(level, pos, state);
        if (level instanceof Level) {
            Level actualLevel = (Level)level;
            this.updateSegments(actualLevel, pos.below());
        }
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        this.updateSegments(level, pos.below());
    }

    public int countSegments(BlockGetter worldIn, BlockPos pos) {
        for (int i = 0; i < this.wantedSegmentCount + 1; ++i) {
            BlockState state = worldIn.getBlockState(pos.below(i));
            if (state.getBlock() == this) {
                continue;
            }
            return i;
        }
        return -1;
    }

    protected boolean canBeReplaced(BlockState state, @NotNull Fluid fluid) {
        return state.getValue(JSBlockStateProperties.SEGMENTED) == SegmentPart.getSegment(this.wantedSegmentCount - 1);
    }

    public void updateSegments(Level worldIn, BlockPos pos) {
        for (int i = 0; i < this.wantedSegmentCount; ++i) {
            BlockState block = worldIn.getBlockState(pos.below(i));
            if (block.getBlock() != this || !block.hasProperty(JSBlockStateProperties.SEGMENTED)) {
                return;
            }
            SegmentPart part = SegmentPart.getSegment(i);
            BlockState bs = (BlockState)this.defaultBlockState().setValue(SEGMENT, (Comparable)((Object)part));
            worldIn.setBlockAndUpdate(pos.below(i), bs);
        }
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return super.mayPlaceOn(state, level, pos) || level.getBlockState(pos).getBlock() == this && this.countSegments(level, pos) < this.wantedSegmentCount;
    }

    @Override
    public void performBonemeal(@NotNull ServerLevel level, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.performBonemeal(level, random, pos, state);
        if (level.getBlockState(pos.above()).getBlock() == Blocks.AIR && this.mayPlaceOn(level.getBlockState(pos), (BlockGetter)level, pos)) {
            level.setBlockAndUpdate(pos.relative(Direction.UP), this.defaultBlockState());
            this.updateSegments((Level)level, pos.above());
        } else {
            Block block = level.getBlockState(pos.above()).getBlock();
            if (block instanceof JSTallPlantBlock) {
                JSTallPlantBlock block2 = (JSTallPlantBlock)block;
                block2.performBonemeal(level, random, pos.above(), state);
            }
        }
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 vec3d = state.getOffset(level, pos);
        return SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        this.updateSegments(level, pos.above());
    }

    @Override
    public boolean isSpreadSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return state.getValue(SEGMENT) == SegmentPart.getSegment(this.wantedSegmentCount - 1) && super.isSpreadSuccess(level, random, pos, state);
    }

    @Override
    public int getNumberOfNeibours(Level worldIn, BlockPos originalPos) {
        int spreadXz = 5;
        int y = 2;
        Stream e = BlockPos.MutableBlockPos.betweenClosedStream((AABB)AABB.of((BoundingBox)new BoundingBox(-spreadXz, -y, -spreadXz, spreadXz, y, spreadXz)).move(originalPos));
        Stream<BlockPos> filtered = e.filter(blockPos -> worldIn.getBlockState(blockPos).getBlock() == this && worldIn.getBlockState(blockPos).getValue(SEGMENT) == SegmentPart.getSegment(this.wantedSegmentCount - 1));
        return (int)filtered.count() - 1;
    }

    public int getWantedSegmentCount() {
        return this.wantedSegmentCount;
    }
}

