/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.egg;

import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersMain;

public class EggEntity
extends Mob {
    private static final EntityDataAccessor<Integer> hatchTicks = SynchedEntityData.defineId(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> hatched = SynchedEntityData.defineId(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<CompoundTag> gene_data = SynchedEntityData.defineId(EggEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final int DECAY_TICKS = 2000;
    private int maxTicks;
    private int decayTicks;
    private JSAnimal<?> animal = null;
    private JSGeneData data = new JSGeneData();
    private EntityDimensions dimensions = null;

    public EggEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createLivingAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    public void tick() {
        super.tick();
        if (!((Boolean)this.entityData.get(hatched)).booleanValue()) {
            JSAnimations.IDLE.sendForEntity((Entity)this);
            if (this.animal != null) {
                int maxTicks = this.getMaxHatchTicks();
                int ticks = this.getHatchTicks();
                if (++ticks >= maxTicks) {
                    this.hatch();
                    this.setHatchTicks(ticks);
                    return;
                }
                this.setHatchTicks(ticks);
            }
        } else {
            JSAnimations.OPEN_HOLD.sendForEntity((Entity)this);
            if (this.decayTicks < 2000) {
                ++this.decayTicks;
            } else {
                this.kill();
            }
        }
    }

    private void hatch() {
        JSAnimalBase base = (JSAnimalBase)((EntityType)this.animal.getEntityType().get()).create(this.level());
        if (base == null) {
            return;
        }
        base.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
        base.teleportRelative(this.position().x, this.position().y, this.position().z);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            base.finalizeSpawn((ServerLevelAccessor)level2, level2.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.SPAWN_EGG, null);
            level2.addFreshEntity((Entity)base);
            this.entityData.set(hatched, (Object)true);
            base.getModules().getMetabolismModule().setMax();
            base.getModules().getGeneticModule().setGeneData(this.data);
        }
    }

    @NotNull
    public PushReaction getPistonPushReaction() {
        return PushReaction.DESTROY;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(hatchTicks, (Object)0);
        builder.define(hatched, (Object)false);
        builder.define(gene_data, (Object)new CompoundTag());
        super.defineSynchedData(builder);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setHatchTicks(compound.getInt("js.hatch_ticks"));
        this.setMaxHatchTicks(compound.getInt("js.max_hatch_ticks"));
        this.decayTicks = compound.getInt("js.decay");
        this.entityData.set(hatched, (Object)compound.getBoolean("js.hatched"));
        CompoundTag tag = compound.getCompound("js.animal");
        this.data.loadFromNbt(tag);
        this.entityData.set(gene_data, (Object)tag);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("js.hatch_ticks", this.getHatchTicks());
        compound.putInt("js.max_hatch_ticks", this.getMaxHatchTicks());
        compound.putInt("js.decay", this.decayTicks);
        compound.putBoolean("js.hatched", ((Boolean)this.entityData.get(hatched)).booleanValue());
        CompoundTag tag = new CompoundTag();
        this.data.saveToNbt(tag);
        compound.put("js.animal", (Tag)tag);
    }

    private int getHatchTicks() {
        return (Integer)this.entityData.get(hatchTicks);
    }

    private void setHatchTicks(int anInt) {
        this.entityData.set(hatchTicks, (Object)anInt);
    }

    private int getMaxHatchTicks() {
        return this.maxTicks;
    }

    public void setMaxHatchTicks(int maxHatchTicks) {
        this.maxTicks = maxHatchTicks;
    }

    public float getSize() {
        if (this.animal == null) {
            this.animal = this.getAnimal();
        }
        if (this.animal != null) {
            return (float)this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale();
        }
        return 1.0f;
    }

    @NotNull
    protected AABB makeBoundingBox() {
        if (this.data == null) {
            return this.getDefaultDimensions(this.getPose()).makeBoundingBox(this.position());
        }
        JSAnimal<?> animal1 = this.getAnimal();
        if (animal1 == null) {
            return this.getDefaultDimensions(this.getPose()).makeBoundingBox(this.position());
        }
        if (this.dimensions == null) {
            if (this.animal != null) {
                float xz = (float)((double)0.325f * this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale());
                float y = (float)((double)0.525f * this.animal.getAnimalAttributes().getGeneticProperties().getEggRenderScale());
                this.dimensions = EntityDimensions.scalable((float)xz, (float)y);
            } else {
                return this.getDefaultDimensions(this.getPose()).makeBoundingBox(this.position());
            }
        }
        return this.dimensions.makeBoundingBox(this.position());
    }

    private JSAnimal<?> getAnimal() {
        return JSAnimals.getAnimal(this.data.getDataOwnerName());
    }

    public void checkDespawn() {
        if (((Boolean)this.entityData.get(hatched)).booleanValue()) {
            super.checkDespawn();
        }
    }

    protected void tickDeath() {
        this.level().broadcastEntityEvent((Entity)this, (byte)60);
        this.remove(Entity.RemovalReason.KILLED);
    }

    public void handleDamageEvent(DamageSource damageSource) {
        if (damageSource.is(DamageTypes.PLAYER_ATTACK)) {
            super.handleDamageEvent(damageSource);
        }
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        if (damageSource.is(DamageTypes.PLAYER_ATTACK) || damageSource.is(DamageTypes.GENERIC_KILL) && ((Boolean)this.entityData.get(hatched)).booleanValue()) {
            super.actuallyHurt(damageSource, damageAmount);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.PLAYER_ATTACK) || source.is(DamageTypes.GENERIC_KILL) && ((Boolean)this.entityData.get(hatched)).booleanValue()) {
            return super.hurt(source, amount);
        }
        return false;
    }

    public void setData(JSGeneData data) {
        this.entityData.set(gene_data, (Object)data.saveToNbt(new CompoundTag()));
        this.data = data;
        this.animal = data.getAnimal();
        if (!TravelersMain.isDebugging()) {
            this.setMaxHatchTicks(this.animal.getAnimalAttributes().getGeneticProperties().getEggHatchTicks());
        } else {
            this.setMaxHatchTicks(5);
        }
    }
}

