/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other;

import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.networking.obj.OpenGui;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.util.helper.TravelersPacketDistributor;

public class PaddockSignEntity
extends HangingEntity {
    private static final EntityDataAccessor<String> ANIMAL = SynchedEntityData.defineId(PaddockSignEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public PaddockSignEntity(EntityType<? extends HangingEntity> pEntityType, Level pLevel, BlockPos pPos) {
        super(pEntityType, pLevel, pPos);
    }

    public PaddockSignEntity(EntityType<PaddockSignEntity> nwMuralSignEntityEntityType, Level level) {
        super(nwMuralSignEntityEntityType, level);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        Level level = player.level();
        if (!level.isClientSide) {
            this.playPlacementSound();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TravelersPacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenGui(level.dimension().location(), "paddock_screen", this.getId()));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected AABB calculateBoundingBox(@NotNull BlockPos pPos, @NotNull Direction pDirection) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pPos).relative(pDirection, -0.46875);
        Vec3 vec31 = vec3.relative(pDirection, 0.0).relative(Direction.UP, 0.0);
        Direction.Axis direction$axis = pDirection.getAxis();
        double d2 = direction$axis == Direction.Axis.X ? 0.0625 : 1.0;
        double d3 = 1.0;
        double d4 = direction$axis == Direction.Axis.Z ? 0.0625 : 1.0;
        return AABB.ofSize((Vec3)vec31, (double)d2, (double)d3, (double)d4);
    }

    public void dropItem(@Nullable Entity pEntity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player player;
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (pEntity instanceof Player && (player = (Player)pEntity).hasInfiniteMaterials()) {
                return;
            }
            this.spawnAtLocation(this.getPickResult());
        }
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> pKey) {
        if (ANIMAL.equals(pKey)) {
            this.recalculateBoundingBox();
        }
    }

    @Nullable
    public JSAnimal<?> getAnimal() {
        return JSAnimals.getAnimal((String)this.entityData.get(ANIMAL));
    }

    public void setAnimal(String variant) {
        this.entityData.set(ANIMAL, (Object)variant);
    }

    public void setAnimal(JSAnimal<?> variant) {
        if (variant == null) {
            return;
        }
        this.setAnimal(variant.getAnimalAttributes().getAnimalName());
    }

    public String getAnimalStr() {
        return (String)this.entityData.get(ANIMAL);
    }

    public void setDirection(@NotNull Direction pFacingDirection) {
        super.setDirection(pFacingDirection);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putString("variant", (String)this.entityData.get(ANIMAL));
        pCompound.putByte("facing", (byte)this.direction.get2DDataValue());
        super.addAdditionalSaveData(pCompound);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        this.setAnimal(pCompound.getString("variant"));
        this.direction = Direction.from2DDataValue((int)pCompound.getByte("facing"));
        super.readAdditionalSaveData(pCompound);
        this.setDirection(this.direction);
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    public void moveTo(double pX, double pY, double pZ, float pYaw, float pPitch) {
        this.setPos(pX, pY, pZ);
    }

    public void lerpTo(double pX, double pY, double pZ, float pYRot, float pXRot, int pSteps) {
        this.setPos(pX, pY, pZ);
    }

    @NotNull
    public Vec3 trackingPosition() {
        return Vec3.atLowerCornerOf((Vec3i)this.pos);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity pEntity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        this.setDirection(Direction.from3DDataValue((int)pPacket.getData()));
    }

    @NotNull
    public ItemStack getPickResult() {
        return ((Item)JSV1Items.PADDOCK_SIGN.get()).getDefaultInstance();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(ANIMAL, (Object)"");
    }
}

