/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.other;

import jp.jurassicsaga.server.base.entity.JSEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SeatEntity
extends Entity {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3 relativePos;
    private boolean interacteAble;

    public SeatEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public SeatEntity(Level world, Vec3 pos) {
        this(world, pos, false);
    }

    public SeatEntity(Level world, Vec3 pos, boolean canBeInteractedWith) {
        super((EntityType)JSEntities.SEAT.get(), world);
        this.setPos(pos);
        this.relativePos = pos;
        this.interacteAble = canBeInteractedWith;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    public void tick() {
        super.tick();
        this.tickLerp();
        if (!this.interacteAble && this.getPassengers().isEmpty() && !this.level().isClientSide) {
            this.discard();
        }
    }

    public boolean isColliding(@NotNull BlockPos pos, @NotNull BlockState state) {
        return false;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    public boolean canFreeze() {
        return false;
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return false;
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public boolean canChangeDimensions(@NotNull Level oldLevel, @NotNull Level newLevel) {
        return false;
    }

    public boolean isControlledByLocalInstance() {
        return false;
    }

    public void tickLerp() {
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    public boolean hasNoPassenger() {
        return this.getPassengers().isEmpty();
    }

    public Entity getFirstPassenger() {
        return this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().getFirst();
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        if (!this.getPassengers().isEmpty()) {
            this.lerpX = x;
            this.lerpY = y;
            this.lerpZ = z;
            this.lerpYRot = yRot;
            this.lerpXRot = xRot;
            this.lerpSteps = 10;
        } else {
            this.setPos(x, y, z);
            this.setRot(yRot, xRot);
        }
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    public void load(@NotNull CompoundTag compound) {
    }

    public boolean isCrouching() {
        return false;
    }

    public boolean isCustomNameVisible() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isEffectiveAi() {
        return false;
    }

    public boolean isInLava() {
        return false;
    }

    public boolean isInLiquid() {
        return false;
    }

    public boolean isInWater() {
        return false;
    }

    public boolean isInWaterOrRain() {
        return false;
    }

    public boolean isInWall() {
        return false;
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        return false;
    }

    public Vec3 getRelativePos() {
        return this.relativePos;
    }
}

