/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersItems;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.util.JSHelper;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.util.helper.TravelersRegistry;

public class JSItemGroups {
    public static final TravelersRegistry<CreativeModeTab> TABS = new TravelersRegistry(BuiltInRegistries.CREATIVE_MODE_TAB, "jurassicsaga");
    public static final Supplier<CreativeModeTab> ITEMS = TABS.register("js.items", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.items"), JSV1Items.PADDOCK_SIGN, (parameters, output) -> {
        ArrayList<TravelersItemInterface> ITEM_ARRAY = new ArrayList<TravelersItemInterface>();
        ArrayList<TravelersItemInterface> EXTINCT_ITEM_ARRAY = new ArrayList<TravelersItemInterface>();
        for (JSAnimal<?> jSAnimal : JSAnimals.getAnimals()) {
            if (jSAnimal.getAnimalAttributes().getMiscProperties().isExtinct()) {
                EXTINCT_ITEM_ARRAY.add(jSAnimal.getItems());
            }
            ITEM_ARRAY.add(jSAnimal.getItems());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (jSTravelersItems.getHatched_egg() == null) continue;
            output.accept((ItemLike)jSTravelersItems.getHatched_egg().get());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (jSTravelersItems.getBucket() == null) continue;
            output.accept((ItemLike)jSTravelersItems.getBucket().get());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (jSTravelersItems.getCoin() == null) continue;
            output.accept((ItemLike)jSTravelersItems.getCoin().get());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            if (jSTravelersItems.getCookedMeat() == null) continue;
            output.accept((ItemLike)jSTravelersItems.getCookedMeat().get());
            output.accept((ItemLike)jSTravelersItems.getRawMeat().get());
        }
        for (JSTravelersItems jSTravelersItems : EXTINCT_ITEM_ARRAY) {
            output.accept((ItemLike)jSTravelersItems.getFossil_remains().get());
        }
        for (JSTravelersItems jSTravelersItems : ITEM_ARRAY) {
            jSTravelersItems.getCustom_items().forEach((droppableItem, itemDeferredItem) -> output.accept((ItemLike)itemDeferredItem.get()));
        }
        for (Iterator<JSAnimal<Object>> iterator : Era.values()) {
            ((Era)((Object)((Object)((Object)iterator)))).getRegistryMap().forEach((result, itemDeferredItem) -> output.accept((ItemLike)itemDeferredItem.get()));
        }
        output.accept((ItemLike)JSItems.GUIDEBOOK.get());
        output.accept((ItemLike)JSV1Items.CLICKER.get());
        output.accept((ItemLike)JSV1Items.KEYCARD.get());
        output.accept((ItemLike)JSV1Items.EMPTY_TEST_TUBE.get());
        output.accept((ItemLike)JSV1Items.SYRINGE.get());
        output.accept((ItemLike)JSV1Items.RED_EYED_TREE_FROG.get());
        output.accept((ItemLike)JSV1Items.REED_FROG.get());
        output.accept((ItemLike)JSV1Items.MOSQUITO.get());
        output.accept((ItemLike)JSV1Items.SQUID.get());
        output.accept((ItemLike)JSV1Items.SQUID_COOKED.get());
        output.accept((ItemLike)JSV1Items.PADDOCK_SIGN.get());
        output.accept((ItemLike)JSV1Items.ALLIGATOR_EGG.get());
        output.accept((ItemLike)JSV1Items.FISH_EGG.get());
        output.accept((ItemLike)JSV1Items.OSTRICH_EGG.get());
        output.accept((ItemLike)JSV1Items.FROG_EGG.get());
        output.accept((ItemLike)JSV1Items.BASILISK_EGG.get());
        output.accept((ItemLike)JSV1Items.SPIDER_EGG.get());
    }));
    public static final Supplier<CreativeModeTab> BLOCKS = TABS.register("js.blocks", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.blocks"), (Supplier<Item>)((Supplier)() -> ((Block)JSV1Blocks.BIG_TILE.get()).asItem()), (parameters, output) -> {
        HashSet added = new HashSet();
        Consumer<ItemLike> safeOutput = item -> {
            if (added.add(item)) {
                output.accept(item);
            }
        };
        JSV1Blocks.addBlocks(safeOutput).run();
    }));
    public static final Supplier<CreativeModeTab> PLANTS = TABS.register("js.plants", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.plants"), (Supplier<Item>)((Supplier)() -> ((Block)JSV1Blocks.SWISS_CHEESE_PLANT.get()).asItem()), (parameters, output) -> {
        HashSet added = new HashSet();
        Consumer<ItemLike> safeOutput = item -> {
            if (added.add(item)) {
                output.accept(item);
            }
        };
        JSV1Blocks.addPlants(safeOutput).run();
    }));
    public static final Supplier<CreativeModeTab> GENETICS = TABS.register("js.genetics", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.genetics"), (Supplier<Item>)((Supplier)() -> (Item)JSGenetics.GENE_ITEMS.get(JSGenetics.LUX).get()), (parameters, output) -> {
        for (Supplier<Item> geneItem : JSGenetics.GENE_ITEMS.values()) {
            output.accept((ItemLike)geneItem.get());
        }
    }));
    public static final Supplier<CreativeModeTab> SPAWN_EGGS = TABS.register("js.spawn_eggs", () -> JSHelper.jsPlatform.registerMenu((Component)Component.translatable((String)"itemGroup.jurassicsaga.spawn_eggs"), (Supplier<Item>)((Supplier)() -> (Item)JSV1Animals.VELOCIRAPTOR.getItems().getSpawnEgg().get()), (parameters, output) -> {
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            output.accept((ItemLike)animal.getItems().getSpawnEgg().get());
        }
    }));

    public static void init() {
    }
}

