/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.generic.networking.obj.OpenGui;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.entity.AnimalEntityPart;
import travelers.util.helper.TravelersPacketDistributor;

public class GuidebookItem
extends Item {
    public GuidebookItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemstack = player.getItemInHand(hand);
            EntityHitResult hitResult = this.getEntityHitResult(level, player, 20.0);
            if (hitResult != null) {
                Entity result;
                Entity entity = hitResult.getEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity e = (LivingEntity)entity;
                    result = this.interactLivingEntity(itemstack, player, e, hand);
                    if (result == InteractionResult.SUCCESS_NO_ITEM_USED) {
                        return InteractionResultHolder.success((Object)itemstack);
                    }
                    return InteractionResultHolder.pass((Object)itemstack);
                }
                result = hitResult.getEntity();
                if (result instanceof AnimalEntityPart) {
                    AnimalEntityPart part = (AnimalEntityPart)result;
                    result = this.interactLivingEntity(itemstack, player, (LivingEntity)part.parentMob, hand);
                    if (result == InteractionResult.SUCCESS_NO_ITEM_USED) {
                        return InteractionResultHolder.success((Object)itemstack);
                    }
                    return InteractionResultHolder.pass((Object)itemstack);
                }
            }
            TravelersPacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenGui(level.dimension().location(), "guidebook", -1));
            return InteractionResultHolder.success((Object)itemstack);
        }
        return super.use(level, player, hand);
    }

    @Nullable
    private EntityHitResult getEntityHitResult(Level level, Player player, double range) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getLookAngle();
        Vec3 end = eyePos.add(lookVec.scale(range));
        AABB aabb = player.getBoundingBox().expandTowards(lookVec.scale(range)).inflate(1.0);
        return ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)eyePos, (Vec3)end, (AABB)aabb, entity -> !entity.isSpectator() && entity.isPickable());
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        JSAnimalBase base;
        if (!player.level().isClientSide && interactionTarget.isAlive() && interactionTarget instanceof JSAnimalBase && (base = (JSAnimalBase)interactionTarget).getAnimal().getAnimalAttributes().getMiscProperties().isShowInGuidebook() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TravelersPacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenGui(player.level().dimension().location(), "guidebook", interactionTarget.getId()));
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }
}

