/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.item.obj.genetics;

import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.OtherDnaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class GeneticsItem
extends Item {
    public GeneticsItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return super.getTooltipImage(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        JSGeneData data = JSGeneUtil.readFromStack(stack);
        if (data.hasData()) {
            if (JSCommon.isShiftKeyDown) {
                ResourceLocation location;
                if (data.getBaseQuality() > 0) {
                    location = ResourceLocation.bySeparator((String)data.getDataOwnerName(), (char)':');
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.species").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("entity." + location.getNamespace() + "." + location.getPath())).withStyle(ChatFormatting.YELLOW)));
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.dna_quality").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(data.getBaseQuality() + "%")).withStyle(data.getBaseQuality() < 90 ? (data.getBaseQuality() < 50 ? (data.getBaseQuality() < 25 ? ChatFormatting.RED : ChatFormatting.YELLOW) : ChatFormatting.GOLD) : ChatFormatting.GREEN)));
                }
                if (data.hasDonor()) {
                    location = ResourceLocation.bySeparator((String)data.getDonorName(), (char)':');
                    tooltipComponents.add((Component)Component.empty());
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.donor_info"));
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.species").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("entity." + location.getNamespace() + "." + location.getPath())).withStyle(ChatFormatting.YELLOW)));
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.dna_quality").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(data.getDonorQuality() + "%")).withStyle(data.getDonorQuality() < 90 ? (data.getDonorQuality() < 50 ? (data.getDonorQuality() < 25 ? ChatFormatting.RED : ChatFormatting.YELLOW) : ChatFormatting.GOLD) : ChatFormatting.GREEN)));
                }
                if (data.getTotalCompletion() == 100) {
                    if (stack.has((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get()) && !data.geneDataHolder.getGENE_SET().isEmpty()) {
                        tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.extractions_remaining", (Object[])new Object[]{stack.get((DataComponentType)JSDataComponents.GENE_EXTRACTOR_TRIES.get())}).withStyle(ChatFormatting.GRAY));
                    }
                    if (!data.geneDataHolder.getGENE_SET().isEmpty()) {
                        tooltipComponents.add((Component)Component.empty());
                        tooltipComponents.add((Component)Component.literal((String)"Genes:"));
                        int i = 0;
                        for (JSGene gene : data.geneDataHolder.getGENE_SET()) {
                            tooltipComponents.add((Component)Component.literal((String)(++i + ". ")).append((Component)gene.getTranslatableObject().withStyle(gene.getToolTipColour())));
                        }
                    }
                } else if (this instanceof DnaItem || this instanceof OtherDnaItem) {
                    tooltipComponents.add((Component)Component.empty());
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.dna_increase_quality").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
                }
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.jurassicsaga.shift_hint").withStyle(ChatFormatting.BLUE));
            }
        }
    }
}

