/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.recipe.craftingtable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.obj.egg.InfertileEggItem;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.base.recipe.JSRecipes;
import jp.jurassicsaga.server.base.recipe.craftingtable.SimpleShapelessRecipe;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class FertilizedEggRecipe
extends SimpleShapelessRecipe {
    public FertilizedEggRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)JSRecipes.FERTILIZED_EGG_SERIALIZER.get();
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        InfertileEggItem item;
        ItemStack item22;
        ItemStack coin = null;
        ItemStack egg = null;
        JSAnimal<?> animal = null;
        int quality = 0;
        for (ItemStack item22 : input.items()) {
            Item item3 = item22.getItem();
            if (item3 instanceof DnaItem) {
                DnaItem dna = (DnaItem)item3;
                coin = item22;
                JSGeneData data = JSGeneUtil.readFromStack(item22);
                animal = dna.getAnimal();
                quality = data.getTotalCompletion();
            }
            if (!item22.is(JSItemTags.UNFERTILIZED_EGGS)) continue;
            egg = item22;
        }
        if (coin == null || egg == null || quality < 100 || animal == null) {
            return ItemStack.EMPTY;
        }
        item22 = egg.getItem();
        if (item22 instanceof InfertileEggItem && (item = (InfertileEggItem)item22).getEggType() == animal.getAnimalAttributes().getItemProperties().getEggtype()) {
            ItemStack eggCopy = ((InfertileEggItem)egg.getItem()).getFertileVersion().getDefaultInstance();
            JSGeneData genData = JSGeneUtil.readFromStack(coin);
            JSGeneUtil.writeToStack(eggCopy, genData);
            return eggCopy;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList nonnulllist = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (ItemStack item : input.items()) {
            if (!(item.getItem() instanceof SyringeItem)) continue;
            ItemStack stack = ((Item)JSV1Items.SYRINGE.get()).getDefaultInstance();
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
            nonnulllist.set(0, (Object)stack);
        }
        return nonnulllist;
    }

    public static class Serializer
    implements RecipeSerializer<FertilizedEggRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, FertilizedEggRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<FertilizedEggRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.ingredients)).apply((Applicative)p_340779_, FertilizedEggRecipe::new));

        private static FertilizedEggRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new FertilizedEggRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FertilizedEggRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }

        @NotNull
        public MapCodec<FertilizedEggRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FertilizedEggRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

