/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSGenderTextureLocator;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.GoatAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class GoatAnimal
extends AbstractJSAnimal<GoatEntity> {
    public GoatAnimal() {
        super("goat");
        this.setAnimator(new GoatAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<GoatEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(7.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(3.0f));
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<GoatEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.SEEDS);
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<GoatEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<GoatEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(12);
        socialGroupProperties.setMaxDistanceToPackLeader(2000.0f);
        socialGroupProperties.setMinDistanceToPackLeader(64.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<GoatEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setSpawnEggColors(15261902, 2497815);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<GoatEntity> attributes, EntityBaseProperties<GoatEntity> base) {
        base.setAnimalType(AnimalType.MAMMAL);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0f);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(0.5f);
        base.setResourceLocator((ResourceLocator)new JSGenderTextureLocator<GoatEntity>(this){

            @Override
            public ResourceLocation getTextureLocation(GoatEntity entity) {
                String entityName = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
                String type = entity.getGoatVariant().getTypeName();
                if (entity.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.ADULT) {
                    return ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("textures/geo/animal/" + entityName + "/" + entityName + "_" + type + "_baby.png"));
                }
                ResourceLocation maleTexture = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("textures/geo/animal/" + entityName + "/" + entityName + "_" + type + "_male.png"));
                ResourceLocation femaleTexture = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)("textures/geo/animal/" + entityName + "/" + entityName + "_" + type + "_female.png"));
                return entity.getModules().getGeneticModule().isMale() ? maleTexture : femaleTexture;
            }
        });
        attributes.setFactory(GoatEntity::new);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(10.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setWaterEfficiency(1.0);
        attributes.setSpawnFar();
        attributes.setDimensions((double)0.85f, (double)0.85f);
        attributes.setMovementSpeed(0.125);
        attributes.setRunningSpeedMultiplier(2.5);
    }
}

