/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.OstrichAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.world.entity.MobCategory;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class OstrichAnimal
extends AbstractJSAnimal<OstrichEntity> {
    public OstrichAnimal() {
        super("ostrich");
        this.setAnimator(new OstrichAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<OstrichEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(7.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(3.0f));
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<OstrichEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.SEEDS);
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<OstrichEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<OstrichEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(12);
        socialGroupProperties.setMaxDistanceToPackLeader(2000.0f);
        socialGroupProperties.setMinDistanceToPackLeader(64.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<OstrichEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(1380103, 15980983);
        itemProperties.setSpawnEggColorsMale(4932666, 15188109);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<OstrichEntity> attributes, EntityBaseProperties<OstrichEntity> base) {
        base.setAnimalType(AnimalType.BIRD);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setMaxTurnRate(13.0f);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(0.8f);
        base.setResourceLocator(new JSAnimalBaseLocator());
        attributes.setFactory(OstrichEntity::new);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(18.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setWaterEfficiency(1.0);
        attributes.setSpawnFar();
        attributes.setDimensions((double)0.9f, 2.0);
        attributes.setMovementSpeed((double)0.255f);
        attributes.setRunningSpeedMultiplier((double)1.6f);
    }
}

