/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extant;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extant.ReedfrogAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.ReedFrogEntity;
import net.minecraft.world.entity.MobCategory;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class ReedFrogAnimal
extends AbstractJSAnimal<ReedFrogEntity> {
    public ReedFrogAnimal() {
        super("reed_frog");
        this.setAnimator(new ReedfrogAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<ReedFrogEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.1f);
        geneticProperties.addGrowthNextStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.1f, 0.1f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(0.7f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(1.0f));
        geneticProperties.setDefaultGenes(JSGenetics.RAINFOREST_COSMETIC, JSGenetics.TOXIC_SKIN);
        geneticProperties.addSupportedGenes(JSGenetics.TOXIC_SKIN, JSGenetics.VENOM_BITE);
        geneticProperties.setSpawnGeneticsDefault();
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<ReedFrogEntity> metabolismProperties) {
        metabolismProperties.disableSleep();
        metabolismProperties.disableBreeding();
        metabolismProperties.setDiet(AnimalDietType.INSECTOVORE, Diets.INSECTOVORE);
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<ReedFrogEntity> miscProperties) {
        miscProperties.setEra(Era.NONE);
        miscProperties.setBabyAnimations();
        miscProperties.setGenderedVariants();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<ReedFrogEntity> socialGroupProperties) {
    }

    @Override
    protected void applyItemProperties(JSItemProperties<ReedFrogEntity> itemProperties) {
        itemProperties.enableCoin();
        itemProperties.disableMeat();
        itemProperties.setEggtype(EggType.FROG);
        itemProperties.setSpawnEggColors(12851200, 14730893);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<ReedFrogEntity> attributes, EntityBaseProperties<ReedFrogEntity> base) {
        base.setAnimalType(AnimalType.AMPHIBIAN);
        base.setSizeClass(AnimalSizeClass.TINY);
        base.setMaxTurnRate(13.0f);
        base.setMaxHeadRotation(120.0, 120.0);
        base.setRenderScale(0.2f);
        base.setSpecialRenderer();
        base.setResourceLocator(new JSAnimalBaseLocator());
        attributes.setFactory(ReedFrogEntity::new);
        attributes.setCategory(MobCategory.WATER_CREATURE);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(5.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions((double)0.4f, (double)0.4f);
        attributes.setMovementSpeed((double)0.1f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
        attributes.setSwimmingSpeedMultiplier((double)2.3f);
        attributes.setWaterEfficiency(1.0);
        attributes.setSpawnFar();
    }
}

