/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.aquatic;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.SampleColour;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.MesolimulusEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class MesolimulusAnimal
extends AbstractJSAnimal<MesolimulusEntity> {
    public MesolimulusAnimal() {
        super("mesolimulus");
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<MesolimulusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(5.0f));
        geneticProperties.addSupportedGenes(JSGenetics.OCEAN_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<MesolimulusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.NONE, Diets.NONE);
        metabolismProperties.disableFood();
        metabolismProperties.disableWater();
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<MesolimulusEntity> miscProperties) {
        miscProperties.setGuidebookOffset(new Vec2(-0.5f, 0.0f), new Vec2(0.5f, 0.0f));
        miscProperties.setGuidebookScaling(new float[]{5.0f, 3.0f});
        miscProperties.setExtinct();
        miscProperties.setEra(Era.TRIASSIC);
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<MesolimulusEntity> socialGroupProperties) {
    }

    @Override
    protected void applyItemProperties(JSItemProperties<MesolimulusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.SPIDER);
        itemProperties.setSpawnEggColors(5129269, 7943454);
        itemProperties.setSpawnEggColorsMale(7298116, 7943454);
        itemProperties.setSampleColour(SampleColour.BLUE);
        itemProperties.setBucketable();
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<MesolimulusEntity> attributes, EntityBaseProperties<MesolimulusEntity> base) {
        base.setAnimalType(AnimalType.CEPHALOPOD);
        base.setSizeClass(AnimalSizeClass.SMALL);
        base.setMaxTurnRate(13.0f);
        base.setMaxHeadRotation(25.0, 30.0);
        base.setRenderScale(0.47f);
        base.setRenderScaleMale(0.37f);
        base.setSpecialRenderer();
        base.setDimensionsMale((double)0.45f, (double)0.2f);
        base.setResourceLocator((ResourceLocator)new JSAnimalBaseLocator<MesolimulusEntity>(this){

            @Override
            public ResourceLocation getModelLocation(MesolimulusEntity entity) {
                String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
                return JSCommon.createId("geo/animal/" + entity_name + "/" + entity_name + ".geo.json");
            }
        });
        attributes.setPersistent();
        attributes.setFactory(MesolimulusEntity::new);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setEyeHeight((double)0.8f);
        attributes.setMaxHealth(12.0);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setDimensions(0.5, 0.25);
        attributes.setMovementSpeed((double)0.15f);
        attributes.setRunningSpeedMultiplier((double)1.2f);
    }
}

