/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.DilophosaurusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ProcompsognathusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalType;

public class DilophosaurusAnimal
extends AbstractJSAnimal<DilophosaurusEntity> {
    public DilophosaurusAnimal() {
        super("dilophosaurus");
        this.setAnimator(new DilophosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<DilophosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.87f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.JUNGLE_COSMETIC, JSGenetics.OCEAN_COSMETIC, JSGenetics.PASTURE_COSMETIC, JSGenetics.RAINFOREST_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<DilophosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setActiveTime(ActiveTime.NOCTURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(1.2f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<DilophosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxTurnRate(9.0f);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setGuidebookScaling(new float[]{1.5f, 1.5f});
        miscProperties.setGuidebookOffset(new Vec2(-1.5f, 0.0f), new Vec2(0.2f, 0.0f));
        miscProperties.setExtinct();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<DilophosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(Villager.class, WanderingTrader.class, GoatEntity.class, ProcompsognathusEntity.class, TroodonEntity.class, OstrichEntity.class, Player.class, Animal.class, GallimimusEntity.class);
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class);
        socialGroupProperties.addHerdTargets(DilophosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<DilophosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(8947023, 5712922);
        itemProperties.setSpawnEggColorsMale(7366442, 2169875);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<DilophosaurusEntity> attributes, EntityBaseProperties<DilophosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90);
        base.setSizeDimorphism(9.0f);
        base.setRenderScale(0.55f);
        base.setResourceLocator(new JSAnimalBaseLocator());
        base.setBabyAnimations();
        base.setTurnSmoothRate(0.6f);
        attributes.setPersistent();
        attributes.setFactory(DilophosaurusEntity::new);
        attributes.setEyeHeight((double)0.85f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(30.0);
        attributes.setDimensions((double)0.7f, (double)1.3f);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(12.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(30.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

