/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.BrachiosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class GallimimusAnimal
extends AbstractJSAnimal<GallimimusEntity> {
    public GallimimusAnimal() {
        super("gallimimus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<GallimimusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(1.1f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(1.5f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(4.0f));
        geneticProperties.addSupportedGenes(JSGenetics.JUNGLE_COSMETIC, JSGenetics.OCEAN_COSMETIC, JSGenetics.RIVER_COSMETIC, JSGenetics.TUNDRA_COSMETIC, JSGenetics.VIVID_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<GallimimusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(0.5f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<GallimimusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxTurnRate(9.0f);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.5f, 0.8f});
        miscProperties.setGuidebookOffset(new Vec2(-1.5f, 0.0f), new Vec2(0.2f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<GallimimusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class);
        socialGroupProperties.addHerdTargets(BrachiosaurusEntity.class, ApatosaurusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, GallimimusEntity.class);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
        socialGroupProperties.enableNesting();
    }

    @Override
    protected void applyItemProperties(JSItemProperties<GallimimusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(12164706, 11898180);
        itemProperties.setSpawnEggColorsMale(12164706, 5728351);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<GallimimusEntity> attributes, EntityBaseProperties<GallimimusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90);
        base.setSizeDimorphism(9.0f);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setRenderScale(1.27f);
        base.setResourceLocator(new JSAnimalBaseLocator());
        attributes.setPersistent();
        attributes.setFactory(GallimimusEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(30.0);
        attributes.setDimensions((double)1.3f, (double)2.4f);
        attributes.setMovementSpeed((double)0.255f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)1.6f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
        attributes.setTrackingRange(64);
    }
}

