/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.BrachiosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TroodonEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class HadrosaurusAnimal
extends AbstractJSAnimal<HadrosaurusEntity> {
    public HadrosaurusAnimal() {
        super("hadrosaurus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<HadrosaurusEntity> geneticProperties) {
        geneticProperties.addSupportedGenes(JSGenetics.OCEAN_COSMETIC);
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(1.0f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<HadrosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(2.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<HadrosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxTurnRate(7.0f);
        miscProperties.setMaxTurnRate(0.5f);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{1.5f, 0.8f});
        miscProperties.setGuidebookOffset(new Vec2(-1.7f, 0.0f), new Vec2(-0.3f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<HadrosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(VelociraptorEntity.class, TroodonEntity.class, DilophosaurusEntity.class, TyrannosaurusEntity.class);
        socialGroupProperties.addHerdTargets(BrachiosaurusEntity.class, ApatosaurusEntity.class, HadrosaurusEntity.class, ParasaurolophusEntity.class, GallimimusEntity.class);
        socialGroupProperties.setMaxHerdSize(40);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<HadrosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(14997942, 8681523);
        itemProperties.setSpawnEggColorsMale(14997942, 10657094);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<HadrosaurusEntity> attributes, EntityBaseProperties<HadrosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90);
        base.setSizeDimorphism(9.0f);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setRenderScale(1.15f);
        base.setResourceLocator(new JSAnimalBaseLocator());
        attributes.setPersistent();
        attributes.setFactory(HadrosaurusEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(80.0);
        attributes.setDimensions(2.0, 2.5);
        attributes.setMovementSpeed((double)0.19f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier((double)2.2f);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
        attributes.setTrackingRange(64);
    }
}

