/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.BasicHerbivoreAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.StegosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class StegosaurusAnimal
extends AbstractJSAnimal<StegosaurusEntity> {
    public StegosaurusAnimal() {
        super("stegosaurus");
        this.setAnimator(new BasicHerbivoreAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<StegosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(1.0f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.setEggRenderScale(1.4f);
        geneticProperties.addSupportedGenes(JSGenetics.TROPICAL_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<StegosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.HERBIVORE, Diets.HERBIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(1.0f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(2.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<StegosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.JURASSIC);
        miscProperties.setMaxTurnRate(7.0f);
        miscProperties.setMaxHeadRotation(25.0f, 30.0f);
        miscProperties.setGuidebookScaling(new float[]{2.0f, 0.5f});
        miscProperties.setGuidebookOffset(new Vec2(-1.0f, 0.0f), new Vec2(0.8f, 0.0f));
        miscProperties.setBabyAnimations();
        miscProperties.enableGuidebookPose();
        miscProperties.setExtinct();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<StegosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addScaredOf(TyrannosaurusEntity.class);
        socialGroupProperties.addHerdTargets(StegosaurusEntity.class);
        socialGroupProperties.setMaxHerdSize(20);
        socialGroupProperties.setMaxDistanceToPackLeader(3200.0f);
        socialGroupProperties.setMinDistanceToPackLeader(800.0f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<StegosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.OSTRICH);
        itemProperties.setSpawnEggColors(4803369, 5455652);
        itemProperties.setSpawnEggColorsMale(4803369, 5650459);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<StegosaurusEntity> attributes, EntityBaseProperties<StegosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90);
        base.setSizeDimorphism(9.0f);
        base.setSizeClass(AnimalSizeClass.MEDIUM);
        base.setTurnSmoothRate(0.8f);
        base.setRenderScale(1.85f);
        base.setResourceLocator(new JSAnimalBaseLocator());
        attributes.setPersistent();
        attributes.setFactory(StegosaurusEntity::new);
        attributes.setEyeHeight((double)0.9f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(80.0);
        attributes.setDimensions(3.0, 4.0);
        attributes.setMovementSpeed((double)0.12f);
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(1.5);
        attributes.setAttackDamage(4.0);
        attributes.setAttackSpeed(1.0);
        attributes.setAttackKnockback(0.0);
        attributes.setFollowRange(64.0);
        attributes.setTrackingRange(64);
    }
}

