/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animals.extinct.terrestial;

import java.util.Locale;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.animal.obj.AbstractJSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMetabolismProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSSocialGroupProperties;
import jp.jurassicsaga.server.base.animal.obj.locator.JSAnimalBaseLocator;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import jp.jurassicsaga.server.v1.animal.animations.extinct.terrestial.TyrannosaurusAnimations;
import jp.jurassicsaga.server.v1.animal.entity.extant.GoatEntity;
import jp.jurassicsaga.server.v1.animal.entity.extant.OstrichEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ApatosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DilophosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.DryosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.GallimimusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.HadrosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.ParasaurolophusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.StegosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TriceratopsEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.TyrannosaurusEntity;
import jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial.VelociraptorEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;
import travelers.server.animal.obj.attributes.EntityBaseProperties;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalType;

public class TyrannosaurusAnimal
extends AbstractJSAnimal<TyrannosaurusEntity> {
    public TyrannosaurusAnimal() {
        super("tyrannosaurus");
        this.setAnimator(new TyrannosaurusAnimations());
    }

    @Override
    protected void applyGeneticProperties(JSGeneticProperties<TyrannosaurusEntity> geneticProperties) {
        geneticProperties.addGrowthStageScaling(0.2f);
        geneticProperties.addGrowthStageSize(0.4f, 0.5f);
        geneticProperties.addGrowthNextStageScaling(0.87f);
        geneticProperties.addGrowthStageMaxGrowth((int)JSUtils.toTicksMCDays(2.0f));
        geneticProperties.setGrowthProgressCap((int)JSUtils.toTicksMCDays(6.0f));
        geneticProperties.addSupportedGenes(JSGenetics.FOREST_COSMETIC, JSGenetics.RIVER_COSMETIC);
    }

    @Override
    protected void applyMetabolismProperties(JSMetabolismProperties<TyrannosaurusEntity> metabolismProperties) {
        metabolismProperties.setDiet(AnimalDietType.CARNIVORE, Diets.CARNIVORE);
        metabolismProperties.setActiveTime(ActiveTime.DIURNAL);
        metabolismProperties.setMaxWater((int)JSUtils.toTicksMCDays(1.2f));
        metabolismProperties.setMaxFood((int)JSUtils.toTicksMCDays(1.0f));
    }

    @Override
    protected void applyMiscProperties(JSMiscProperties<TyrannosaurusEntity> miscProperties) {
        miscProperties.setEra(Era.CRETACEOUS);
        miscProperties.setMaxTurnRate(9.0f);
        miscProperties.setMaxHeadRotation(20.0f, 46.0f);
        miscProperties.setBabyAnimations();
        miscProperties.setGuidebookScaling(new float[]{1.5f, 0.535f});
        miscProperties.setGuidebookOffset(new Vec2(0.7f, 0.0f), new Vec2(-1.0f, 0.0f));
        miscProperties.setExtinct();
    }

    @Override
    protected void applySocialProperties(JSSocialGroupProperties<TyrannosaurusEntity> socialGroupProperties) {
        socialGroupProperties.addHuntTargets(Villager.class, Illusioner.class, Pillager.class, Player.class, Animal.class, GoatEntity.class, DryosaurusEntity.class, OstrichEntity.class, ApatosaurusEntity.class, TriceratopsEntity.class, VelociraptorEntity.class, DilophosaurusEntity.class, StegosaurusEntity.class, GallimimusEntity.class, ParasaurolophusEntity.class, HadrosaurusEntity.class, OstrichEntity.class, TraderLlama.class, WanderingTrader.class);
        socialGroupProperties.addHerdTargets(TyrannosaurusEntity.class);
        socialGroupProperties.setMaxDistanceToPackLeader(900.0f);
        socialGroupProperties.setMinDistanceToPackLeader(400.0f);
        socialGroupProperties.setMaxHerdSize(3);
        socialGroupProperties.setNaturalAggression(0.2f);
    }

    @Override
    protected void applyItemProperties(JSItemProperties<TyrannosaurusEntity> itemProperties) {
        itemProperties.setEggtype(EggType.ALLIGATOR);
        itemProperties.setSpawnEggColors(5193267, 10519632);
        itemProperties.setSpawnEggColorsMale(3357982, 11904615);
    }

    @Override
    protected void applyTravelersProperties(EntityAttributeProperties<TyrannosaurusEntity> attributes, EntityBaseProperties<TyrannosaurusEntity> base) {
        base.setAnimalType(AnimalType.REPTILE);
        base.setFov(90);
        base.setSizeDimorphism(7.0f);
        base.setRenderScale(2.2f);
        base.setResourceLocator((ResourceLocator)new JSAnimalBaseLocator<TyrannosaurusEntity>(this){

            @Override
            public ResourceLocation getTextureLocation(TyrannosaurusEntity entity) {
                Component customName = entity.getCustomName();
                if (customName != null && customName.getString().toLowerCase(Locale.ROOT).contains("cyclops")) {
                    JSVariants.JSVariant variant;
                    String entity_name = entity.getAnimal().getAnimalAttributes().getAnimalName().toLowerCase();
                    if (entity.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && (variant = JSVariants.fromLocation((String)entity.getEntityData().get(JSEntityDataHolder.textureVariant))) == JSVariants.FOREST) {
                        return ResourceLocation.fromNamespaceAndPath((String)JSVariants.FOREST.location().getNamespace(), (String)("textures/geo/animal/" + entity_name + "/variants/" + entity_name + "_adult_forest_secret.png"));
                    }
                }
                return super.getTextureLocation(entity);
            }
        });
        base.setBabyAnimations();
        base.setTurnSmoothRate(0.4f);
        attributes.setPersistent();
        attributes.setFactory(TyrannosaurusEntity::new);
        attributes.setEyeHeight((double)0.95f);
        attributes.setCategory(MobCategory.CREATURE);
        attributes.setMaxHealth(90.0);
        attributes.setDimensions(3.0, 6.0);
        attributes.setMovementSpeed(JSUtils.kmhToSpeed(18.0));
        attributes.setWaterEfficiency((double)0.8f);
        attributes.setRunningSpeedMultiplier(2.25);
        attributes.setAttackDamage(30.0);
        attributes.setAttackSpeed(4.0);
        attributes.setAttackKnockback(1.0);
        attributes.setFollowRange(64.0);
    }
}

