/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animations.extant;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.animations.JSAnimator;
import jp.jurassicsaga.server.v1.animal.entity.extant.BasiliskEntity;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.minecraft.world.entity.Entity;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;

public class BasiliskAnimations
extends JSAnimator<BasiliskEntity> {
    @Override
    public void animate(BasiliskEntity base, MoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead()) {
            JSAnimations.DEATH.sendForEntity((Entity)base);
            return;
        }
        if (animationManager.playTransition(base.isSleeping(), JSAnimations.SLEEP_IN.wrap(63), JSAnimations.SLEEP_LOOP.wrap(), JSAnimations.SLEEP_OUT.wrap(39))) {
            return;
        }
        if (base.curAttackTicks > 0) {
            JSAnimations.ATTACK.sendForEntity((Entity)base);
            return;
        }
        if (base.curInjuredTicks > 0) {
            JSAnimations.INJURED.sendForEntity((Entity)base);
            return;
        }
        if (base.curEatTicks > 0) {
            JSAnimations.EAT.sendForEntity((Entity)base);
            return;
        }
        if (base.getTarget() != null && moveAnalysis.isMoving() && base.isStalking() && !base.isRunning()) {
            JSAnimations.STALK.sendForEntity((Entity)base);
            return;
        }
        if (!base.isInWater()) {
            if (base.onGround()) {
                if (moveAnalysis.isMoving()) {
                    if (base.isRunning()) {
                        JSAnimations.RUN.sendForEntity((Entity)base);
                    } else {
                        JSAnimations.WALK.sendForEntity((Entity)base);
                    }
                } else {
                    JSAnimations.IDLE.sendForEntity((Entity)base);
                }
            }
        } else if (base.onGround()) {
            if (base.isMoving()) {
                if (base.isRunning()) {
                    JSAnimations.RUN.sendForEntity((Entity)base);
                } else {
                    JSAnimations.WALK.sendForEntity((Entity)base);
                }
            } else {
                JSAnimations.IDLE.sendForEntity((Entity)base);
            }
        } else if (base.getDeltaMovement().horizontalDistanceSqr() > 0.0) {
            JSAnimations.SWIM.sendForEntity((Entity)base);
        } else {
            JSAnimations.IDLE_IN_WATER.sendForEntity((Entity)base);
        }
    }
}

