/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.animations.extinct.aquatic;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.animations.JSAnimator;
import jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic.TylosaurusEntity;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.minecraft.world.entity.Entity;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;

public class TylosaurusAnimations
extends JSAnimator<TylosaurusEntity> {
    @Override
    public void animate(TylosaurusEntity base, MoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
        if (base.isDead()) {
            if (base.isInWater()) {
                JSAnimations.DEATH.sendForEntity((Entity)base);
            } else {
                JSAnimations.ON_LAND_DEATH.sendForEntity((Entity)base);
            }
            return;
        }
        if (base.curInjuredTicks > 0) {
            if (base.isInWater()) {
                JSAnimations.INJURED.sendForEntity((Entity)base);
            } else {
                JSAnimations.ON_LAND_INJURED.sendForEntity((Entity)base);
            }
            return;
        }
        if (base.curAttackTicks > 0) {
            if (base.isInWater()) {
                JSAnimations.ATTACK.sendForEntity((Entity)base);
            } else {
                JSAnimations.ON_LAND_INJURED.sendForEntity((Entity)base);
            }
            return;
        }
        if (animationManager.playTransition(base.isLeaping(), JSAnimations.JUMP_START.wrap(13), JSAnimations.JUMP_LOOP.wrap(), JSAnimations.JUMP_END.wrap(26))) {
            return;
        }
        if (base.isInWater()) {
            if (base.getDeltaMovement().horizontalDistanceSqr() > 0.0) {
                if (base.isRunning()) {
                    JSAnimations.SWIM_FAST.sendForEntity((Entity)base);
                } else {
                    JSAnimations.SWIM.sendForEntity((Entity)base);
                }
            } else {
                JSAnimations.IDLE.sendForEntity((Entity)base);
            }
        } else {
            JSAnimations.BEACHED.sendForEntity((Entity)base);
        }
    }
}

