/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.aquatic;

import java.util.List;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAmphibiousBase;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.MesolimulusPathTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersAmphibiousNavigation;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class MesolimulusEntity
extends JSAmphibiousBase
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(MesolimulusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_FLIPPED = SynchedEntityData.defineId(MesolimulusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int flipTicks = 0;
    private int unflipTicks = 0;

    public MesolimulusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        SoundType soundtype = state.getSoundType();
        this.playSound((SoundEvent)JSV1Sounds.MESOLIMLUS_WALK.get(), this.getSoundVolume(), soundtype.getPitch());
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new MesolimulusPathTask(this));
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.flipTicks > 0) {
            --this.flipTicks;
        }
        if (this.unflipTicks > 0) {
            --this.unflipTicks;
        }
        if (this.onGround() && !this.isInWater()) {
            if (!this.isFlipped()) {
                if (this.random.nextFloat() < 5.0E-4f) {
                    this.navigation.stop();
                    this.flip();
                }
            } else {
                List list = this.level().getNearbyEntities(MesolimulusEntity.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getBoundingBox().inflate(1.5));
                if (!list.isEmpty()) {
                    if (this.random.nextFloat() < 0.5f) {
                        this.unflip();
                    }
                } else if (this.random.nextFloat() < 5.0f) {
                    this.unflip();
                }
            }
        }
        if (this.isFlipped() && this.isInWater()) {
            this.unflip();
        }
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        TravelersAmphibiousNavigation nav = new TravelersAmphibiousNavigation((SmartAnimalBase)this, level, false);
        nav.setCanFloat(false);
        return nav;
    }

    public boolean isFlipped() {
        return (Boolean)this.entityData.get(IS_FLIPPED);
    }

    private void flip() {
        this.flipTicks = 20;
        this.entityData.set(IS_FLIPPED, (Object)true);
    }

    private void unflip() {
        this.unflipTicks = 20;
        this.entityData.set(IS_FLIPPED, (Object)false);
    }

    @Override
    protected boolean usesAir() {
        return false;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setFromBucket(pCompound.getBoolean("FromBucket"));
        this.entityData.set(IS_FLIPPED, (Object)pCompound.getBoolean("js.isFlipped"));
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("FromBucket", this.fromBucket());
        pCompound.putBoolean("js.isFlipped", this.isFlipped());
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean pFromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)pFromBucket);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(FROM_BUCKET, (Object)false);
        pBuilder.define(IS_FLIPPED, (Object)false);
    }

    @Override
    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        return Bucketable.bucketMobPickup((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(this.checkFlipInteract(pPlayer, pHand));
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (amount > 0.0f && (source.is(DamageTypes.MOB_ATTACK) || source.is(DamageTypes.PLAYER_ATTACK)) && this.flipTicks == 0 && this.getRandom().nextFloat() < 0.2f && !this.isDead()) {
            if (this.isFlipped()) {
                this.unflip();
            } else {
                this.flip();
            }
        }
        return super.hurt(source, amount);
    }

    private InteractionResult checkFlipInteract(Player pPlayer, InteractionHand pHand) {
        if (this.isFlipped()) {
            this.unflip();
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public void saveToBucketTag(@NotNull ItemStack pStack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)pStack);
    }

    public void loadFromBucketTag(@NotNull CompoundTag pTag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)pTag);
    }

    public ItemStack getBucketItemStack() {
        return ((Item)this.getAnimal().getItems().getBucket().get()).getDefaultInstance();
    }

    @NotNull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    @Override
    protected double getSinkRate() {
        return 0.02f;
    }
}

