/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRoarTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class TyrannosaurusEntity
extends JSAnimalBase {
    public TyrannosaurusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(16, 4));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new JSRoarTask(this, JSAnimations.ROAR_1.soundAndLength((SoundEvent)JSV1Sounds.TYRANNOSAURUS_ROAR1.get(), 87, 0, 30), JSAnimations.ROAR_2.soundAndLength((SoundEvent)JSV1Sounds.TYRANNOSAURUS_ROAR2.get(), 120, 18, 22)));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    public int shakeLength() {
        return 12;
    }

    @Override
    public float shakeAmount() {
        return 0.9f;
    }

    @Override
    public float shakeDistance() {
        return 60.0f;
    }

    @Override
    public float maxUpStep() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() != AnimalGrowthStage.BABY) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.getRenderScale() > 2.0f) {
            this.playSound((SoundEvent)JSSounds.LARGE_CARNIVORE_STEP.get(), 2.0f, this.getVoicePitch() - 0.1f);
            this.shakeCamera(this.getModules().getGrowthStageModule().getPercentage(), true);
        } else {
            super.playStepSound(pos, state);
        }
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV1Sounds.TYRANNOSAURUS_ATTACK.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.TYRANNOSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV1Sounds.TYRANNOSAURUS_DEATH.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSV1Sounds.TYRANNOSAURUS_LIVING.get();
    }
}

