/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj;

import net.minecraft.util.Mth;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersFlyingMoveControl;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;

public class JSFlyingMoveControl
extends TravelersFlyingMoveControl {
    private final float maxTurn;
    private final boolean hoversInPlace;

    public JSFlyingMoveControl(SmartAnimalBase mob, TravelersAnimal<?> animal, boolean hoversInPlace) {
        super(mob, animal, hoversInPlace);
        this.hoversInPlace = hoversInPlace;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
    }

    public void tick() {
        if (this.mob.canMove()) {
            if (this.operation == TravelersMoveControl.Operation.MOVE_TO && this.mob.getNavigationController().isInProgress()) {
                double deltaZ;
                double deltaY;
                double deltaX = this.wantedX - this.mob.getX();
                double totalDeltaSqr = deltaX * deltaX + (deltaY = this.wantedY - this.mob.getY()) * deltaY + (deltaZ = this.wantedZ - this.mob.getZ()) * deltaZ;
                if (totalDeltaSqr < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                } else {
                    float f = (float)(Mth.atan2((double)deltaZ, (double)deltaX) * 180.0 / Math.PI) - 90.0f;
                    this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f, this.maxTurn));
                    this.mob.yBodyRot = this.mob.getYRot();
                    this.mob.yHeadRot = this.mob.getYRot();
                    float f1 = this.mob.getSpeed();
                    this.mob.setSpeed(f1);
                    double d4 = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                    if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                        float f3 = -((float)(Mth.atan2((double)deltaY, (double)d4) * 180.0 / Math.PI));
                        f3 = Mth.clamp((float)Mth.wrapDegrees((float)f3), (float)(-this.MAX_TURN), (float)this.MAX_TURN);
                        this.mob.setXRot(this.rotlerp(this.mob.getXRot(), f3, this.MAX_TURN));
                    }
                    this.mob.setYya(deltaY > 0.0 ? f1 : -f1);
                }
            } else {
                this.mob.setSpeed(0.0f);
                if (this.hoversInPlace) {
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                    this.mob.setXxa(0.0f);
                } else {
                    this.mob.setYya(Mth.lerp((float)0.1f, (float)this.mob.yya, (float)0.0f));
                    this.mob.setZza(Mth.lerp((float)0.1f, (float)this.mob.zza, (float)0.0f));
                    this.mob.setXxa(Mth.lerp((float)0.1f, (float)this.mob.xxa, (float)0.0f));
                }
            }
        }
    }
}

