/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.obj.task;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class LeapOutOfWaterTask
extends JSCombatTaskBase {
    private State state = State.DIVE;
    private int timer = 0;
    private int cooldown = 0;

    public LeapOutOfWaterTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
        this.getGoals().add(TaskGoal.MOVEMENT);
        this.getGoals().add(TaskGoal.ATTACK);
    }

    public TaskPriority getPriority() {
        if (this.animal.getTarget() != null && !this.animal.getTarget().isEyeInFluid(FluidTags.WATER)) {
            return TaskPriority.HIGH;
        }
        return TaskPriority.LOW;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean shouldRun() {
        if (this.animal.isDead() || this.animal.isSleeping() || this.animal.isResting()) {
            return false;
        }
        if (this.cooldown > 0) {
            this.tickCooldown();
            return false;
        }
        if (this.animal.getTarget() != null) {
            boolean eyeInWater = this.animal.getTarget().isEyeInFluid(FluidTags.WATER);
            return !eyeInWater;
        }
        return false;
    }

    public void onStart() {
        this.state = State.DIVE;
        this.timer = 0;
        this.animal.getNavigationController().stop();
        this.animal.getNavigationController().setLookingForPath(true);
    }

    public boolean canContinueRunning() {
        return true;
    }

    public boolean canInterrupt() {
        return false;
    }

    public void tick() {
        IJSLeapingEntity leapingEntity;
        if (this.animal.getTarget() == null) {
            return;
        }
        LivingEntity target = this.animal.getTarget();
        Vec3 targetPos = target.position();
        double radius = Math.max(1.0, (double)this.animal.getBbWidth() * 1.5);
        Vec3 centerTarget = targetPos.add(0.0, (double)target.getBbHeight() * 0.5, 0.0);
        Vec3 offsetTarget = centerTarget.add((this.animal.getRandom().nextDouble() - 0.5) * radius, 3.0, (this.animal.getRandom().nextDouble() - 0.5) * radius);
        int depthAbove = this.getWaterDepthAbove();
        int depth = this.getWaterDepth();
        Vec3 delta = target.position().subtract(this.animal.position());
        double distanceTo = delta.length();
        double maxUpward = 2.5;
        double horizontalSpeed = 0.6;
        double gravity = 0.08;
        double maxHeight = maxUpward * maxUpward / (2.0 * gravity);
        double maxReach = horizontalSpeed * Math.sqrt(2.0 * maxHeight / gravity);
        if (delta.y > maxHeight || Math.sqrt(delta.x * delta.x + delta.z * delta.z) > maxReach) {
            this.stop();
            return;
        }
        if (this.state == State.DIVE && depthAbove >= 6) {
            this.state = State.CHARGE;
            this.timer = 0;
            JSAnimalBase jSAnimalBase = this.animal;
            if (jSAnimalBase instanceof IJSLeapingEntity) {
                leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
                leapingEntity.setLeaping(true);
            }
        }
        switch (this.state.ordinal()) {
            case 0: {
                ++this.timer;
                if (depth < 3) {
                    this.stop();
                    return;
                }
                this.animal.setDeltaMovement(this.animal.getDeltaMovement().x * 0.8, -0.25, this.animal.getDeltaMovement().z * 0.8);
                this.animal.lookAt(EntityAnchorArgument.Anchor.EYES, offsetTarget);
                if (this.timer <= 15) break;
                this.state = State.CHARGE;
                this.timer = 0;
                break;
            }
            case 1: {
                ++this.timer;
                Vec3 dir = offsetTarget.subtract(this.animal.position()).normalize();
                double accel = Math.min(0.15 + (double)this.timer * 0.02, 0.6);
                Vec3 vel = this.animal.getDeltaMovement().add(dir.scale(accel));
                vel = new Vec3(vel.x, Math.min(vel.y, maxUpward), vel.z);
                this.animal.setDeltaMovement(vel);
                this.animal.lookAt(EntityAnchorArgument.Anchor.EYES, offsetTarget);
                float targetYaw = (float)(Mth.atan2((double)vel.z, (double)vel.x) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(Mth.atan2((double)vel.y, (double)Math.sqrt(vel.x * vel.x + vel.z * vel.z)) * 57.29577951308232));
                this.animal.setYRot(Mth.lerp((float)0.2f, (float)this.animal.getYRot(), (float)targetYaw));
                this.animal.setXRot(Mth.lerp((float)0.2f, (float)this.animal.getXRot(), (float)targetPitch));
                this.animal.yBodyRot = this.animal.getYRot();
                this.animal.yHeadRot = this.animal.getYRot();
                if (this.animal.distanceToSqr((Entity)target) < (double)((this.animal.getBbWidth() + 2.0f) * (this.animal.getBbWidth() + 2.0f))) {
                    this.animal.doHurtTarget((Entity)target);
                    this.stop();
                    return;
                }
                int maxChargeTime = Math.min(30 + depthAbove * 2, 60);
                if (!(vel.y > 1.2) && this.timer <= maxChargeTime) break;
                this.state = State.LAUNCH;
                break;
            }
            case 2: {
                JSAnimalBase accel = this.animal;
                if (accel instanceof IJSLeapingEntity) {
                    leapingEntity = (IJSLeapingEntity)((Object)accel);
                    leapingEntity.setLeaping(true);
                }
                Vec3 vel = this.animal.getDeltaMovement();
                float targetYaw = (float)(Mth.atan2((double)vel.z, (double)vel.x) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(Mth.atan2((double)vel.y, (double)Math.sqrt(vel.x * vel.x + vel.z * vel.z)) * 57.29577951308232));
                this.animal.setYRot(Mth.lerp((float)0.2f, (float)this.animal.getYRot(), (float)targetYaw));
                this.animal.setXRot(Mth.lerp((float)0.2f, (float)this.animal.getXRot(), (float)targetPitch));
                this.animal.yBodyRot = this.animal.getYRot();
                this.animal.yHeadRot = this.animal.getYRot();
                this.animal.lookAt(EntityAnchorArgument.Anchor.EYES, offsetTarget);
                if (!this.animal.isInWater() && !this.animal.onGround()) break;
                this.stop();
            }
        }
    }

    private int getWaterDepth() {
        BlockPos pos = this.animal.blockPosition();
        int depth = 0;
        for (int i = 1; i <= 20; ++i) {
            BlockPos check = pos.below(i);
            if (this.animal.level().getBlockState(check).getFluidState().isEmpty()) break;
            ++depth;
        }
        return depth;
    }

    private int getWaterDepthAbove() {
        BlockPos pos = this.animal.blockPosition();
        int depth = 0;
        for (int i = 1; i <= 20; ++i) {
            BlockPos check = pos.above(i);
            if (this.animal.level().getBlockState(check).getFluidState().isEmpty()) break;
            ++depth;
        }
        return depth;
    }

    public void onStop() {
        JSAnimalBase jSAnimalBase = this.animal;
        if (jSAnimalBase instanceof IJSLeapingEntity) {
            IJSLeapingEntity leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
            leapingEntity.setLeaping(false);
        }
        this.animal.getNavigationController().setLookingForPath(false);
        this.animal.setAggressive(false);
        this.state = State.DIVE;
        this.timer = 0;
        this.cooldown = 1;
    }

    public void tickCooldown() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    private static enum State {
        DIVE,
        CHARGE,
        LAUNCH;

    }
}

