/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.ResultType;
import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.FossilItem;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.obj.machine.GeneticAnalyzerMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.misc.AnimalType;

public class GeneticAnalyzerMachineEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private final HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> resultPossibilityHashMap = new HashMap();
    private ItemStack currentAnalyzerItem = ItemStack.EMPTY;
    private int currentAnalyzingSlotIndex = -1;
    private int progress = 0;
    private int maxProgress = 100;
    private ItemStack resultItem = ItemStack.EMPTY;

    public GeneticAnalyzerMachineEntity(BlockPos pos, BlockState state) {
        super(19, (Block)JSV1Blocks.GENETIC_ANALYZER.get(), (BlockEntityType)JSV1BlockEntities.GENETIC_ANALYZER.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> GeneticAnalyzerMachineEntity.this.progress;
                    case 1 -> GeneticAnalyzerMachineEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        GeneticAnalyzerMachineEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        GeneticAnalyzerMachineEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        this.init();
    }

    private void init() {
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            ArrayList<AnalyzerResult> list;
            HashMap resultHashMap;
            if (!animal.getAnimalAttributes().getMiscProperties().isExtinct() || animal.getItems().getCoin() == null) continue;
            AnimalType type = animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            Era era = animal.getAnimalAttributes().getMiscProperties().getEra();
            if (type == AnimalType.AQUATIC_MAMMAL || type == AnimalType.AQUATIC_REPTILE || type == AnimalType.FISH || type == AnimalType.AMPHIBIAN) {
                this.resultPossibilityHashMap.putIfAbsent(ResultType.AQUATIC, new HashMap());
                resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.AQUATIC, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(this, new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(Items.GRAVEL, 30), new AnalyzerChanceItem(Items.SAND, 10), new AnalyzerChanceItem(Items.COAL, 20)));
                resultHashMap.put(era, list);
                this.resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else if (type == AnimalType.SYNAPSID || type == AnimalType.ANTHROPOD || type == AnimalType.CEPHALOPOD) {
                this.resultPossibilityHashMap.putIfAbsent(ResultType.BUG, new HashMap());
                resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.BUG, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(this, new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(Items.GRAVEL, 30), new AnalyzerChanceItem(Items.DIRT, 10), new AnalyzerChanceItem(Items.COAL, 20)));
                resultHashMap.put(era, list);
                this.resultPossibilityHashMap.put(ResultType.AQUATIC, resultHashMap);
            } else {
                this.resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
                resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
                list = resultHashMap.getOrDefault((Object)era, new ArrayList());
                list.add(new AnalyzerResult(this, new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(Items.GRAVEL, 30), new AnalyzerChanceItem(Items.COBBLESTONE, 10), new AnalyzerChanceItem(Items.COAL, 20)));
                resultHashMap.put(era, list);
                this.resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
            }
            if (type != AnimalType.AMPHIBIAN) continue;
            this.resultPossibilityHashMap.putIfAbsent(ResultType.LAND, new HashMap());
            resultHashMap = this.resultPossibilityHashMap.getOrDefault((Object)ResultType.LAND, new HashMap());
            list = resultHashMap.getOrDefault((Object)era, new ArrayList());
            list.add(new AnalyzerResult(this, new AnalyzerChanceItem((Item)animal.getItems().getCoin().get(), 15), new AnalyzerChanceItem(Items.GRAVEL, 30), new AnalyzerChanceItem(Items.COBBLESTONE, 10), new AnalyzerChanceItem(Items.COAL, 20)));
            resultHashMap.put(era, list);
            this.resultPossibilityHashMap.put(ResultType.LAND, resultHashMap);
        }
    }

    public void localTick(Level level) {
        block5: {
            block6: {
                block4: {
                    if (level.isClientSide) {
                        return;
                    }
                    if (this.currentAnalyzingSlotIndex != -1 && !this.currentAnalyzerItem.isEmpty()) break block4;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = (ItemStack)this.getItems().get(i);
                        if (!this.isValidItem(stack)) continue;
                        this.currentAnalyzerItem = stack;
                        this.currentAnalyzingSlotIndex = i;
                        this.progress = 0;
                        this.resultItem = ItemStack.EMPTY;
                        return;
                    }
                    break block5;
                }
                if (!this.resultItem.isEmpty()) break block6;
                if (this.progress++ < this.maxProgress) break block5;
                this.createResult(level);
                this.progress = 0;
                break block5;
            }
            for (int i = 9; i < 19; ++i) {
                ItemStack slotStack = (ItemStack)this.getItems().get(i);
                if (slotStack.isEmpty()) {
                    this.getItems().set(i, (Object)this.resultItem.copy());
                    this.consumeInput();
                    return;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)this.resultItem) || slotStack.getCount() + this.resultItem.getCount() > slotStack.getMaxStackSize()) continue;
                slotStack.grow(this.resultItem.getCount());
                this.consumeInput();
                return;
            }
        }
    }

    private void consumeInput() {
        this.currentAnalyzerItem.shrink(1);
        if (this.currentAnalyzerItem.isEmpty()) {
            this.currentAnalyzerItem = ItemStack.EMPTY;
            this.currentAnalyzingSlotIndex = -1;
        }
        this.resultItem = ItemStack.EMPTY;
    }

    private void createResult(Level level) {
        Object animal;
        Item item = this.currentAnalyzerItem.getItem();
        if (item instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)item;
            animal = JSAnimals.getAnimal((String)this.currentAnalyzerItem.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)""));
            if (animal != null && animal.getItems().getCoin() != null) {
                Item coin = (Item)animal.getItems().getCoin().get();
                JSGeneData genes = animal.getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
                this.resultItem = new ItemStack((ItemLike)coin);
                genes.setDataOwnerName(animal.getAnimalAttributes().getModId() + ":" + animal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT));
                JSGeneUtil.writeToStack(this.resultItem, genes);
            }
        }
        if (!((animal = this.currentAnalyzerItem.getItem()) instanceof FossilItem)) {
            return;
        }
        FossilItem fossilItem = (FossilItem)((Object)animal);
        ResultType type = fossilItem.getResult().getResultType();
        ArrayList<AnalyzerResult> results = this.resultPossibilityHashMap.get((Object)type).get((Object)fossilItem.getEra());
        if (results == null || results.isEmpty()) {
            return;
        }
        AnalyzerResult result = results.get(level.random.nextInt(results.size()));
        int totalWeight = 0;
        for (AnalyzerChanceItem item2 : result.getChanceItems()) {
            totalWeight += item2.chance();
        }
        int roll = level.random.nextInt(totalWeight);
        int sum = 0;
        for (AnalyzerChanceItem item3 : result.getChanceItems()) {
            if (roll >= (sum += item3.chance())) continue;
            this.resultItem = new ItemStack((ItemLike)item3.item());
            Item item4 = item3.item();
            if (!(item4 instanceof DnaItem)) break;
            DnaItem dnaItem = (DnaItem)item4;
            JSGeneData geneData = dnaItem.getAnimal().getAnimalAttributes().getGeneticProperties().getDefaultGenetics();
            JSGeneData newData = geneData.copy();
            TravelersAnimalAttributes attributes = dnaItem.getAnimal().getAnimalAttributes();
            boolean isAmber = fossilItem.getResult().isAmber();
            newData.setBaseQuality(this.random.nextInt(5, 20) * (isAmber ? 2 : 1));
            this.resultItem.set((DataComponentType)JSDataComponents.GENE_DATA.get(), (Object)newData.saveToNbt(new CompoundTag()));
            break;
        }
    }

    private boolean isValidItem(ItemStack stack) {
        FossilItem fossilItem;
        Object era;
        Item item = stack.getItem();
        if (item instanceof FossilItem && JSAnimals.hasEra((Era)((Object)(era = (fossilItem = (FossilItem)item).getEra())))) {
            ResultType type = fossilItem.getResult().getResultType();
            return this.resultPossibilityHashMap.containsKey((Object)type);
        }
        era = stack.getItem();
        if (era instanceof SyringeItem) {
            SyringeItem syringeItem = (SyringeItem)era;
            boolean hasNone = ((String)stack.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)"")).isEmpty();
            return !hasNone;
        }
        return false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInv, @NotNull Player player) {
        return new GeneticAnalyzerMachineMenu(id, playerInv, this, this.data);
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof GeneticAnalyzerMachineEntity) {
            GeneticAnalyzerMachineEntity geneticAnalyzer = (GeneticAnalyzerMachineEntity)be;
            geneticAnalyzer.localTick(level);
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public HashMap<ResultType, HashMap<Era, ArrayList<AnalyzerResult>>> getResultPossibilityHashMap() {
        return this.resultPossibilityHashMap;
    }

    private class AnalyzerResult {
        private final AnalyzerChanceItem[] chanceItems;

        public AnalyzerResult(GeneticAnalyzerMachineEntity geneticAnalyzerMachineEntity, AnalyzerChanceItem ... chanceItems) {
            this.chanceItems = chanceItems;
        }

        public AnalyzerChanceItem[] getChanceItems() {
            return this.chanceItems;
        }
    }

    private record AnalyzerChanceItem(Item item, int chance) {
    }
}

