/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSMetabolismModule;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.physics.MeatEntity;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.feeder.CarnivoreFeederMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CarnivoreFeederEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private int sliderPos = 50;
    private int openTicks = 0;
    private boolean hasToDispense;
    private int openTime = 0;
    private int closeTicks = 0;
    private final ArrayList<Entity> dispensed = new ArrayList();
    private int dispenseAmount = 0;
    private int checkForFeedCooldown = 200;
    private boolean hasResult = false;
    private boolean dispenseHigher = false;

    public CarnivoreFeederEntity(BlockPos pos, BlockState blockState) {
        super(19, (Block)JSV1Blocks.CARNIVORE_FEEDER.get(), (BlockEntityType)JSV1BlockEntities.CARNIVORE_FEEDER.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return CarnivoreFeederEntity.this.sliderPos;
            }

            public void set(int index, int value) {
                CarnivoreFeederEntity.this.sliderPos = value;
            }

            public int getCount() {
                return 1;
            }
        };
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("sliderPos", this.sliderPos);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setSliderPos(tag.getInt("sliderPos"));
    }

    @Override
    protected void animate(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof CarnivoreFeederEntity) {
            CarnivoreFeederEntity herbivoreFeeder = (CarnivoreFeederEntity)be;
            if (this.openTicks > 0) {
                if (this.openTicks == 40) {
                    herbivoreFeeder.playSound(state, (SoundEvent)JSSounds.HATCH_DOOR.get());
                }
                --this.openTicks;
                JSAnimations.OPEN.getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.openTime > 0) {
                --this.openTime;
                JSAnimations.OPENED.getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.closeTicks > 0) {
                if (this.closeTicks == 39) {
                    herbivoreFeeder.playSound(state, (SoundEvent)JSSounds.HATCH_DOOR.get());
                }
                --this.closeTicks;
                JSAnimations.CLOSE.getCommand().sendForBlockEntity((BlockEntity)be);
            } else {
                JSAnimations.CLOSED.getCommand().sendForBlockEntity((BlockEntity)be);
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("sliderPos", this.sliderPos);
        tag.putInt("openTicks", this.openTicks);
        tag.putInt("openTime", this.openTime);
        tag.putBoolean("hasToDispense", this.hasToDispense);
        tag.putInt("closeTicks", this.closeTicks);
        return tag;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public void setSliderPos(int sliderPos) {
        this.sliderPos = sliderPos;
        this.data.set(0, sliderPos);
        this.setChanged();
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.empty();
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof CarnivoreFeederEntity) {
            CarnivoreFeederEntity herbivoreFeederEntity = (CarnivoreFeederEntity)be;
            if (this.openTicks == 0 && this.openTime == 10 && this.hasToDispense) {
                for (int i = 0; i < 6; ++i) {
                    if (this.tryDispenseOne()) continue;
                    if (this.dispenseAmount <= 0) break;
                    --this.dispenseAmount;
                }
                this.dispenseAmount = 0;
                if (level.isClientSide) {
                    if (this.hasResult && !this.dispenseHigher) {
                        Vec3 center = pos.getCenter();
                        for (int i = 0; i < 50; ++i) {
                            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 8.0f), center.x() + this.random.nextDouble() * 2.0 - 1.0, center.y() + 1.0 + this.random.nextDouble() - 1.0, center.z() + this.random.nextDouble() * 2.0 - 1.0, 4.0, 16.0, 4.0);
                        }
                    }
                } else if (!this.dispensed.isEmpty()) {
                    List entities = level.getEntitiesOfClass(JSAnimalBase.class, new AABB(-64.0, -16.0, -64.0, 64.0, 64.0, 64.0).move(pos), base -> (base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.CARNIVORE) || base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.PISCIVORE)) && !base.isDead() && !base.isSleeping());
                    for (JSAnimalBase a : entities) {
                        if (!a.getModules().getMetabolismModule().isHungry()) continue;
                        Optional<Entity> randomEntity = this.dispensed.stream().filter(e -> e instanceof LivingEntity).findAny();
                        if (!randomEntity.isPresent()) break;
                        a.setTarget((LivingEntity)randomEntity.get());
                    }
                    this.dispensed.clear();
                }
                this.hasResult = false;
                this.hasToDispense = false;
            }
            if (level.isClientSide) {
                return;
            }
            if (this.checkForFeedCooldown > 0) {
                --this.checkForFeedCooldown;
            } else {
                List entities;
                List balesNearby = level.getEntitiesOfClass(MeatEntity.class, new AABB(-6.0, -12.0, -6.0, 6.0, 12.0, 6.0).move(pos), Entity::isAlive);
                if (balesNearby.size() < 3 && !(entities = level.getEntitiesOfClass(JSAnimalBase.class, new AABB(-64.0, -16.0, -64.0, 64.0, 64.0, 64.0).move(pos), base -> (base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.CARNIVORE) || base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.PISCIVORE)) && !base.isDead() && !base.isSleeping())).isEmpty()) {
                    for (JSAnimalBase entity : entities) {
                        JSMetabolismModule metabolism = entity.getModules().getMetabolismModule();
                        float percentage = (float)metabolism.hungerPercentage();
                        if (!(percentage * 100.0f < (float)herbivoreFeederEntity.getSliderPos())) continue;
                        this.dispense();
                        this.dispenseAmount = entities.size();
                        this.checkForFeedCooldown = 1600;
                        return;
                    }
                }
                this.checkForFeedCooldown = 600;
            }
        }
    }

    private boolean tryDispenseOne() {
        Vec3 pos;
        MeatEntity entity;
        int slot = -1;
        ItemStack stack = null;
        EntityType type = null;
        boolean isMosquito = false;
        for (int i = 0; i < 5; ++i) {
            ItemStack itemSlot = (ItemStack)this.getItems().get(i);
            if (itemSlot.is(ItemTags.MEAT) || itemSlot.is(JSItemTags.CARNIVORE_EDIBLE)) {
                slot = i;
                stack = itemSlot;
                if (stack.getCount() <= 4) continue;
                if (stack.is(Items.BEEF)) {
                    type = EntityType.COW;
                    break;
                }
                if (stack.is(Items.CHICKEN)) {
                    type = EntityType.CHICKEN;
                    break;
                }
                if (!stack.is(Items.PORKCHOP)) break;
                type = EntityType.PIG;
                break;
            }
            if (!itemSlot.is((Item)JSV1Items.MOSQUITO.get())) continue;
            slot = i;
            stack = itemSlot;
            if (stack.getCount() <= 1) continue;
            isMosquito = true;
            break;
        }
        if (slot == -1) {
            return false;
        }
        assert (this.level != null);
        this.hasResult = true;
        if (this.level.isClientSide) {
            return true;
        }
        if (type == null) {
            if (this.level.getGameRules().getBoolean(JSCommon.FEEDER_DISPENSE_DRAIN)) {
                stack.shrink(2);
            }
            this.getItems().set(slot, (Object)stack);
            entity = (MeatEntity)((EntityType)JSEntities.MEAT.get()).create(this.level);
            if (entity == null) {
                return false;
            }
            pos = this.getBlockPos().getCenter().add((double)(this.random.nextFloat() * 2.0f - 1.0f), 0.0, (double)(this.random.nextFloat() * 2.0f - 1.0f));
            if (this.dispenseHigher) {
                pos = pos.add(0.0, 1.2, 0.0);
            }
        } else {
            if (this.level.getGameRules().getBoolean(JSCommon.FEEDER_DISPENSE_DRAIN)) {
                stack.shrink(isMosquito ? 1 : 5);
            }
            this.getItems().set(slot, (Object)stack);
            LivingEntity entity2 = (LivingEntity)type.create(this.level);
            if (entity2 == null) {
                return false;
            }
            pos = this.getBlockPos().getCenter().add(0.0, isMosquito ? 0.0 : -0.5, 0.0);
            if (this.dispenseHigher) {
                pos = pos.add(isMosquito ? (double)(this.random.nextFloat() - 0.5f) : 0.0, 1.2 + (double)(isMosquito ? 0.5f : 0.0f), isMosquito ? (double)(this.random.nextFloat() - 0.5f) : 0.0);
            }
            entity2.setPos(pos);
            if (entity2 instanceof JSAnimalBase) {
                JSAnimalBase base = (JSAnimalBase)entity2;
                base.getModules().getGeneticModule().setMale(this.random.nextBoolean());
                base.getModules().getGrowthStageModule().setMax();
                base.getModules().getMetabolismModule().setMax();
            }
            this.level.addFreshEntity((Entity)entity2);
            this.checkForFeedCooldown = 2000;
            this.dispensed.add((Entity)entity2);
            return isMosquito;
        }
        entity.setPos(pos);
        entity.setYRot(this.random.nextInt(0, 360) - 180);
        this.dispensed.add(entity);
        this.level.addFreshEntity((Entity)entity);
        return true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CarnivoreFeederMenu(containerId, playerInventory, this, null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void dispense() {
        BlockPos posAbove = this.getBlockPos().above();
        BlockState state = this.level.getBlockState(posAbove);
        if (state.isCollisionShapeFullBlock((BlockGetter)this.level, posAbove)) {
            this.playSound(this.getBlockState(), SoundEvents.CHEST_LOCKED);
            this.hasResult = false;
            this.openTicks = 0;
            this.openTime = 0;
            this.closeTicks = 0;
            this.hasToDispense = false;
            return;
        }
        boolean bl = this.dispenseHigher = !state.isAir();
        if (this.openTicks > 0 || this.openTime > 0 || this.closeTicks > 0) {
            return;
        }
        this.openTicks = 40;
        this.openTime = 40;
        this.closeTicks = 40;
        this.hasToDispense = true;
        this.setChanged();
    }

    public int getSliderPos() {
        return this.sliderPos;
    }
}

