/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.feature;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.world.feature.JSFeatures;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.world.feature.features.JSSimpleBlockFeature;
import jp.jurassicsaga.server.v1.world.tree.placer.AraucarioxylonTrunkGrower;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class JSV1ConfiguredFeatures {
    public static final HashMap<Era, Pair<ResourceKey<ConfiguredFeature<?, ?>>, ResourceKey<ConfiguredFeature<?, ?>>>> ERA_KEYS = new HashMap();
    public static final ResourceKey<ConfiguredFeature<?, ?>> EMPTY = JSV1ConfiguredFeatures.registerKey("empty");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HELICONIA = JSV1ConfiguredFeatures.registerKey("heliconia");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROYAL_FERN = JSV1ConfiguredFeatures.registerKey("royal_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEST_INDIAN_LILAC = JSV1ConfiguredFeatures.registerKey("west_indian_lilac");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWISS_CHEESE_PLANT = JSV1ConfiguredFeatures.registerKey("swiss_cheese_plant");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARAUCARIOXYLON = JSV1ConfiguredFeatures.registerKey("araucarioxylon_tree");
    private static BootstrapContext<ConfiguredFeature<?, ?>> currentContext;

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        currentContext = context;
        TagMatchTest deepslateRuletest = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        TagMatchTest iceRuleTest = new TagMatchTest(BlockTags.ICE);
        TagMatchTest stoneRuletest = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        JSV1ConfiguredFeatures.registerSimplePlant(HELICONIA, 16, 10, 7, (Block)JSV1Blocks.HELICONIA.get());
        JSV1ConfiguredFeatures.registerSimplePlant(ROYAL_FERN, 16, 10, 7, (Block)JSV1Blocks.ROYAL_FERN.get());
        JSV1ConfiguredFeatures.registerSimplePlant(WEST_INDIAN_LILAC, 16, 10, 7, (Block)JSV1Blocks.WEST_INDIAN_LILAC.get());
        JSV1ConfiguredFeatures.registerSimplePlant(SWISS_CHEESE_PLANT, 16, 10, 7, (Block)JSV1Blocks.SWISS_CHEESE_PLANT.get());
        for (Era value : Era.values()) {
            ResourceKey<ConfiguredFeature<?, ?>> FOSSIL_ORE = null;
            ResourceKey<ConfiguredFeature<?, ?>> MARINE_ORE = null;
            if (value.isHasFossilOre()) {
                FOSSIL_ORE = JSV1ConfiguredFeatures.registerKey(value.getEraName() + "_fossil_placed");
                List<OreConfiguration.TargetBlockState> FOSSIL_ORES = List.of(OreConfiguration.target((RuleTest)stoneRuletest, (BlockState)((Block)value.getFossilOre().get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateRuletest, (BlockState)((Block)value.getFossilOre().get()).defaultBlockState()));
                JSV1ConfiguredFeatures.register(FOSSIL_ORE, Feature.ORE, new OreConfiguration(FOSSIL_ORES, value.getGenerationSettings().size(), 0.0f));
            }
            if (value.isHasMarineOre()) {
                MARINE_ORE = JSV1ConfiguredFeatures.registerKey(value.getEraName() + "_marine_placed");
                List<OreConfiguration.TargetBlockState> ORES = List.of(OreConfiguration.target((RuleTest)iceRuleTest, (BlockState)((Block)value.getMarineOre().get()).defaultBlockState()));
                JSV1ConfiguredFeatures.register(MARINE_ORE, Feature.ORE, new OreConfiguration(ORES, value.getGenerationSettingsMarine().size(), 0.0f));
            }
            ERA_KEYS.put(value, Pair.of(FOSSIL_ORE == null ? EMPTY : FOSSIL_ORE, MARINE_ORE == null ? EMPTY : MARINE_ORE));
        }
        JSV1ConfiguredFeatures.register(ARAUCARIOXYLON, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get())), (TrunkPlacer)new AraucarioxylonTrunkGrower(14, 1, 14), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).build());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        currentContext.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static void registerSimplePlant(ResourceKey<ConfiguredFeature<?, ?>> featureResourceKey, int tries, int xzSpread, int ySpread, Block block) {
        JSSimpleBlockFeature feature = (JSSimpleBlockFeature)((Object)JSFeatures.SIMPLE_BLOCK.get());
        JSV1ConfiguredFeatures.register(featureResourceKey, Feature.RANDOM_PATCH, new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)feature, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)block)), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.ONLY_IN_AIR_PREDICATE}))));
    }
}

