/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.feature;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.v1.world.feature.JSV1ConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class JSV1PlacedFeatures {
    public static final HashMap<Era, Pair<ResourceKey<PlacedFeature>, ResourceKey<PlacedFeature>>> ERA_KEYS = new HashMap();
    public static final ResourceKey<PlacedFeature> EMPTY = JSV1PlacedFeatures.createKey("empty");
    public static final ResourceKey<PlacedFeature> HELICONIA = JSV1PlacedFeatures.createKey("heliconia");
    public static final ResourceKey<PlacedFeature> ROYAL_FERN = JSV1PlacedFeatures.createKey("royal_fern");
    public static final ResourceKey<PlacedFeature> WEST_INDIAN_LILAC = JSV1PlacedFeatures.createKey("west_indian_lilac");
    public static final ResourceKey<PlacedFeature> SWISS_CHEESE_PLANT = JSV1PlacedFeatures.createKey("swiss_cheese_plant");
    private static BootstrapContext<PlacedFeature> currentContext;
    private static HolderGetter<ConfiguredFeature<?, ?>> cfg;

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        currentContext = context;
        cfg = context.lookup(Registries.CONFIGURED_FEATURE);
        JSV1PlacedFeatures.registerPlant(HELICONIA, JSV1ConfiguredFeatures.HELICONIA, 2);
        JSV1PlacedFeatures.registerPlant(ROYAL_FERN, JSV1ConfiguredFeatures.ROYAL_FERN, 2);
        JSV1PlacedFeatures.registerPlant(WEST_INDIAN_LILAC, JSV1ConfiguredFeatures.WEST_INDIAN_LILAC, 2);
        JSV1PlacedFeatures.registerPlant(SWISS_CHEESE_PLANT, JSV1ConfiguredFeatures.SWISS_CHEESE_PLANT, 2);
        JSV1ConfiguredFeatures.ERA_KEYS.forEach((era, resourceKeyResourceKeyPair) -> {
            ResourceKey oreKey = (ResourceKey)resourceKeyResourceKeyPair.getFirst();
            ResourceKey marineKey = (ResourceKey)resourceKeyResourceKeyPair.getSecond();
            ResourceKey<PlacedFeature> FOSSIL = null;
            ResourceKey<PlacedFeature> MARINE = null;
            if (era.isHasFossilOre()) {
                FOSSIL = JSV1PlacedFeatures.createKey(era.getEraName() + "_fossil_placed");
                JSV1PlacedFeatures.register(FOSSIL, cfg.getOrThrow(oreKey), List.of(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)era.getGenerationSettings().yMin()), (VerticalAnchor)VerticalAnchor.absolute((int)era.getGenerationSettings().yMax())), InSquarePlacement.spread(), CountPlacement.of((int)era.getGenerationSettings().maxOres()), BiomeFilter.biome()));
            }
            if (era.isHasMarineOre()) {
                MARINE = JSV1PlacedFeatures.createKey(era.getEraName() + "_marine_placed");
                JSV1PlacedFeatures.register(MARINE, cfg.getOrThrow(marineKey), List.of(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)era.getGenerationSettingsMarine().yMin()), (VerticalAnchor)VerticalAnchor.absolute((int)era.getGenerationSettingsMarine().yMax())), InSquarePlacement.spread(), CountPlacement.of((int)era.getGenerationSettingsMarine().maxOres()), BiomeFilter.biome()));
            }
            ERA_KEYS.put((Era)((Object)era), (Pair<ResourceKey<PlacedFeature>, ResourceKey<PlacedFeature>>)Pair.of(FOSSIL == null ? EMPTY : FOSSIL, MARINE == null ? EMPTY : MARINE));
        });
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)name));
    }

    private static void register(ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        currentContext.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void registerPlant(ResourceKey<PlacedFeature> resourceKey, ResourceKey<ConfiguredFeature<?, ?>> resourceKey2, int chance) {
        JSV1PlacedFeatures.register(resourceKey, cfg.getOrThrow(resourceKey2), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)chance), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    private static void register(ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        JSV1PlacedFeatures.register(key, configuration, List.of(modifiers));
    }
}

