/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.world.tree.placer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.world.tree.JSV1TrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class AraucarioxylonTrunkGrower
extends TrunkPlacer {
    public static final MapCodec<AraucarioxylonTrunkGrower> CODEC = RecordCodecBuilder.mapCodec(p_70161_ -> AraucarioxylonTrunkGrower.trunkPlacerParts((RecordCodecBuilder.Instance)p_70161_).apply((Applicative)p_70161_, AraucarioxylonTrunkGrower::new));

    public AraucarioxylonTrunkGrower(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)JSV1TrunkPlacerTypes.ARAUCARIOXYLON.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        int j;
        BlockPos actualPos;
        int i;
        AraucarioxylonTrunkGrower.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        int minValue = 30;
        int maxAdded = 20;
        int total = minValue + random.nextInt(maxAdded);
        int removeLength = 15;
        int branchLength = (total - 2) / 8;
        for (i = 0; i < total; ++i) {
            actualPos = pos.above(i);
            this.placeLog(level, blockSetter, random, actualPos, config);
            if (i > 2 && i < total - 2) {
                if (--removeLength <= 0) {
                    removeLength = 10;
                    --branchLength;
                }
                if (removeLength == 5 || removeLength == 10) {
                    for (j = 0; j < branchLength; ++j) {
                        blockSetter.accept(actualPos.below(j).north(j), ((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get()).defaultBlockState());
                        blockSetter.accept(actualPos.below(j).east(j), ((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get()).defaultBlockState());
                        blockSetter.accept(actualPos.below(j).south(j), ((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get()).defaultBlockState());
                        blockSetter.accept(actualPos.below(j).west(j), ((Block)JSV1Blocks.ARAUCARIOXYLON.LOG.get()).defaultBlockState());
                    }
                }
            }
            if (i != total - 1) continue;
            this.placeLeavesAround(level, blockSetter, random, actualPos, config);
            blockSetter.accept(actualPos.above().above(), ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
        removeLength = 15;
        branchLength = (total - 2) / 8;
        for (i = 0; i < total; ++i) {
            if (i <= 2 || i >= total - 2) continue;
            if (--removeLength <= 0) {
                removeLength = 10;
                --branchLength;
            }
            if (removeLength != 5 && removeLength != 10) continue;
            actualPos = pos.above(i);
            for (j = 0; j < branchLength; ++j) {
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j).north(j), config);
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j).east(j), config);
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j).south(j), config);
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j).west(j), config);
                if (branchLength <= 2) continue;
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j + 1).north(j), config);
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j + 1).east(j), config);
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j + 1).south(j), config);
                this.placeLeavesAround(level, blockSetter, random, actualPos.below(j + 1).west(j), config);
            }
        }
        return ImmutableList.of();
    }

    private void placeLeavesAround(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource random, BlockPos blockpos, TreeConfiguration pConfig) {
        BlockPos above = blockpos.above();
        BlockPos below = blockpos.below();
        BlockPos south = blockpos.south();
        BlockPos west = blockpos.west();
        BlockPos north = blockpos.north();
        BlockPos east = blockpos.east();
        if (this.isValid(pLevel, above)) {
            pBlockSetter.accept(above, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
        if (this.isValid(pLevel, south)) {
            pBlockSetter.accept(south, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
        if (this.isValid(pLevel, west)) {
            pBlockSetter.accept(west, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
        if (this.isValid(pLevel, north)) {
            pBlockSetter.accept(north, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
        if (this.isValid(pLevel, east)) {
            pBlockSetter.accept(east, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
        if (this.isValid(pLevel, below)) {
            pBlockSetter.accept(below, ((Block)JSV1Blocks.ARAUCARIOXYLON.LEAVES.get()).defaultBlockState());
        }
    }

    public boolean isValid(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, BlockBehaviour.BlockStateBase::isAir);
    }
}

