/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.renderer.JSRenderers;
import jp.jurassicsaga.client.base.renderer.model.HaybaleModel;
import jp.jurassicsaga.server.base.entity.obj.physics.HaybaleEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class HaybaleRenderer
extends EntityRenderer<HaybaleEntity> {
    private static final ResourceLocation HAYBALE_LOCATION = JSCommon.createId("textures/generic/haybale.png");
    private final HaybaleModel<HaybaleEntity> model;

    public HaybaleRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new HaybaleModel(context.bakeLayer(JSRenderers.HAYBALE));
    }

    public void render(HaybaleEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        float xRot = Mth.lerp((float)partialTicks, (float)entity.rawXRotHistory[1], (float)entity.rawXRotHistory[0]);
        float yRot = Mth.lerp((float)partialTicks, (float)entity.rawYRotHistory[1], (float)entity.rawYRotHistory[0]);
        float zRot = Mth.lerp((float)partialTicks, (float)entity.rawZRotHistory[1], (float)entity.rawZRotHistory[0]);
        poseStack.translate(0.0, 0.5, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(-yRot));
        poseStack.mulPose(Axis.XP.rotationDegrees(xRot));
        poseStack.mulPose(Axis.ZP.rotationDegrees(zRot));
        VertexConsumer vertexconsumer = buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(HaybaleEntity entity) {
        return HAYBALE_LOCATION;
    }
}

