/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.screen.obj.widget.EmptyButton;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.entity.obj.other.PaddockSignEntity;
import jp.jurassicsaga.server.base.generic.networking.obj.UpdatePaddockSign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.StringUtils;
import travelers.client.TravelersClient;
import travelers.server.animal.obj.misc.AnimalType;
import travelers.util.helper.TravelersPacketDistributor;

public class PaddockSignScreen
extends Screen {
    private static final ResourceLocation BG_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/container/paddock_sign.png");
    private static final ResourceLocation ITEM = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/sprites/paddock_sign_item.png");
    private static final ResourceLocation ITEM_SELECTED = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/sprites/paddock_sign_item_selected.png");
    private static final ResourceLocation SCROLL_BAR = ResourceLocation.fromNamespaceAndPath((String)"jurassicsaga", (String)"textures/gui/sprites/scrollbar.png");
    private final List<AbstractWidget> paddockSignButtons = Lists.newArrayList();
    private final ResourceLocation levelLoc;
    private final int entityId;
    private int scrollOffset = 0;
    private int sliderYOffset = 0;
    private String currentSearch = "";
    private Entity entity;
    private JSAnimal<?> previewAnimal;

    public PaddockSignScreen(ResourceLocation levelLoc, int entityId) {
        super((Component)Component.translatable((String)"js.screen.empty"));
        this.levelLoc = levelLoc;
        this.entityId = entityId;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259) {
            if (this.currentSearch.isEmpty()) {
                return false;
            }
            this.currentSearch = this.currentSearch.substring(0, this.currentSearch.length() - 1);
            this.scrollOffset = 0;
            this.sliderYOffset = 0;
            this.init();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (StringUtil.isAllowedChatCharacter((char)codePoint) && this.currentSearch.length() + 1 < 15) {
            this.currentSearch = this.currentSearch + codePoint;
            this.scrollOffset = 0;
            this.sliderYOffset = 0;
            this.init();
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    protected void init() {
        int i = this.width / 2;
        int j = this.height / 2;
        for (AbstractWidget paddockSignButton : this.paddockSignButtons) {
            this.removeWidget((GuiEventListener)paddockSignButton);
        }
        this.paddockSignButtons.clear();
        int yOffset = 0;
        int skip = this.scrollOffset;
        int count = 0;
        ArrayList<JSAnimal<?>> sort = JSAnimals.getAnimals();
        sort.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
        for (JSAnimal<?> jsAnimal2 : sort) {
            if (!jsAnimal2.getAnimalAttributes().getMiscProperties().isExtinct() || !this.currentSearch.isEmpty() && !jsAnimal2.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT).contains(this.currentSearch.toLowerCase(Locale.ROOT))) continue;
            if (skip > 0) {
                --skip;
                continue;
            }
            if (count > 3) break;
            this.addButton((AbstractWidget)new EmptyButton(i - 120 + 21, j - 64 + 16 + yOffset, 111, 20, (Component)Component.empty(), press -> {
                if (this.entity != null && this.entity instanceof PaddockSignEntity) {
                    this.previewAnimal = jsAnimal2;
                }
            }));
            yOffset += 21;
            ++count;
        }
        this.addButton((AbstractWidget)new EmptyButton(i - 120 + 153, j - 64 + 104, 82, 10, (Component)Component.empty(), press -> {
            Entity patt0$temp;
            if (this.entity != null && (patt0$temp = this.entity) instanceof PaddockSignEntity) {
                PaddockSignEntity e = (PaddockSignEntity)patt0$temp;
                if (this.previewAnimal == null) {
                    return;
                }
                TravelersPacketDistributor.sendToServer((CustomPacketPayload)new UpdatePaddockSign(this.levelLoc, this.previewAnimal.getAnimalAttributes().getAnimalName(), this.entityId));
                e.setAnimal(this.previewAnimal.getAnimalAttributes().getAnimalName());
                Minecraft.getInstance().setScreen(null);
            }
        }));
    }

    private void addButton(AbstractWidget button) {
        this.addRenderableWidget((GuiEventListener)button);
        this.paddockSignButtons.add(button);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Entity entity;
        int i = this.width / 2;
        int j = this.height / 2;
        if (this.entity == null || !((entity = this.entity) instanceof PaddockSignEntity)) {
            this.entity = this.minecraft.player.level().getEntity(this.entityId);
        } else {
            PaddockSignEntity paddockSignEntity = (PaddockSignEntity)entity;
            guiGraphics.blit(BG_LOCATION, i - 120, j - 64, 0.0f, 0.0f, 256, 121, 256, 256);
            guiGraphics.blit(SCROLL_BAR, i - 120 + 134, j - 64 + 16 + this.sliderYOffset, 0.0f, 0.0f, 5, 14, 5, 14);
            if (this.previewAnimal == null) {
                this.previewAnimal = paddockSignEntity.getAnimal();
            }
            if (this.previewAnimal != null && this.previewAnimal.getAnimalAttributes().getMiscProperties().isExtinct()) {
                guiGraphics.blit(JSCommon.createId("textures/block/manmade/other/paddock_sign/" + this.previewAnimal.getAnimalAttributes().getAnimalName() + ".png"), i - 120 + 151, j - 64 + 15, 0.0f, 0.0f, 86, 86, 86, 86);
            }
            int yOffset = 0;
            int skip = this.scrollOffset;
            int count = 0;
            ArrayList<JSAnimal<?>> sort = JSAnimals.getAnimals();
            sort.sort(Comparator.comparing(jsAnimal -> jsAnimal.getAnimalAttributes().getAnimalName()));
            for (JSAnimal<?> jsAnimal2 : sort) {
                if (!jsAnimal2.getAnimalAttributes().getMiscProperties().isExtinct() || !this.currentSearch.isEmpty() && !jsAnimal2.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT).contains(this.currentSearch.toLowerCase(Locale.ROOT))) continue;
                if (skip > 0) {
                    --skip;
                    continue;
                }
                if (count > 3) break;
                guiGraphics.blit(this.previewAnimal != null && jsAnimal2 == this.previewAnimal ? ITEM_SELECTED : ITEM, i - 120 + 21, j - 64 + 16 + yOffset, 0.0f, 0.0f, 111, 20, 111, 20);
                AnimalType type = jsAnimal2.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
                boolean useAnimalType = type == AnimalType.FISH || type == AnimalType.BIRD || type == AnimalType.AMPHIBIAN || type == AnimalType.INSECT;
                guiGraphics.blit(JSCommon.createId("textures/item/natural/entity/default_coins/coin_" + (useAnimalType ? jsAnimal2.getAnimalAttributes().getEntityBaseProperties().getAnimalType().getName() : jsAnimal2.getAnimalAttributes().getMetabolismProperties().getDietType().getName()) + ".png"), i - 120 + 24, j - 64 + 19 + yOffset, 0.0f, 0.0f, 14, 14, 14, 14);
                String name = jsAnimal2.getAnimalAttributes().getAnimalName();
                guiGraphics.blit(JSCommon.createId("textures/item/natural/entity/animal/extinct/" + name + "/" + name + "_coin.png"), i - 120 + 24, j - 64 + 19 + yOffset, 0.0f, 0.0f, 14, 14, 14, 14);
                String trans = Component.translatable((String)("entity.jurassicsaga." + jsAnimal2.getAnimalAttributes().getAnimalName())).getString();
                try {
                    if (trans.length() > 15) {
                        trans = name.substring(0, 15);
                        trans = StringUtils.capitalize((String)trans);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                guiGraphics.drawString(this.font, trans, i - 120 + 40, j - 64 + 22 + yOffset, 11400703, true);
                yOffset += 21;
                ++count;
            }
            if (!this.currentSearch.isEmpty()) {
                Object text = this.currentSearch;
                if (TravelersClient.clientTicks % 12 > 6 && this.currentSearch.length() < 14) {
                    text = (String)text + "_";
                }
                guiGraphics.drawString(this.font, (String)text, i - 120 + 33, j - 64 + 105, 11400703, true);
            } else if (TravelersClient.clientTicks % 12 > 6) {
                guiGraphics.drawString(this.font, "_", i - 120 + 33, j - 64 + 105, 11400703, true);
            }
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.jurassicsaga.confirm"), i - 120 + 194, j - 64 + 105, 11400703);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int maxScroll = (int)JSAnimals.getAnimals().stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isExtinct() && (this.currentSearch.isEmpty() || jsAnimal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT).contains(this.currentSearch.toLowerCase(Locale.ROOT)))).count() - 4;
        if (this.scrollOffset + 1 <= maxScroll && scrollY < 0.0) {
            ++this.scrollOffset;
            this.init();
            this.sliderYOffset = (int)Mth.lerp((float)((float)this.scrollOffset / (float)maxScroll), (float)0.0f, (float)70.0f);
        } else if (this.scrollOffset - 1 >= 0 && scrollY > 0.0) {
            --this.scrollOffset;
            this.init();
            this.sliderYOffset = (int)Mth.lerp((float)((float)this.scrollOffset / (float)maxScroll), (float)0.0f, (float)70.0f);
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(float partialTick) {
    }
}

