/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.screen.machine;

import jp.jurassicsaga.client.base.screen.obj.machine.GenericScreen;
import jp.jurassicsaga.server.v1.menu.obj.machine.CultivatorMachineMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CultivatorMachineScreen
extends GenericScreen<CultivatorMachineMenu> {
    private static final ResourceLocation BG_LOCATION = CultivatorMachineScreen.loc("textures/gui/container/machine/cultivator_gui.png");

    public CultivatorMachineScreen(CultivatorMachineMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BG_LOCATION, i - 4, j - 28, 0, 0, 256, 256);
        this.renderProgress(1, i - 4 + 86, j + 15, guiGraphics, partialTick, mouseX, mouseY);
        this.renderProgress(2, i - 4 + 123, j + 45, guiGraphics, partialTick, mouseX, mouseY);
        this.renderProgress(3, i - 4 + 50, j + 45, guiGraphics, partialTick, mouseX, mouseY);
    }

    private void renderProgress(int i, int w, int h, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int progress = ((CultivatorMachineMenu)this.menu).getData().get(i);
        int max = ((CultivatorMachineMenu)this.menu).getData().get(0);
        if (progress > 0) {
            int val = (int)(100.0 * ((double)progress / (double)max));
            pGuiGraphics.drawString(this.font, (Component)Component.literal((String)(val + "%")), w, h, 0xFFFFFF);
        }
    }

    public int getScaledProgress() {
        int progress = ((CultivatorMachineMenu)this.menu).getData().get(0);
        int maxProgress = ((CultivatorMachineMenu)this.menu).getData().get(1);
        int progressArrowSize = 49;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }
}

