/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import jp.jurassicsaga.neo.data.obj.BlockDataObject;
import jp.jurassicsaga.neo.data.obj.BlockModelType;
import jp.jurassicsaga.neo.data.obj.Data;
import jp.jurassicsaga.neo.data.obj.ItemModelDataObject;
import jp.jurassicsaga.neo.data.obj.ItemModelType;
import jp.jurassicsaga.neo.data.obj.LayerModelDataObject;
import jp.jurassicsaga.neo.data.obj.SignDataObject;
import jp.jurassicsaga.neo.data.obj.SimpleDataObject;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersAttributes;
import jp.jurassicsaga.server.base.animal.obj.JSTravelersItems;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.block.JSBlocks;
import jp.jurassicsaga.server.base.block.obj.group.BasicBlockSetRegistries;
import jp.jurassicsaga.server.base.block.obj.group.ColoredRegistries;
import jp.jurassicsaga.server.base.block.obj.group.StoneRegistries;
import jp.jurassicsaga.server.base.block.obj.group.WoodRegistries;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.text.WordUtils;
import org.codehaus.plexus.util.StringUtils;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.server.animal.obj.misc.AnimalType;

public class JSData {
    private static final LinkedHashMap<Supplier<?>, Data> DATA = new LinkedHashMap();
    private static final ArrayList<Data> DATA_ARRAY = new ArrayList();
    private static final LinkedHashMap<Supplier<Block>, BlockDataObject> BLOCKS = new LinkedHashMap();
    private static final LinkedHashMap<Supplier<Item>, ItemModelDataObject> ITEMS = new LinkedHashMap();
    private static final LinkedHashMap<Supplier<Block>, BlockDataObject> PLANTS = new LinkedHashMap();

    private static void registerBasicType(BasicBlockSetRegistries set, String name, String prefix, String overrideName) {
        BLOCKS.put(set.BLOCK, new BlockDataObject(name, prefix, BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(set.SLAB, new BlockDataObject(name, prefix, BlockModelType.SLAB, ItemModelType.PARENT, overrideName));
        BLOCKS.put(set.WALL, new BlockDataObject(name, prefix, BlockModelType.WALL, ItemModelType.INVENTORY_MODEL, overrideName));
        BLOCKS.put(set.STAIRS, new BlockDataObject(name, prefix, BlockModelType.STAIR, ItemModelType.PARENT, overrideName));
    }

    public static void registerAnimal(JSAnimal<?> animal) {
        LayerModelDataObject coin;
        boolean useAnimalType;
        AnimalType type;
        TravelersItemInterface items = animal.getItems();
        boolean extinct = animal.getAnimalAttributes().getMiscProperties().isExtinct();
        String animalName = animal.getAnimalAttributes().getAnimalName().toLowerCase();
        boolean hasMeat = animal.getAnimalAttributes().getItemProperties().isHasMeat();
        boolean hasCoin = animal.getAnimalAttributes().getItemProperties().isHasCoin();
        if (extinct) {
            ItemModelDataObject bone = new ItemModelDataObject(WordUtils.capitalize((String)(animalName.replace("_", " ") + " Remains")), ItemModelType.SIMPLE_ITEM, "natural/entity/animal/" + (extinct ? "extinct/" : "extant/") + animalName + "/");
            ITEMS.put(items.getFossil_remains(), bone);
            DATA.put(items.getFossil_remains(), bone);
        }
        if (!extinct && hasCoin) {
            type = animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            useAnimalType = type == AnimalType.FISH || type == AnimalType.BIRD || type == AnimalType.AMPHIBIAN || type == AnimalType.INSECT;
            coin = new LayerModelDataObject(WordUtils.capitalize((String)animalName.replace("_", " ")) + " DNA", ItemModelType.COIN, "natural/entity/default_coins/coin_" + (useAnimalType ? animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType().getName() : animal.getAnimalAttributes().getMetabolismProperties().getDietType().getName()));
            coin.addLayer(new LayerModelDataObject.ModelDataLayer("natural/entity/animal/extant/" + animalName + "/" + animalName + "_coin"));
            ITEMS.put(items.getCoin(), coin);
            DATA.put(items.getCoin(), coin);
        }
        if (extinct) {
            type = animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType();
            useAnimalType = type == AnimalType.FISH || type == AnimalType.BIRD || type == AnimalType.AMPHIBIAN || type == AnimalType.INSECT;
            coin = new LayerModelDataObject(WordUtils.capitalize((String)animalName.replace("_", " ")) + " DNA", ItemModelType.COIN, "natural/entity/default_coins/coin_" + (useAnimalType ? animal.getAnimalAttributes().getEntityBaseProperties().getAnimalType().getName() : animal.getAnimalAttributes().getMetabolismProperties().getDietType().getName()));
            coin.addLayer(new LayerModelDataObject.ModelDataLayer("natural/entity/animal/extinct/" + animalName + "/" + animalName + "_coin"));
            ITEMS.put(items.getCoin(), coin);
            DATA.put(items.getCoin(), coin);
        }
        if (hasMeat) {
            ItemModelDataObject raw_meat = new ItemModelDataObject(WordUtils.capitalize((String)animalName.replace("_", " ")) + " Raw Meat", ItemModelType.SIMPLE_ITEM, "natural/entity/animal/" + (extinct ? "extinct/" : "extant/") + animalName + "/");
            ItemModelDataObject cooked_meat = new ItemModelDataObject(WordUtils.capitalize((String)animalName.replace("_", " ")) + " Cooked Meat", ItemModelType.SIMPLE_ITEM, "natural/entity/animal/" + (extinct ? "extinct/" : "extant/") + animalName + "/");
            ITEMS.put(items.getRawMeat(), raw_meat);
            DATA.put(items.getRawMeat(), raw_meat);
            ITEMS.put(items.getCookedMeat(), cooked_meat);
            DATA.put(items.getCookedMeat(), cooked_meat);
        }
        items.getCustom_items().forEach((droppableItem, itemDeferredItem) -> {
            ItemModelDataObject obj = new ItemModelDataObject(WordUtils.capitalize((String)animalName.replace("_", " ")) + " " + StringUtils.capitalise((String)droppableItem.name().replace("_", " ")), ItemModelType.SIMPLE_ITEM, "natural/entity/animal/" + (extinct ? "extinct/" : "extant/") + animalName + "/");
            ITEMS.put((Supplier<Item>)itemDeferredItem, obj);
            DATA.put((Supplier<?>)itemDeferredItem, obj);
        });
        DATA_ARRAY.add(new SimpleDataObject("entity.jurassicsaga." + animalName, WordUtils.capitalize((String)animalName.replace("_", " "))));
    }

    static void registerColoredRegistries(ColoredRegistries registries, String baseTranslation, String prefix, BlockModelType blockModelType, ItemModelType modelType) {
        BLOCKS.put(registries.BLACK, new BlockDataObject(baseTranslation + " Black", prefix, blockModelType, modelType));
        BLOCKS.put(registries.BLUE, new BlockDataObject(baseTranslation + " Blue", prefix, blockModelType, modelType));
        BLOCKS.put(registries.BROWN, new BlockDataObject(baseTranslation + " Brown", prefix, blockModelType, modelType));
        BLOCKS.put(registries.CYAN, new BlockDataObject(baseTranslation + " Cyan", prefix, blockModelType, modelType));
        BLOCKS.put(registries.GREEN, new BlockDataObject(baseTranslation + " Green", prefix, blockModelType, modelType));
        BLOCKS.put(registries.GREY, new BlockDataObject(baseTranslation + " Grey", prefix, blockModelType, modelType));
        BLOCKS.put(registries.LIGHTBLUE, new BlockDataObject(baseTranslation + " Light Blue", prefix, blockModelType, modelType));
        BLOCKS.put(registries.LIGHTGREY, new BlockDataObject(baseTranslation + " Light Grey", prefix, blockModelType, modelType));
        BLOCKS.put(registries.LIME, new BlockDataObject(baseTranslation + " Lime", prefix, blockModelType, modelType));
        BLOCKS.put(registries.MAGENTA, new BlockDataObject(baseTranslation + " Magenta", prefix, blockModelType, modelType));
        BLOCKS.put(registries.ORANGE, new BlockDataObject(baseTranslation + " Orange", prefix, blockModelType, modelType));
        BLOCKS.put(registries.PINK, new BlockDataObject(baseTranslation + " Pink", prefix, blockModelType, modelType));
        BLOCKS.put(registries.PURPLE, new BlockDataObject(baseTranslation + " Purple", prefix, blockModelType, modelType));
        BLOCKS.put(registries.RED, new BlockDataObject(baseTranslation + " Red", prefix, blockModelType, modelType));
        BLOCKS.put(registries.WHITE, new BlockDataObject(baseTranslation + " White", prefix, blockModelType, modelType));
        BLOCKS.put(registries.YELLOW, new BlockDataObject(baseTranslation + " Yellow", prefix, blockModelType, modelType));
    }

    static void registerColoredRegistries(ColoredRegistries registries, String baseTranslation, String prefix, BlockModelType blockModelType, ItemModelType modelType, String overrideName) {
        BLOCKS.put(registries.BLACK, new BlockDataObject(baseTranslation + " Black", prefix, blockModelType, modelType, overrideName + "_black"));
        BLOCKS.put(registries.BLUE, new BlockDataObject(baseTranslation + " Blue", prefix, blockModelType, modelType, overrideName + "_blue"));
        BLOCKS.put(registries.BROWN, new BlockDataObject(baseTranslation + " Brown", prefix, blockModelType, modelType, overrideName + "_brown"));
        BLOCKS.put(registries.CYAN, new BlockDataObject(baseTranslation + " Cyan", prefix, blockModelType, modelType, overrideName + "_cyan"));
        BLOCKS.put(registries.GREEN, new BlockDataObject(baseTranslation + " Green", prefix, blockModelType, modelType, overrideName + "_green"));
        BLOCKS.put(registries.GREY, new BlockDataObject(baseTranslation + " Grey", prefix, blockModelType, modelType, overrideName + "_grey"));
        BLOCKS.put(registries.LIGHTBLUE, new BlockDataObject(baseTranslation + " Light Blue", prefix, blockModelType, modelType, overrideName + "_lightblue"));
        BLOCKS.put(registries.LIGHTGREY, new BlockDataObject(baseTranslation + " Light Grey", prefix, blockModelType, modelType, overrideName + "_lightgrey"));
        BLOCKS.put(registries.LIME, new BlockDataObject(baseTranslation + " Lime", prefix, blockModelType, modelType, overrideName + "_lime"));
        BLOCKS.put(registries.MAGENTA, new BlockDataObject(baseTranslation + " Magenta", prefix, blockModelType, modelType, overrideName + "_magenta"));
        BLOCKS.put(registries.ORANGE, new BlockDataObject(baseTranslation + " Orange", prefix, blockModelType, modelType, overrideName + "_orange"));
        BLOCKS.put(registries.PINK, new BlockDataObject(baseTranslation + " Pink", prefix, blockModelType, modelType, overrideName + "_pink"));
        BLOCKS.put(registries.PURPLE, new BlockDataObject(baseTranslation + " Purple", prefix, blockModelType, modelType, overrideName + "_purple"));
        BLOCKS.put(registries.RED, new BlockDataObject(baseTranslation + " Red", prefix, blockModelType, modelType, overrideName + "_red"));
        BLOCKS.put(registries.WHITE, new BlockDataObject(baseTranslation + " White", prefix, blockModelType, modelType, overrideName + "_white"));
        BLOCKS.put(registries.YELLOW, new BlockDataObject(baseTranslation + " Yellow", prefix, blockModelType, modelType, overrideName + "_yellow"));
    }

    static void registerStoneType(StoneRegistries group, String baseTranslation, String baseName, String prefix) {
        BLOCKS.put(group.BLOCK, new BlockDataObject(baseTranslation, prefix, BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(group.BUTTON, new BlockDataObject(baseTranslation + " Button", prefix, BlockModelType.BUTTON, ItemModelType.INVENTORY_MODEL, baseName));
        BLOCKS.put(group.PRESSURE_PLATE, new BlockDataObject(baseTranslation + " Pressure Plate", prefix, BlockModelType.PRESSURE_PLATE, ItemModelType.PARENT, baseName));
        BLOCKS.put(group.WALL, new BlockDataObject(baseTranslation + " Wall", prefix, BlockModelType.WALL, ItemModelType.INVENTORY_MODEL, baseName));
        BLOCKS.put(group.STAIRS, new BlockDataObject(baseTranslation + " Stairs", prefix, BlockModelType.STAIR, ItemModelType.PARENT, baseName));
        BLOCKS.put(group.SLAB, new BlockDataObject(baseTranslation + " Slab", prefix, BlockModelType.SLAB, ItemModelType.PARENT, baseName));
        BLOCKS.put(group.INFESTED_BLOCK, new BlockDataObject("Infested " + baseTranslation, prefix, BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT, baseName));
    }

    static void registerWoodType(WoodRegistries group, String baseTranslation, String baseName) {
        BLOCKS.put(group.BLOCK, new BlockDataObject(baseTranslation + " Planks", "plant/tree/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT, baseName + "_planks"));
        BLOCKS.put(group.SLAB, new BlockDataObject(baseTranslation + " Slab", "plant/tree/", BlockModelType.SLAB, ItemModelType.PARENT, baseName + "_planks"));
        BLOCKS.put(group.STAIRS, new BlockDataObject(baseTranslation + " Stairs", "plant/tree/", BlockModelType.STAIR, ItemModelType.PARENT, baseName + "_planks"));
        BLOCKS.put(group.FENCE, new BlockDataObject(baseTranslation + " Fence", "plant/tree/", BlockModelType.FENCE, ItemModelType.INVENTORY_MODEL, baseName + "_planks"));
        BLOCKS.put(group.FENCE_GATE, new BlockDataObject(baseTranslation + " Fence Gate", "plant/tree/", BlockModelType.FENCE_GATE, ItemModelType.PARENT, baseName + "_planks"));
        BLOCKS.put(group.LOG, new BlockDataObject(baseTranslation + " Log", "plant/tree/", BlockModelType.PILLAR_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(group.STRIPPED_LOG, new BlockDataObject(baseTranslation + " Stripped Log", "plant/tree/", BlockModelType.PILLAR_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(group.WOOD, new BlockDataObject(baseTranslation + " Wood", "plant/tree/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT, baseName + "_log"));
        BLOCKS.put(group.STRIPPED_WOOD, new BlockDataObject("Stripped " + baseTranslation + " Wood", "plant/tree/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT, "stripped_" + baseName + "_log"));
        BLOCKS.put(group.DOOR, new BlockDataObject(baseTranslation + " Door", "plant/tree/", BlockModelType.DOOR_TRANSLUCENT, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(group.BUTTON, new BlockDataObject(baseTranslation + " Button", "plant/tree/", BlockModelType.BUTTON, ItemModelType.INVENTORY_MODEL, baseName + "_planks"));
        BLOCKS.put(group.SIGN, new SignDataObject(group.WALL_SIGN, baseTranslation + " Sign", "plant/tree/", BlockModelType.SIGN, ItemModelType.NONE, baseName + "_planks"));
        BLOCKS.put(group.TRAPDOOR, new BlockDataObject(baseTranslation + " Trapdoor", "plant/tree/", BlockModelType.TRAPDOOR_TRANSLUCENT, ItemModelType.TRAPDOOR));
        BLOCKS.put(group.PRESSURE_PLATE, new BlockDataObject(baseTranslation + " Pressure Plate", "plant/tree/", BlockModelType.PRESSURE_PLATE, ItemModelType.PARENT, baseName + "_planks"));
        ITEMS.put(group.SIGN_ITEM, new ItemModelDataObject(baseTranslation + " Sign", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        BLOCKS.put(group.HANGING_SIGN, new SignDataObject(group.HANGING_SIGN_WALL, baseTranslation + " Hanging Sign", "plant/tree/", BlockModelType.HANGING_SIGN, ItemModelType.NONE, baseName + "_planks"));
        ITEMS.put(group.HANGING_SIGN_ITEM, new ItemModelDataObject(baseTranslation + " Hanging Sign", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        BLOCKS.put(group.LEAVES, new BlockDataObject(baseTranslation + " Leaves", "plant/tree/", BlockModelType.SIMPLE_TRANSPARENT_BLOCK, ItemModelType.PARENT));
    }

    public static void registerAnimalSpawnEgg(Supplier<Item> bucket, Supplier<Item> spawnEgg, Supplier<Item> hatchedEgg, JSTravelersAttributes<?> attributes) {
        String animalName;
        ItemModelDataObject spawn_egg = new ItemModelDataObject(WordUtils.capitalize((String)attributes.getAnimalName().replace("_", " ")) + " Spawn Egg", ItemModelType.SPAWN_EGG, "");
        ITEMS.put(spawnEgg, spawn_egg);
        DATA.put(spawnEgg, spawn_egg);
        if (hatchedEgg != null) {
            animalName = attributes.getAnimalName().toLowerCase();
            ItemModelDataObject hatched_egg = new ItemModelDataObject(WordUtils.capitalize((String)(animalName.replace("_", " ") + (attributes.getMiscProperties().isMammal() ? " Gestated Embryo" : " Hatched Egg"))), ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/", "egg_" + attributes.getItemProperties().getEggtype().toString().toLowerCase() + "_hatched");
            ITEMS.put(hatchedEgg, hatched_egg);
            DATA.put(hatchedEgg, hatched_egg);
        }
        if (bucket != null) {
            animalName = attributes.getAnimalName().toLowerCase();
            ItemModelDataObject obj = new ItemModelDataObject(WordUtils.capitalize((String)animalName.replace("_", " ")) + " Bucket", ItemModelType.SIMPLE_ITEM, "natural/entity/animal/" + (attributes.getMiscProperties().isExtinct() ? "extinct/" : "extant/") + animalName + "/");
            ITEMS.put(bucket, obj);
            DATA.put(bucket, obj);
        }
    }

    public static LinkedHashMap<Supplier<?>, Data> getDATA() {
        return DATA;
    }

    public static ArrayList<Data> getDATA_ARRAY() {
        return DATA_ARRAY;
    }

    public static LinkedHashMap<Supplier<Block>, BlockDataObject> getBLOCKS() {
        return BLOCKS;
    }

    public static LinkedHashMap<Supplier<Item>, ItemModelDataObject> getITEMS() {
        return ITEMS;
    }

    public static LinkedHashMap<Supplier<Block>, BlockDataObject> getPLANTS() {
        return PLANTS;
    }

    static {
        DATA_ARRAY.add(new SimpleDataObject("entity.jurassicsaga.paddock_sign", "Paddock Sign"));
        DATA_ARRAY.add(new SimpleDataObject("js.screen.empty", "Empty Screen"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.hunger", "Hunger:"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.thirst", "Thirst:"));
        for (JSAnimal<?> jSAnimal : JSAnimals.getAnimals()) {
            JSMiscProperties miscAttributes = jSAnimal.getAnimalAttributes().getMiscProperties();
            String string2 = jSAnimal.getAnimalAttributes().getAnimalName().toLowerCase(Locale.ROOT);
            DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga." + string2 + ".scientific_name", miscAttributes.getGuideBookScientificName()));
            DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga." + string2 + ".source", miscAttributes.getGuideBookSource()));
            DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga." + string2 + ".description", miscAttributes.getGuideBookDescription()));
            DATA_ARRAY.add(new SimpleDataObject("advancements.js." + string2 + ".title", miscAttributes.getAdvancementTitle()));
            DATA_ARRAY.add(new SimpleDataObject("advancements.js." + string2 + ".desc", "Incubate an " + string2 + " egg!"));
        }
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.click_prompt_gene", "Click to preview this Gene."));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.click_prompt_goto", "Click to go to the %s page."));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.click_prompt_gotoCreature", "Go to this creature's Information Page."));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.click_prompt_nextpage", "Next Page"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.click_prompt_prevpage", "Previous Page"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.page_home", "Home Page"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.page_search", "Search Entries..."));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.page_inspect", "Creature Inspection"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.gene_inspect", "Preview this creature's potential genes."));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.baby", "Baby"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.male", "Male"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.female", "Female"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.toggle_lightmode", "Toggle Light Mode"));
        DATA_ARRAY.add(new SimpleDataObject("itemGroup.jurassicsaga.blocks", "JS | Blocks"));
        DATA_ARRAY.add(new SimpleDataObject("itemGroup.jurassicsaga.items", "JS | Items"));
        DATA_ARRAY.add(new SimpleDataObject("itemGroup.jurassicsaga.plants", "JS | Plants"));
        DATA_ARRAY.add(new SimpleDataObject("itemGroup.jurassicsaga.genetics", "JS | Genetics"));
        DATA_ARRAY.add(new SimpleDataObject("itemGroup.jurassicsaga.spawn_eggs", "JS | Spawn Eggs"));
        DATA_ARRAY.add(new SimpleDataObject("itemGroup.jurassicsaga.debug", "JS | Debug"));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.dinosaur", "Dinosaur: "));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.species", "Species: "));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.plant", "Plant: "));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.donor_info", "Donor Info: "));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.dna_quality", "Dna Quality: "));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.variant", "Variant: "));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.version", "Added in: V"));
        DATA_ARRAY.add(new SimpleDataObject("item.jurassicsaga.other_dna_label", "%s DNA"));
        DATA_ARRAY.add(new SimpleDataObject("item.jurassicsaga.red_syringe", "Blood-Filled Syringe"));
        DATA_ARRAY.add(new SimpleDataObject("item.jurassicsaga.dirty_syringe", "Dirty Syringe"));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.syringe_usage", "You could collect blood samples with this..."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.syringe_usage_dirty", "You could clean this in some water..."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.syringe_usage_full", "You could analyze the sample in this..."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.egg_basilisk_unfertilized", "For very small reptiles.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.egg_chicken_unfertilized", "Suitable for small sized reptiles and birds.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.egg_alligator_unfertilized", "Big enough to house medium sized reptiles and birds.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.egg_ostrich_unfertilized", "A perfect fit for large sized reptiles and birds.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.egg_fish_unfertilized", "About right for aquatic creatures.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.egg_spider_unfertilized", "Perfect for insectoid creatures.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.egg_frog_unfertilized", "Good enough for amphibians.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.seeds_unfertilized", "Could host an plant.."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.fertile_egg_hint", "Ready to be incubated."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.fertile_plant_hint", "Ready to be cultivated."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.syringe_analyze_hint", "Sample should be analyzed promptly."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.syringe_use_hint", "Useful to quickly extract blood samples from animals."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.syringe_clean_hint", "A good wash will make this reusable."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.shift_hint", "Hold 'Shift' for more info."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.extractions_remaining", "Gene Extractions Remaining: %s"));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.genderspawnegg.female", "Current Mode: Female"));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.genderspawnegg.male", "Current Mode: Male"));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.genderspawnegg.both", "Current Mode: Both"));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.dna_increase_quality", "Increase the quality of this sample to reveal its genes."));
        DATA_ARRAY.add(new SimpleDataObject("tooltip.jurassicsaga.unfert_egg_instruction", "A syringe could empty this."));
        DATA_ARRAY.add(new SimpleDataObject("gui.jurassicsaga.confirm", "Confirm"));
        DATA_ARRAY.add(new SimpleDataObject("command.jurassicsaga.debug.unknown", "Couldn't find an type with that description."));
        DATA_ARRAY.add(new SimpleDataObject("command.jurassicsaga.debug.update", "Updated that debug option."));
        DATA_ARRAY.add(new SimpleDataObject("command.jurassicsaga.debug.unknown_entity", "That animal doesn't exist."));
        DATA_ARRAY.add(new SimpleDataObject("command.jurassicsaga.debug.entity_hitbox_changed", "Changed the hitbox for that animal."));
        DATA_ARRAY.add(new SimpleDataObject("command.jurassicsaga.debug.entity_scale_changed", "Changed the scaling for that animal."));
        DATA_ARRAY.add(new SimpleDataObject("command.jurassicsaga.debug.entity_eye_height_changed", "Changed the eye height for that animal."));
        DATA_ARRAY.add(new SimpleDataObject("command.jurassicsaga.debug.entity_anim_changed", "Changed the animation for that animal."));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.vivid", "Vivid Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.alpine", "Alpine Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.coastal", "Coastal Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.forest", "Forest Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.jungle", "Jungle Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.ocean", "Ocean Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.pasture", "Pasture Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.rainforest", "Rainforest Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.river", "River Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.savanna", "Savanna Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.steppe", "Steppe Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.taiga", "Taiga Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.tropical", "Tropical Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.tundra", "Tundra Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.wetland", "Wetland Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.woodland", "Woodland Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.arid", "Arid Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.lux", "Lux Cosmetic Overlay Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.chaos_effect", "Chaos Effect Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.special", "Special Cosmetic Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.size_large", "Macrosoma Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.size_small", "Microsoma Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.toxic_skin", "Toxic Skin Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.venomous_bite", "Venomous Bite Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.skin_toughness", "Skin Toughness Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.aggresive_instinct", "Aggressive Instinct Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.freq_ovulation", "Frequent Ovulation Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.bone_density", "Bone Density Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.immune_response", "Immune Response Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.parental_investment", "Parental Investment Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.intensive_repair", "Intensive Repair Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.lightweight_skeleton", "Lightweight Skeleton Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.lysine_deficiency", "Lysine Deficiency Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.tooth_hardness", "Tooth Hardness Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.gender_lean_female", "Female Gender Lean Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.gender_lean_male", "Male Gender Lean Gene"));
        DATA_ARRAY.add(new SimpleDataObject("gene.jurassicsaga.infertility", "Infertility Gene"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.source", "From: %s"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.edible_items", "Edible:"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.diet", "(%s)"));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.home", "Welcome to Jurassic Saga 0.1! Please keep in mind that this is an early version of the mod. Report your bugs on our github page! \nThis guidebook is still work in progress, so any information is subject to change! \nRight click a mob with this item to inspect it."));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.tutorial1_left", "How to clone your first creature: \nMine fossils underground and analyze them using a Genetic Analyzer to gain DNA coins. Then, combine those DNA coins with the same (or donor) DNA in the DNA Modifier. \nOnce you have a 100% DNA Coin, combine it with a syringe and a suitable unfertilized egg in the crafting table to create a Fertilized Egg.\nTo unfertilize an egg, put it in the crafting table along with a syringe."));
        DATA_ARRAY.add(new SimpleDataObject("guidebook.jurassicsaga.tutorial1_right", "You can now incubate your fertilized eggs in the Incubator, then use them on the ground to hatch your first little Creature! \nNot satisfied? why not try to extract some Genes from 100% DNA samples and put them on your creature DNA via the DNA Modifier?"));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.welcome.title", "Welcome to JurassicSaga!"));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.welcome.desc", "Join a world whilst having JurassicSaga installed."));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.fossils.title", "Digging Up the Past"));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.fossils.desc", "Find an fossil item."));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.analyzer.title", "Jurassic Engineering"));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.analyzer.desc", "Create an Genetic Analyzer."));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.modifier.title", "Filling in gaps"));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.modifier.desc", "Create an DNA Modifier."));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.incubator.title", "Dino DNA"));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.incubator.desc", "Create an Incubator."));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.hatched_egg.title", "Life finds a way"));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.hatched_egg.desc", "Incubate your first dinosaur."));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.v1.0.title", "Hold Onto Your Butts."));
        DATA_ARRAY.add(new SimpleDataObject("advancements.js.v1.0.desc", "Create any creature from JurassicSaga 1.0"));
        for (Era era : Era.values()) {
            era.getRegistryMap().forEach((result, itemRegistryObject) -> ITEMS.put((Supplier<Item>)itemRegistryObject, new ItemModelDataObject(StringUtils.capitalise((String)(era.getEraName().replace("_", " ") + " " + result.getResultName().replace("_", " "))), ItemModelType.SIMPLE_ITEM, "natural/fossils/")));
        }
        ITEMS.put(JSV1Items.SYRINGE, new ItemModelDataObject("Empty Syringe", ItemModelType.EMPTY, "manmade/lab/"));
        ITEMS.put(JSV1Items.EMPTY_TEST_TUBE, new ItemModelDataObject("Empty Test Tube", ItemModelType.SIMPLE_ITEM, "manmade/lab/"));
        ITEMS.put(JSV1Items.CLICKER, new ItemModelDataObject("Clicker", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.KEYCARD, new ItemModelDataObject("Keycard", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.RED_EYED_TREE_FROG, new ItemModelDataObject("Red Eyed Tree Frog", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.REED_FROG, new ItemModelDataObject("Reed Frog", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.MOSQUITO, new ItemModelDataObject("Mosquito", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.SQUID, new ItemModelDataObject("Squid", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.SQUID_COOKED, new ItemModelDataObject("Cooked Squid", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSItems.GUIDEBOOK, new ItemModelDataObject("Guidebook", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.ALLIGATOR_EGG, new ItemModelDataObject("Alligator Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.OSTRICH_EGG, new ItemModelDataObject("Ostrich Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.SPIDER_EGG, new ItemModelDataObject("Spider Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.FISH_EGG, new ItemModelDataObject("Fish Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.FROG_EGG, new ItemModelDataObject("Frog Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.BASILISK_EGG, new ItemModelDataObject("Basilisk Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.FAILED_EGG, new ItemModelDataObject("Failed Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/", "egg_fail"));
        ITEMS.put(JSV1Items.ALLIGATOR_EGG_UNFERTILIZED, new ItemModelDataObject("Unfertilized Alligator Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.CHICKEN_EGG_UNFERTILIZED, new ItemModelDataObject("Unfertilized Chicken Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.OSTRICH_EGG_UNFERTILIZED, new ItemModelDataObject("Unfertilized Ostrich Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.SPIDER_EGG_UNFERTILIZED, new ItemModelDataObject("Unfertilized Spider Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.FISH_EGG_UNFERTILIZED, new ItemModelDataObject("Unfertilized Fish Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.FROG_EGG_UNFERTILIZED, new ItemModelDataObject("Unfertilized Frog Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.BASILISK_EGG_UNFERTILIZED, new ItemModelDataObject("Unfertilized Basilisk Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.SEEDS_UNFERTILIZED, new ItemModelDataObject("Seeds Unfertilized", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.ALLIGATOR_EGG_FERTILIZED, new ItemModelDataObject("Fertilized Alligator Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.CHICKEN_EGG_FERTILIZED, new ItemModelDataObject("Fertilized Chicken Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.SPIDER_EGG_FERTILIZED, new ItemModelDataObject("Fertilized Spider Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.FISH_EGG_FERTILIZED, new ItemModelDataObject("Fertilized Fish Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.OSTRICH_EGG_FERTILIZED, new ItemModelDataObject("Fertilized Ostrich Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.FROG_EGG_FERTILIZED, new ItemModelDataObject("Fertilized Frog Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.BASILISK_EGG_FERTILIZED, new ItemModelDataObject("Fertilized Basilisk Egg", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.SEEDS_FERTILIZED, new ItemModelDataObject("Fertilized Seeds", ItemModelType.SIMPLE_ITEM, "natural/entity/eggs/"));
        ITEMS.put(JSV1Items.PADDOCK_SIGN, new ItemModelDataObject("Paddock Sign", ItemModelType.SIMPLE_ITEM, "manmade/other/"));
        ITEMS.put(JSV1Items.ARAUCARIOXYLON_BOAT, new ItemModelDataObject("Araucarioxylon Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        ITEMS.put(JSV1Items.ARAUCARIOXYLON_CHEST_BOAT, new ItemModelDataObject("Araucarioxylon Chest Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        ITEMS.put(JSV1Items.GORDONOPTERIS_BOAT, new ItemModelDataObject("Gordonopteris Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        ITEMS.put(JSV1Items.GORDONOPTERIS_CHEST_BOAT, new ItemModelDataObject("Gordonopteris Chest Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        ITEMS.put(JSV1Items.LEPIDODENDRON_BOAT, new ItemModelDataObject("Lepidondendron Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        ITEMS.put(JSV1Items.LEPIDODENDRON_CHEST_BOAT, new ItemModelDataObject("Lepidondendron Chest Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        ITEMS.put(JSV1Items.SPINIFRUCTUS_BOAT, new ItemModelDataObject("Spinifructus Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        ITEMS.put(JSV1Items.SPINIFRUCTUS_CHEST_BOAT, new ItemModelDataObject("Spinifructus Chest Boat", ItemModelType.SIMPLE_ITEM, "plant/tree/"));
        for (Supplier supplier : JSGenetics.GENE_ITEMS.values()) {
            ITEMS.put((Supplier<Item>)supplier, (ItemModelDataObject)new ItemModelDataObject(null, ItemModelType.SIMPLE_ITEM, "manmade/genes/").setSuffix("_gene"));
        }
        JSGenetics.ENTITY_DEFAULT_GENE_DATA.forEach((entityType, itemSupplier) -> {
            ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
            String animalName = key.getPath();
            String typeString = "vanilla";
            LayerModelDataObject coin = new LayerModelDataObject(WordUtils.capitalize((String)animalName.replace("_", " ")) + " DNA", ItemModelType.COIN, "natural/entity/default_coins/coin_" + typeString);
            coin.addLayer(new LayerModelDataObject.ModelDataLayer("natural/entity/vanilla/base"));
            ITEMS.put(itemSupplier.coin(), coin);
        });
        JSGenetics.PLANT_GENETIC_INFORMATION.forEach((string, jsPlantData) -> {
            LayerModelDataObject coin = new LayerModelDataObject(WordUtils.capitalize((String)string.replace("_", " ")) + " DNA", ItemModelType.COIN, "natural/plant/coin/coin");
            coin.addLayer(new LayerModelDataObject.ModelDataLayer("natural/plant/coin/base"));
            ITEMS.put(jsPlantData.coin, coin);
        });
        for (JSAnimal jSAnimal : JSAnimals.getAnimals()) {
            JSData.registerAnimal(jSAnimal);
            TravelersItemInterface items = jSAnimal.getItems();
            if (!(items instanceof JSTravelersItems)) continue;
            TravelersItemInterface travelersItemInterface = items;
            JSData.registerAnimalSpawnEgg(travelersItemInterface.getBucket(), travelersItemInterface.getSpawnEgg(), travelersItemInterface.getHatched_egg(), jSAnimal.getAnimalAttributes());
        }
        BLOCKS.put(JSV1Blocks.GENETIC_ANALYZER, new BlockDataObject("Genetic Analyzer", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.GENE_EXTRACTOR, new BlockDataObject("Gene Isolator", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.DNA_MODIFIER, new BlockDataObject("DNA Modifier", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.INCUBATOR, new BlockDataObject("Incubator", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.CULTIVATOR, new BlockDataObject("Flora Cultivator", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.HERBIVORE_FEEDER, new BlockDataObject("Herbivore Feeder", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.CARNIVORE_FEEDER, new BlockDataObject("Carnivore Feeder", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.AQUATIC_FEEDER, new BlockDataObject("Aquatic Feeder", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.BUG_ZAPPER, new BlockDataObject("Bug Zapper", "manmade/machine/", BlockModelType.PARTICLE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.SECURE_GRID_DOOR, new BlockDataObject("Secure Grid Door", "manmade/transparent/door/", BlockModelType.DOOR_TRANSLUCENT_SIDE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.GRID_DOOR, new BlockDataObject("Grid Door", "manmade/transparent/door/", BlockModelType.DOOR_TRANSLUCENT_SIDE, ItemModelType.TRANSLUCENT_ITEM));
        BLOCKS.put(JSV1Blocks.GLASS_DOOR, new BlockDataObject("Glass Door", "manmade/transparent/door/", BlockModelType.DOOR_TRANSLUCENT_SIDE, ItemModelType.TRANSLUCENT_ITEM));
        JSData.registerColoredRegistries(JSV1Blocks.COLORED_GLASS_DOORS, "Glass Door", "manmade/transparent/door/", BlockModelType.DOOR_TRANSLUCENT_SIDE, ItemModelType.TRANSLUCENT_ITEM);
        BLOCKS.put(JSV1Blocks.THATCH, new BlockDataObject("Thatch", "manmade/other/", BlockModelType.PILLAR_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.THATCH_SLAB, new BlockDataObject("Thatch Slab", "manmade/other/", BlockModelType.SLAB, ItemModelType.PARENT, "thatch"));
        BLOCKS.put(JSV1Blocks.THATCH_STAIRS, new BlockDataObject("Thatch Stairs", "manmade/other/", BlockModelType.STAIR, ItemModelType.PARENT, "thatch"));
        BLOCKS.put(JSV1Blocks.IRON_PILLAR, new BlockDataObject("Iron Pillar", "manmade/other/", BlockModelType.PILLAR_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.BIG_TILE, new BlockDataObject("Big Tile Path", "manmade/other/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.BIG_TILE_SLAB, new BlockDataObject("Big Tile Path Slab", "manmade/other/", BlockModelType.SLAB, ItemModelType.PARENT, "big_tile_path"));
        BLOCKS.put(JSV1Blocks.BIG_TILE_STAIR, new BlockDataObject("Big Tile Path Stairs", "manmade/other/", BlockModelType.STAIR, ItemModelType.PARENT, "big_tile_path"));
        BLOCKS.put(JSV1Blocks.MIXED_PATH, new BlockDataObject("Mixed Path", "manmade/other/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.MIXED_PATH_SLAB, new BlockDataObject("Mixed Path Slab", "manmade/other/", BlockModelType.SLAB, ItemModelType.PARENT, "mixed_path"));
        BLOCKS.put(JSV1Blocks.MIXED_PATH_STAIR, new BlockDataObject("Mixed Path Stairs", "manmade/other/", BlockModelType.STAIR, ItemModelType.PARENT, "mixed_path"));
        BLOCKS.put(JSV1Blocks.CAMO_NET, new BlockDataObject("Camo Net", "manmade/other/", BlockModelType.SIMPLE_TRANSLUCENT_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.CLEAR_GLASS, new BlockDataObject("Clear Glass", "manmade/transparent/", BlockModelType.SIMPLE_TRANSLUCENT_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.REINFORCED_GLASS, new BlockDataObject("Reinforced Glass", "manmade/transparent/", BlockModelType.SIMPLE_TRANSLUCENT_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.HEAVY_DUTY_GRID, new BlockDataObject("Heavy Duty Grid", "manmade/other/", BlockModelType.SIMPLE_TRANSLUCENT_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.HEAVY_DUTY_BARS, new BlockDataObject("Heavy Duty Bars", "manmade/other/", BlockModelType.SIMPLE_TRANSLUCENT_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.CORRUGATED_IRON, new BlockDataObject("Corrugated Iron", "manmade/other/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.CORRUGATED_IRON_SLAB, new BlockDataObject("Corrugated Iron Slab", "manmade/other/", BlockModelType.SLAB, ItemModelType.PARENT, "corrugated_iron"));
        BLOCKS.put(JSV1Blocks.CORRUGATED_IRON_STAIR, new BlockDataObject("Corrugated Iron Stairs", "manmade/other/", BlockModelType.STAIR, ItemModelType.PARENT, "corrugated_iron"));
        JSData.registerColoredRegistries(JSV1Blocks.COLORED_CORRUGATED_IRONS, "Corrugated Iron", "manmade/other/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT);
        JSData.registerColoredRegistries(JSV1Blocks.COLORED_CORRUGATED_IRONS_SLAB, "Corrugated Iron Slab", "manmade/other/", BlockModelType.SLAB, ItemModelType.PARENT, "corrugated_iron");
        JSData.registerColoredRegistries(JSV1Blocks.COLORED_CORRUGATED_IRONS_STAIR, "Corrugated Iron Stairs", "manmade/other/", BlockModelType.STAIR, ItemModelType.PARENT, "corrugated_iron");
        BLOCKS.put(JSV1Blocks.ROOF_TILES, new BlockDataObject("Roof Tiles", "manmade/other/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.ROOF_TILES_SLAB, new BlockDataObject("Roof Tiles Slab", "manmade/other/", BlockModelType.SLAB, ItemModelType.PARENT, "roof_tiles"));
        BLOCKS.put(JSV1Blocks.ROOF_TILES_STAIR, new BlockDataObject("Roof Tiles Stairs", "manmade/other/", BlockModelType.STAIR, ItemModelType.PARENT, "roof_tiles"));
        JSData.registerColoredRegistries(JSV1Blocks.COLORED_ROOF_TILES, "Roof Tiles", "manmade/other/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT);
        JSData.registerColoredRegistries(JSV1Blocks.COLORED_ROOF_TILES_SLAB, "Roof Tiles Slab", "manmade/other/", BlockModelType.SLAB, ItemModelType.PARENT, "roof_tiles");
        JSData.registerColoredRegistries(JSV1Blocks.COLORED_ROOF_TILES_STAIRS, "Roof Tiles Stairs", "manmade/other/", BlockModelType.STAIR, ItemModelType.PARENT, "roof_tiles");
        JSData.registerWoodType(JSV1Blocks.ARAUCARIOXYLON, "Araucarioxylon", "araucarioxylon");
        JSData.registerWoodType(JSV1Blocks.GORDONPTERIS, "Gordonopteris", "gordonopteris");
        JSData.registerWoodType(JSV1Blocks.LEPIDODENDRON, "Lepidodendron", "lepidodendron");
        JSData.registerWoodType(JSV1Blocks.SPINIFRUCTUS, "Spinifructus", "spinifructus");
        BLOCKS.put(JSV1Blocks.ARAUCARIOXYLON_SAPLING, new BlockDataObject("Araucarioxylon Sapling", "plant/tree/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.GORDONPTERIS_SAPLING, new BlockDataObject("Gordonopteris Sapling", "plant/tree/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.LEPIDODENDRON_SAPLING, new BlockDataObject("Lepidodendron Sapling", "plant/tree/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.SPINIFRUCTUS_SAPLING, new BlockDataObject("Spinifructus Sapling", "plant/tree/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE, "Facility Concrete", "manmade/other/", "facility_concrete");
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE_BRICKS, "Facility Concrete Bricks", "manmade/other/", "facility_concrete_bricks");
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED, "Cracked Facility Concrete Bricks", "manmade/other/", "facility_concrete_bricks_cracked");
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY, "Mossy Facility Concrete Bricks", "manmade/other/", "facility_concrete_bricks_mossy");
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE_CRACKED, "Cracked Facility Concrete", "manmade/other/", "facility_concrete_cracked");
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE_MOSSY, "Mossy Facility Concrete", "manmade/other/", "facility_concrete_mossy");
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE_PANEL, "Facility Concrete Panel", "manmade/other/", "facility_concrete_panel");
        JSData.registerBasicType(JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY, "Mossy Facility Concrete Panel", "manmade/other/", "facility_concrete_panel_mossy");
        BLOCKS.put(JSV1Blocks.FACILITY_CONCRETE_PILLAR, new BlockDataObject("Facility Concrete Pillar", "manmade/other/", BlockModelType.PILLAR_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.FACILITY_CONCRETE_PILLAR_CRACKED, new BlockDataObject("Cracked Facility Concrete Pillar", "manmade/other/", BlockModelType.PILLAR_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.FACILITY_CONCRETE_PILLAR_MOSSY, new BlockDataObject("Mossy Facility Concrete Pillar", "manmade/other/", BlockModelType.PILLAR_BLOCK, ItemModelType.PARENT));
        BLOCKS.put(JSV1Blocks.ALETHOPTERIS, new BlockDataObject("Alethopteris", "plant/land/", BlockModelType.BASIC_PLANT_DOUBLE, ItemModelType.DOUBLE_PLANT));
        BLOCKS.put(JSV1Blocks.ARCHAEOMARASMIUS, new BlockDataObject("Archaeomarasmius", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.CLADOPHLEBIS, new BlockDataObject("Cladophlebis", "plant/land/", BlockModelType.BASIC_PLANT_DOUBLE, ItemModelType.DOUBLE_PLANT));
        BLOCKS.put(JSV1Blocks.CYCADEOIDEA, new BlockDataObject("Cycadeoidea", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.LADINA_SIMPLEX, new BlockDataObject("Ladina Simplex", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.NEUROPTERIS, new BlockDataObject("Neuropteris", "plant/land/", BlockModelType.BASIC_PLANT_DOUBLE, ItemModelType.DOUBLE_PLANT));
        BLOCKS.put(JSV1Blocks.SELAGINELLITES, new BlockDataObject("Selaginellites", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.ZINGIBEROPSIS_BASIC, new BlockDataObject("Zingiberopsis", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.ZINGIBEROPSIS_ORANGE, new BlockDataObject("Orange Zingiberopsis", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.ZINGIBEROPSIS_PINK, new BlockDataObject("Pink Zingiberopsis", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.ZINGIBEROPSIS_RED, new BlockDataObject("Red Zingiberopsis", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.ZINGIBEROPSIS_WHITE, new BlockDataObject("White Zingiberopsis", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.ZINGIBEROPSIS_YELLOW, new BlockDataObject("Yellow Zingiberopsis", "plant/land/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.VERIFORMANS, new BlockDataObject("Veriformans", "plant/land/", BlockModelType.BASIC_PLANT_DOUBLE, ItemModelType.DOUBLE_PLANT));
        BLOCKS.put(JSV1Blocks.HELICONIA, new BlockDataObject("Heliconia", "plant/modern/", BlockModelType.BASIC_PLANT_DOUBLE, ItemModelType.DOUBLE_PLANT));
        BLOCKS.put(JSV1Blocks.ROYAL_FERN, new BlockDataObject("Royal Fern", "plant/modern/", BlockModelType.BASIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.WEST_INDIAN_LILAC, new BlockDataObject("West Indian Lilac", "plant/modern/", BlockModelType.BASIC_PLANT_DOUBLE, ItemModelType.DOUBLE_PLANT));
        BLOCKS.put(JSV1Blocks.SWISS_CHEESE_PLANT, new BlockDataObject("Swiss Cheese Plant", "plant/modern/", BlockModelType.BASIC_PLANT_DOUBLE, ItemModelType.DOUBLE_PLANT));
        BLOCKS.put(JSV1Blocks.CAPRINA, new BlockDataObject("Caprina", "plant/aquatic/", BlockModelType.BASIC_AQUATIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.CREMNOCERAMUS, new BlockDataObject("Cremnoceramus", "plant/aquatic/", BlockModelType.BASIC_AQUATIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.HIPPURITELLA, new BlockDataObject("Hippuritella", "plant/aquatic/", BlockModelType.BASIC_AQUATIC_PLANT, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.INOCERAMUS, new BlockDataObject("Inoceramus", "plant/aquatic/", BlockModelType.NONE, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.COBANNIA_CORRUGATA, new BlockDataObject("Cobannia Corrugata", "plant/aquatic/", BlockModelType.LILY_PAD, ItemModelType.BLOCK_TEXTURE_AS_TEXTURE));
        BLOCKS.put(JSV1Blocks.NEOCALAMITES, new BlockDataObject("Neocalamites", "plant/tall/", BlockModelType.SEGMENTED, ItemModelType.SEGMENTED));
        BLOCKS.put(JSV1Blocks.OMPHALOPHLOIOS, new BlockDataObject("Omphalophloios", "plant/tall/", BlockModelType.SEGMENTED, ItemModelType.SEGMENTED));
        BLOCKS.put(JSV1Blocks.RHAMNUS_SALICIFOLIUS, new BlockDataObject("Rhamnus Salicifolius", "plant/tall/", BlockModelType.SEGMENTED, ItemModelType.SEGMENTED));
        BLOCKS.put(JSV1Blocks.TEMPSKYA, new BlockDataObject("Tempskya", "plant/tall/", BlockModelType.SEGMENTED, ItemModelType.SEGMENTED));
        BLOCKS.put(JSBlocks.BENCH_OAK_LOG, new BlockDataObject("Oak Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "oak"));
        BLOCKS.put(JSBlocks.BENCH_SPRUCE_LOG, new BlockDataObject("Spruce Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "spruce"));
        BLOCKS.put(JSBlocks.BENCH_BIRCH_LOG, new BlockDataObject("Birch Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "birch"));
        BLOCKS.put(JSBlocks.BENCH_JUNGLE_LOG, new BlockDataObject("Jungle Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "jungle"));
        BLOCKS.put(JSBlocks.BENCH_ACACIA_LOG, new BlockDataObject("Acacia Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "acacia"));
        BLOCKS.put(JSBlocks.BENCH_DARK_OAK_LOG, new BlockDataObject("Dark Oak Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "dark_oak"));
        BLOCKS.put(JSBlocks.BENCH_MANGROVE_LOG, new BlockDataObject("Mangrove Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "mangrove"));
        BLOCKS.put(JSBlocks.BENCH_CHERRY_LOG, new BlockDataObject("Cherry Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "cherry"));
        BLOCKS.put(JSBlocks.BENCH_CRIMSON_STEM, new BlockDataObject("Crimson Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "crimson"));
        BLOCKS.put(JSBlocks.BENCH_WARPED_STEM, new BlockDataObject("Warped Bench", "", BlockModelType.VANILLA_BENCH, ItemModelType.PARENT, "warped"));
        BLOCKS.put(JSV1Blocks.BENCH_ARAUCARIOXYLON, new BlockDataObject("Araucarioxylon Bench", "plant/tree/", BlockModelType.BENCH, ItemModelType.PARENT, "araucarioxylon"));
        BLOCKS.put(JSV1Blocks.BENCH_GORDONOPTERIS, new BlockDataObject("Gordonopteris Bench", "plant/tree/", BlockModelType.BENCH, ItemModelType.PARENT, "gordonopteris"));
        BLOCKS.put(JSV1Blocks.BENCH_LEPIDODENDRON, new BlockDataObject("Lepidodendron Bench", "plant/tree/", BlockModelType.BENCH, ItemModelType.PARENT, "lepidodendron"));
        BLOCKS.put(JSV1Blocks.BENCH_SPINIFRUCTUS, new BlockDataObject("Spinifructus Bench", "plant/tree/", BlockModelType.BENCH, ItemModelType.PARENT, "spinifructus"));
        for (Era era : Era.values()) {
            if (era.isHasFossilOre() && era.getFossilOre() != null) {
                BLOCKS.put(era.getFossilOre(), new BlockDataObject(StringUtils.capitalise((String)era.getEraName().replace("_", " ")) + " Fluvial Fossil Ore", "natural/worldgen/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
            }
            if (!era.isHasMarineOre() || era.getMarineOre() == null) continue;
            BLOCKS.put(era.getMarineOre(), new BlockDataObject(StringUtils.capitalise((String)era.getEraName().replace("_", " ")) + " Marine Fossil Ore", "natural/worldgen/", BlockModelType.SIMPLE_BLOCK, ItemModelType.PARENT));
        }
        BLOCKS.putAll(PLANTS);
        DATA.putAll(BLOCKS);
        DATA.putAll(ITEMS);
    }
}

