/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server;

import com.google.common.base.Supplier;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class JSAchievementProvider
implements AdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        this.welcomeAchievement(saver);
        this.fossils(saver);
        this.machines(saver);
        this.hatchedEgg(saver);
        this.createVersion(saver, 1.0);
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            if (!animal.getAnimalAttributes().getMiscProperties().isExtinct()) continue;
            this.createAnimal(saver, animal);
        }
    }

    private void createVersion(Consumer<AdvancementHolder> saver, double ... versions) {
        for (double v : versions) {
            Advancement.Builder builder = Advancement.Builder.advancement();
            AtomicReference<ItemStack> stack = new AtomicReference<ItemStack>(((Item)JSV1Items.PADDOCK_SIGN.get()).getDefaultInstance());
            Optional<JSAnimal> value = JSAnimals.getAnimals().stream().filter(animal -> animal.getAnimalAttributes().getMiscProperties().isExtinct() && (double)animal.getAnimalAttributes().getMiscProperties().getVersion() == v && animal.getItems().getFossil_remains() != null).findFirst();
            value.ifPresent(animal -> stack.set(((Item)animal.getItems().getFossil_remains().get()).getDefaultInstance()));
            builder.display(stack.get(), (Component)Component.translatable((String)("advancements.js.v" + v + ".title")), (Component)Component.translatable((String)("advancements.js.v" + v + ".desc")), JSCommon.createId("textures/gui/advancements/backgrounds/v" + v + ".png"), AdvancementType.TASK, true, true, false);
            builder.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(JSItemTags.V1_ANIMALS)}));
            builder.save(saver, this.createId("base/v" + v));
        }
    }

    private void createAnimal(Consumer<AdvancementHolder> saver, JSAnimal<? extends JSAnimalBase> animal) {
        Advancement.Builder builder = Advancement.Builder.advancement();
        String name = animal.getAnimalAttributes().getAnimalName();
        Supplier<Item> hatchedEgg = animal.getItems().getHatched_egg();
        if (hatchedEgg == null) {
            return;
        }
        Supplier<Item> item = animal.getItems().getCoin();
        ItemStack actualItem = ItemStack.EMPTY;
        actualItem = item != null ? ((Item)item.get()).getDefaultInstance() : ((Item)JSV1Items.FAILED_EGG.get()).getDefaultInstance();
        builder.display(actualItem, (Component)Component.translatable((String)("advancements.js." + name + ".title")), (Component)Component.translatable((String)("advancements.js." + name + ".desc")), JSCommon.createId("textures/gui/advancements/backgrounds/v" + animal.getAnimalAttributes().getMiscProperties().getVersion() + ".png"), AdvancementType.CHALLENGE, true, true, true);
        builder.parent(AdvancementSubProvider.createPlaceholder((String)this.createId("base/v" + animal.getAnimalAttributes().getMiscProperties().getVersion())));
        builder.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)hatchedEgg.get()})}));
        builder.save(saver, this.createId("base/animals/v" + animal.getAnimalAttributes().getMiscProperties().getVersion() + "/" + name));
    }

    private void hatchedEgg(Consumer<AdvancementHolder> saver) {
        Advancement.Builder builder = Advancement.Builder.advancement();
        builder.display((ItemLike)JSV1Animals.VELOCIRAPTOR.getItems().getHatched_egg().get(), (Component)Component.translatable((String)"advancements.js.hatched_egg.title"), (Component)Component.translatable((String)"advancements.js.hatched_egg.desc"), null, AdvancementType.TASK, true, true, false);
        builder.parent(AdvancementSubProvider.createPlaceholder((String)this.createId("base/machines/incubator")));
        builder.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(JSItemTags.FERTILIZED_EGGS)}));
        builder.save(saver, this.createId("base/hatched_egg"));
    }

    private void machines(Consumer<AdvancementHolder> saver) {
        Advancement.Builder analyzer = Advancement.Builder.advancement();
        analyzer.display((ItemLike)JSV1Blocks.GENETIC_ANALYZER.get(), (Component)Component.translatable((String)"advancements.js.analyzer.title"), (Component)Component.translatable((String)"advancements.js.analyzer.desc"), null, AdvancementType.TASK, true, true, false);
        analyzer.parent(AdvancementSubProvider.createPlaceholder((String)this.createId("base/fossils")));
        analyzer.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)JSV1Blocks.GENETIC_ANALYZER.get()})}));
        analyzer.save(saver, this.createId("base/machines/analyzer"));
        Advancement.Builder modifier = Advancement.Builder.advancement();
        modifier.display((ItemLike)JSV1Blocks.DNA_MODIFIER.get(), (Component)Component.translatable((String)"advancements.js.modifier.title"), (Component)Component.translatable((String)"advancements.js.modifier.desc"), null, AdvancementType.TASK, true, true, false);
        modifier.parent(AdvancementSubProvider.createPlaceholder((String)this.createId("base/machines/analyzer")));
        modifier.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)JSV1Blocks.DNA_MODIFIER.get()})}));
        modifier.save(saver, this.createId("base/machines/modifier"));
        Advancement.Builder incubator = Advancement.Builder.advancement();
        incubator.display((ItemLike)JSV1Blocks.INCUBATOR.get(), (Component)Component.translatable((String)"advancements.js.incubator.title"), (Component)Component.translatable((String)"advancements.js.incubator.desc"), null, AdvancementType.TASK, true, true, false);
        incubator.parent(AdvancementSubProvider.createPlaceholder((String)this.createId("base/machines/analyzer")));
        incubator.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)JSV1Blocks.INCUBATOR.get()})}));
        incubator.save(saver, this.createId("base/machines/incubator"));
    }

    private void fossils(Consumer<AdvancementHolder> saver) {
        Advancement.Builder builder = Advancement.Builder.advancement();
        builder.display((ItemLike)((Item)Era.JURASSIC.getRegistryMap().get((Object)PossibleResult.CICADA_IN_AMBER).get()).asItem(), (Component)Component.translatable((String)"advancements.js.fossils.title"), (Component)Component.translatable((String)"advancements.js.fossils.desc"), null, AdvancementType.TASK, true, true, false);
        builder.parent(AdvancementSubProvider.createPlaceholder((String)this.createId("base/welcome")));
        builder.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(JSItemTags.FOSSIL)}));
        builder.save(saver, this.createId("base/fossils"));
    }

    private void welcomeAchievement(Consumer<AdvancementHolder> saver) {
        Advancement.Builder builder = Advancement.Builder.advancement();
        builder.display((ItemLike)((Item)JSV1Items.PADDOCK_SIGN.get()).asItem(), (Component)Component.translatable((String)"advancements.js.welcome.title"), (Component)Component.translatable((String)"advancements.js.welcome.desc"), JSCommon.createId("textures/gui/advancements/backgrounds/base.png"), AdvancementType.TASK, true, true, false);
        builder.rewards(AdvancementRewards.Builder.loot((ResourceKey)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)JSCommon.createId("advancement/welcome_reward"))));
        builder.addCriterion("join", PlayerTrigger.TriggerInstance.tick());
        builder.save(saver, this.createId("base/welcome"));
    }

    private String createId(String s) {
        return "jurassicsaga:" + s;
    }
}

