/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import java.util.HashMap;
import jp.jurassicsaga.JSConstants;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSModuleHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSGroundNavigation;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSLookControl;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.entity.obj.other.IJSLeapingEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.obj.ActiveTime;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersBodyRotationControl;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.packet.obj.TravelersShakeCamera;
import travelers.util.helper.TravelersPacketDistributor;

public class JSAnimalBase
extends JSEntityDataHolder {
    private JSModuleHolder modules;
    private HashMap<Holder<Attribute>, Double> statMap = new HashMap();
    private boolean isStaticCreature;
    private boolean isFrozenInPlace;
    private boolean firstTick = true;
    private LivingEntity fleeTarget;
    private LivingEntity pendingTarget;
    private int attackDelay = -1;
    private int corpseDropCount = 0;
    private float previousYaw = 0.0f;
    private float regenHealth = 1.0f;
    private double curSpeed = 0.0;

    public JSAnimalBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(TravelersPathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(TravelersPathType.DAMAGE_FIRE, -1.0f);
        this.moveController = new TravelersMoveControl((SmartAnimalBase)this, this.getAnimal());
        this.lookControl = new JSLookControl(this);
        this.noCulling = true;
        this.createModuleHolder();
        if (this.modules != null) {
            this.modules.init();
        }
        if (TravelersMain.isDebugging()) {
            JSConstants.LOG.warn("Added {} to the world.", (Object)this.getAnimal().getAnimalAttributes().getAnimalName());
        }
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    @NotNull
    protected BodyRotationControl createBodyControl() {
        return new TravelersBodyRotationControl((SmartAnimalBase)this);
    }

    public boolean isBaby() {
        if (this.getModules() == null) {
            return true;
        }
        return this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.BABY;
    }

    public boolean isStalking() {
        return !this.isDead() && (Boolean)this.entityData.get(stalking) != false;
    }

    public void onGrowthStageChange(AnimalGrowthStage newStage) {
    }

    public void knockback(double strength, double x, double z) {
        if (this.isDead()) {
            return;
        }
        super.knockback(strength, x, z);
    }

    public boolean onClimbable() {
        return false;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, @NotNull DamageSource source) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.causeFallDamage(fallDistance, multiplier, source);
        }
        return false;
    }

    protected int calculateFallDamage(float fallDistance, float damageMultiplier) {
        if ((double)fallDistance > this.jumpHeight() * 2.0) {
            return super.calculateFallDamage(fallDistance, damageMultiplier);
        }
        return 0;
    }

    public double getEyeY() {
        return super.getEyeY();
    }

    protected void createModuleHolder() {
        this.modules = new JSModuleHolder(this);
    }

    public JSAnimal<?> getAnimal() {
        return (JSAnimal)super.getAnimal();
    }

    public float getRenderScale() {
        return this.getModules().getGrowthStageModule().getSize();
    }

    @NotNull
    protected AABB makeBoundingBox() {
        TravelersAnimal animal1 = this.getAnimal();
        if (animal1 == null || !this.level().isLoaded(this.blockPosition())) {
            return this.getDefaultDimensions(this.getPose()).makeBoundingBox(this.position());
        }
        return this.getModules().getGrowthStageModule().makeBoundingBox((JSAnimal<?>)animal1);
    }

    @NotNull
    protected EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        if (this.getModules() != null && this.getModules().getGrowthStageModule().getDimensions() != null) {
            return this.getModules().getGrowthStageModule().getDimensions();
        }
        return super.getDefaultDimensions(pose);
    }

    @Nullable
    public ItemStack getPickResult() {
        ItemStack stack = ((Item)this.getAnimal().getItems().getSpawnEgg().get()).getDefaultInstance();
        JSGeneUtil.writeToStack(stack, this.getModules().getGeneticModule().getGeneData());
        return stack;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (source == this.damageSources().inWall()) {
            this.setLeaping(false);
        }
        this.curInjuredTicks = 4;
        boolean wasHurt = super.hurt(source, amount);
        if (amount > 0.0f) {
            if (source.is(DamageTypes.CRAMMING)) {
                return false;
            }
            this.handleCorpseHit(source, wasHurt, amount);
            this.getModules().getMetabolismModule().interrupt(10);
        }
        for (JSGene jsGene : this.getModules().getGeneticModule().getGeneData().geneDataHolder.getGENE_SET()) {
            jsGene.onHitBy(this, this.getLastHurtByMob(), source, amount);
        }
        return wasHurt;
    }

    private void handleCorpseHit(@NotNull DamageSource source, boolean wasHurt, float amount) {
        if (!this.isDead()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        TravelersAnimalAttributes animalAttributes = this.getAnimal().getAnimalAttributes();
        if ((source.getDirectEntity() instanceof ServerPlayer || source.getEntity() instanceof ServerPlayer || source.is(DamageTypes.PLAYER_ATTACK)) && wasHurt && animalAttributes.getItemProperties().isHasDrops() && animalAttributes.getMiscProperties().isShouldCorpseDropItems()) {
            float missing = (float)(this.getScaledMaxHealth() - (double)this.getHealth());
            int dropTimes = Math.max(!this.isBaby() ? animalAttributes.getMiscProperties().getCorpseDropTimes() : 1, 1);
            double req = this.getScaledMaxHealth() / (double)dropTimes;
            int expectedDrops = (int)((double)missing / req);
            while (this.corpseDropCount < expectedDrops) {
                if (animalAttributes.getItemProperties().isHasMeat()) {
                    int amountToDrop = Math.abs(this.random.nextInt(((Integer)animalAttributes.getMiscProperties().getCorpseMeatDropRange().getB()).intValue()) + (Integer)animalAttributes.getMiscProperties().getCorpseMeatDropRange().getA());
                    this.spawnAtLocation(new ItemStack((ItemLike)this.getAnimal().getItems().getRawMeat().get(), amountToDrop));
                }
                if (animalAttributes.getMiscProperties().isExtinct()) {
                    int bonesToDrop = Math.abs(this.random.nextInt(((Integer)animalAttributes.getMiscProperties().getCorpseBoneDropRange().getB()).intValue()) + (Integer)animalAttributes.getMiscProperties().getCorpseBoneDropRange().getA());
                    this.spawnAtLocation(new ItemStack((ItemLike)this.getAnimal().getItems().getFossil_remains().get(), bonesToDrop));
                }
                ++this.corpseDropCount;
            }
        }
    }

    public int getMaxCorpseFoodPoints() {
        return (int)JSUtils.toTickMinutes((float)this.getScaledMaxHealth() * 2.0f);
    }

    public int getCorpseFoodPoints() {
        return (int)JSUtils.toTickMinutes(this.getHealth() * 2.0f);
    }

    protected void tickDeath() {
        if (this.isDead() || this.shouldDieInstantly()) {
            if (this.shouldDieInstantly() && this.getAnimal().getAnimalAttributes().getItemProperties().isHasDrops()) {
                if (this.getAnimal().getAnimalAttributes().getItemProperties().isHasMeat() && this.random.nextFloat() < 0.6f) {
                    this.spawnAtLocation(new ItemStack((ItemLike)this.getAnimal().getItems().getRawMeat().get(), this.random.nextInt(4) + 1));
                }
                if (this.getAnimal().getAnimalAttributes().getMiscProperties().isExtinct() && this.random.nextFloat() < 0.6f) {
                    this.spawnAtLocation(new ItemStack((ItemLike)this.getAnimal().getItems().getFossil_remains().get(), this.random.nextInt(4) + 1));
                }
            }
            if (!this.level().isClientSide() && !this.isRemoved()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)60);
                this.remove(Entity.RemovalReason.KILLED);
            }
            return;
        }
        this.setDead(true);
        this.setHealth((float)this.getScaledMaxHealth());
        this.stopInPlace();
        this.navigation.stop();
        this.navigationController.stop();
        this.goalSelector.getAvailableGoals().clear();
    }

    public boolean shouldDieInstantly() {
        return false;
    }

    protected float getSoundVolume() {
        return this.isDead() || this.isSleeping() ? 0.0f : 0.1f;
    }

    public void push(Entity entity) {
        double otherPoints;
        double hitboxPoints = this.getBbWidth() + this.getBbHeight();
        if (hitboxPoints - (otherPoints = (double)(entity.getBbHeight() + entity.getBbWidth())) < -1.0) {
            return;
        }
        super.push(entity);
    }

    public void setExtraStat(Holder<Attribute> stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            this.statMap.put(stat, this.statMap.get(stat) + i);
        } else {
            this.statMap.put(stat, i);
        }
    }

    public void removeFromStat(Holder<Attribute> stat, double i) {
        if (this.statMap == null) {
            this.statMap = new HashMap();
        }
        if (this.statMap.containsKey(stat)) {
            double count = Math.max(0.0, this.statMap.get(stat) - i);
            if (count > 0.0) {
                this.statMap.put(stat, count);
            } else {
                this.statMap.remove(stat);
            }
        }
    }

    public double getAttributeValue(Holder<Attribute> attribute) {
        double stats;
        double d = stats = this.statMap != null ? this.statMap.getOrDefault(attribute, 0.0) : 0.0;
        if (this.getModules() == null) {
            return super.getAttributeValue(attribute);
        }
        if (attribute.is(Attributes.MAX_HEALTH)) {
            return this.getScaledMaxHealth() + stats;
        }
        if (attribute.is(Attributes.ATTACK_KNOCKBACK)) {
            double val = super.getAttributeValue(attribute);
            float scale = this.getModules().getGrowthStageModule().getPercentage();
            return Mth.lerp((double)scale, (double)(val / 4.0), (double)val) + stats;
        }
        float scale = this.getModules().getGrowthStageModule().getPercentage();
        double max = super.getAttributeValue(attribute) + stats;
        return Mth.lerp((double)scale, (double)(max / 4.0), (double)max);
    }

    private double getScaledMaxHealth() {
        if (this.getAnimal() == null) {
            return super.getAttributeValue(Attributes.MAX_HEALTH);
        }
        double maxHealth = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMaxHealth();
        float scale = this.getModules().getGrowthStageModule().getPercentage();
        if (scale == 0.0f || scale == 1.0f) {
            return maxHealth;
        }
        return Mth.lerp((double)scale, (double)Math.min(5.0, maxHealth / 15.0), (double)maxHealth);
    }

    protected float getJumpPower() {
        TravelersPath path;
        if (this.isInWater()) {
            return this.getJumpPower(1.0f);
        }
        if (this.jumpHeight() > 1.0 && (path = this.getNavigationController().getPath()) != null && !path.isDone() && path.getNextNodeIndex() < path.getNodeCount()) {
            TravelersNode nextNode = path.getNextNode();
            if ((double)nextNode.y > this.getY()) {
                double diff = (double)nextNode.y - this.getY();
                return this.getJumpPower((float)((double)1.2f + diff / 3.0));
            }
        }
        return this.isInWater() ? this.getJumpPower(1.0f) : this.getJumpPower(2.35f);
    }

    public void jumpFromGround() {
        float f = this.getJumpPower();
        if (!(f <= 1.0E-5f)) {
            Vec3 vec3 = this.getDeltaMovement();
            this.setDeltaMovement(vec3.x, f, vec3.z);
            if (this.isSprinting()) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                this.addDeltaMovement(new Vec3((double)(-Mth.sin((float)f1)) * 0.2, 0.0, (double)Mth.cos((float)f1) * 0.2));
            }
            this.hasImpulse = true;
            JSAnimalBase jSAnimalBase = this;
            if (jSAnimalBase instanceof IJSLeapingEntity) {
                IJSLeapingEntity leapingEntity = (IJSLeapingEntity)((Object)jSAnimalBase);
                leapingEntity.onLeap();
            }
        }
    }

    public void tick() {
        if (this.getAnimal() != null && this.firstTick) {
            this.setBoundingBox(this.makeBoundingBox());
            this.firstTick = false;
        } else if (this.isStaticCreature) {
            return;
        }
        super.tick();
        if (this.level().isClientSide) {
            this.modules.clientTick();
        }
        if (this.curInjuredTicks > 0) {
            --this.curInjuredTicks;
        }
        if (this.curAttackTicks > 0) {
            --this.curAttackTicks;
        }
        if (this.curEatTicks > 0) {
            --this.curEatTicks;
        }
        if (this.curDrinkTicks > 0) {
            --this.curDrinkTicks;
        }
        this.modules.tick();
        if (((Boolean)this.entityData.get(refreshData)).booleanValue()) {
            this.entityData.set(refreshData, (Object)false);
        }
    }

    public void aiStep() {
        LivingEntity target;
        if (this.isStaticCreature && !this.firstTick) {
            return;
        }
        super.aiStep();
        if (this.getTarget() != null && !(target = this.getTarget()).isAlive()) {
            this.setTarget(null);
        }
        this.modules.aiStep();
    }

    @Override
    protected void customServerAiStep() {
        Vec3 nextPos;
        if (this.isStaticCreature) {
            return;
        }
        if ((double)this.getHealth() < this.getScaledMaxHealth() && this.tickCount % 20 == 0 && this.random.nextFloat() > 0.9f) {
            this.setHealth((float)Math.min(this.getScaledMaxHealth(), (double)(this.getHealth() + this.regenHealth)));
        }
        if ((this.isSleeping() || this.isResting()) && this.getLastHurtByMob() != null) {
            this.getModules().getMetabolismModule().interrupt(500);
        }
        this.getAnimal().animateServer(this, this.moveAnalysis, this.getAnimationModule());
        super.customServerAiStep();
        TravelersPath path = this.getNavigationController().getPath();
        if (path != null && !path.isDone() && (nextPos = path.getNextNode().asVec3()) != null) {
            nextPos = nextPos.add(0.0, (double)this.getEyeHeight(), 0.0);
            this.getLookControl().setLookAt(nextPos);
        }
        if (this.shouldSleep() && !this.isSleeping()) {
            this.setSleeping(true);
        } else if (this.isSleeping() && !this.shouldSleep()) {
            this.setSleeping(false);
        }
        this.modules.serverAiStep();
        if (this.attackDelay > 0) {
            --this.attackDelay;
            if (this.attackDelay == 10) {
                JSAnimalBase base;
                if (this.distanceTo((Entity)this.pendingTarget) > this.getAttackReach() * 3.0f) {
                    return;
                }
                if (this.isDead()) {
                    return;
                }
                this.doHurtTarget((Entity)this.pendingTarget);
                LivingEntity livingEntity = this.pendingTarget;
                if (livingEntity instanceof JSAnimalBase && (base = (JSAnimalBase)livingEntity).isDead()) {
                    this.getModules().getMetabolismModule().eatCorpse(base);
                }
            }
            if (this.attackDelay == 0 && this.pendingTarget != null) {
                this.pendingTarget = null;
                this.attackDelay = -1;
            }
        }
        if (this.isLeaping()) {
            Vec3 forward = this.getLookAngle().normalize().scale(0.02);
            this.setDeltaMovement(this.getDeltaMovement().add(forward));
        }
    }

    public boolean isPushable() {
        return !this.isDead();
    }

    public boolean shouldBeSaved() {
        return !this.isStaticCreature;
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.canEatFromPlayer(player, hand)) {
            this.onEatFromPlayer(player, hand, itemstack);
        }
        return super.mobInteract(player, hand);
    }

    public boolean canBeLeashed() {
        return this.getBbHeight() < 1.0f;
    }

    protected boolean canEatFromPlayer(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        return this.modules.getMetabolismModule().getDiet() != null && this.modules.getMetabolismModule().getDiet().canEatItem(itemstack);
    }

    protected void onEatFromPlayer(Player player, InteractionHand hand, ItemStack stack) {
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.modules.saveNbt(compound);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.modules.loadNbt(compound);
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.isStaticCreature) {
            return;
        }
        super.playStepSound(pos, state);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.modules.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setBoundingBox(this.makeBoundingBox());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected boolean canRunInWater() {
        return false;
    }

    protected TravelersPathNavigation createNavigationController(Level level) {
        return new JSGroundNavigation(this, level);
    }

    public float getHeadRotationSpeed() {
        return 0.5f;
    }

    public boolean isMoving() {
        return this.moveAnalysis.isMoving();
    }

    public boolean isDead() {
        return (Boolean)this.entityData.get(dead);
    }

    public boolean shouldSleep() {
        if (this.isDead()) {
            return false;
        }
        if (this.getNavigationController().isInProgress()) {
            return false;
        }
        if (this.modules.getMetabolismModule().isInterrupted()) {
            return false;
        }
        if (!this.onGround()) {
            return false;
        }
        ActiveTime sleeptime = this.getAnimal().getAnimalAttributes().getMetabolismProperties().getActiveTime();
        return !sleeptime.isActiveNow(this.level().getDayTime());
    }

    public double getTrackingRange() {
        return this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getTrackingRange();
    }

    public float getAttackReach() {
        float width = Math.max(0.5f, this.getBbWidth());
        return width * width * 2.0f;
    }

    public void attack(LivingEntity target) {
        if (this.attackDelay == -1) {
            this.curAttackTicks = 4;
            this.pendingTarget = target;
            this.attackDelay = this.attackAnimLength() + 10;
        }
    }

    protected int attackAnimLength() {
        return 20;
    }

    public boolean doHurtTarget(Entity entity) {
        boolean superHurt = super.doHurtTarget(entity);
        if (!superHurt) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            for (JSGene jsGene : this.getModules().getGeneticModule().getGeneData().geneDataHolder.getGENE_SET()) {
                jsGene.doHurtTarget(this, e);
            }
        }
        return true;
    }

    private int attackLength() {
        return 20;
    }

    protected void playAttackSound() {
        SoundEvent sound = this.getAttackSound();
        if (sound != null) {
            this.playSound(sound);
        }
    }

    @Nullable
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getCallSound() {
        return null;
    }

    public void callSounds() {
        SoundEvent sound = this.getCallSound();
        if (sound != null) {
            this.playSound(sound);
        }
    }

    public float getSpeed() {
        double speed = 0.0;
        double baseSpeed = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
        float scale = this.getScale();
        if (scale != 1.0f) {
            baseSpeed /= (double)scale;
        }
        float currentYaw = this.getYRot();
        float turningAmount = Math.abs(currentYaw - this.previousYaw);
        turningAmount = (turningAmount + 180.0f) % 360.0f - 180.0f;
        if ((turningAmount = Math.abs(turningAmount)) > 5.0f) {
            float turnSlowdown = Math.min(1.0f, turningAmount / 90.0f);
            baseSpeed *= (double)(1.0f - 0.3f * turnSlowdown);
        }
        if (this.curSpeed == 0.0) {
            this.curSpeed = baseSpeed;
        }
        float acceleration = 0.025f * this.getAnimal().getAnimalAttributes().getMetabolismProperties().getAccelerationSpeedMultiplier();
        speed = this.isStalking() ? Mth.lerp((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * (double)this.getAnimal().getAnimalAttributes().getMetabolismProperties().getStalkingSpeedMultiplier())) : (this.isRunning() ? Mth.lerp((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getRunningSpeedMultiplier())) : (this.isInWater() ? Mth.lerp((double)acceleration, (double)this.curSpeed, (double)(baseSpeed * this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getSwimmingSpeedMultiplier())) : (this.getNavigationController().isInProgress() ? Mth.lerp((double)acceleration, (double)this.curSpeed, (double)baseSpeed) : baseSpeed)));
        this.previousYaw = currentYaw;
        this.curSpeed = speed;
        return (float)speed;
    }

    public void freezeAnimator() {
        this.freezeAnimator = true;
    }

    public void shakeCamera(float multiplier, boolean groundCheck) {
        if (this.isStaticCreature()) {
            return;
        }
        if (!this.level().isClientSide && this.canShake()) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity((SmartAnimalBase)this, (CustomPacketPayload)new TravelersShakeCamera(groundCheck, this.shakeAmount() * multiplier, (int)((float)this.shakeLength() * multiplier), this.shakeDistance(), this.position().toVector3f()));
        }
    }

    public boolean canShake() {
        return this.shakeAmount() > 0.0f && (float)this.shakeLength() > 0.0f && this.shakeDistance() > 0.0f;
    }

    public int shakeLength() {
        return 0;
    }

    public float shakeAmount() {
        return 0.0f;
    }

    public float shakeDistance() {
        return 0.0f;
    }

    public boolean hasSolidBelow() {
        AABB aabb = this.getBoundingBox();
        return this.hasCollisions(aabb.inflate(0.0, 0.5, 0.0));
    }

    protected boolean checkForCollide() {
        AABB aabb = this.getBoundingBox();
        return this.hasCollisions(aabb.inflate(0.5, 0.0, 0.5));
    }

    protected boolean hasCollisions(AABB boundingBox) {
        return !this.noBlockCollision((Entity)this, boundingBox);
    }

    protected boolean noBlockCollision(@Nullable Entity entity, AABB boundingBox) {
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)BlockPos.containing((double)boundingBox.minX, (double)boundingBox.minY, (double)boundingBox.minZ), (BlockPos)BlockPos.containing((double)(boundingBox.maxX - 1.0E-7), (double)(boundingBox.maxY - 1.0E-7), (double)(boundingBox.maxZ - 1.0E-7)))) {
            VoxelShape shape;
            BlockState state = this.level().getBlockState(pos);
            if (state.getBlockSupportShape((BlockGetter)this.level(), pos).isEmpty() || (shape = state.getCollisionShape((BlockGetter)this.level(), pos, CollisionContext.of((Entity)entity))).isEmpty() || !shape.bounds().intersects(boundingBox)) continue;
            return false;
        }
        return true;
    }

    public JSModuleHolder getModules() {
        return this.modules;
    }

    public boolean isStaticCreature() {
        return this.isStaticCreature;
    }

    public void setStaticCreature(boolean isStaticCreature) {
        this.isStaticCreature = isStaticCreature;
    }

    public void setFrozenInPlace(boolean isFrozenInPlace) {
        this.isFrozenInPlace = isFrozenInPlace;
    }

    public boolean isFrozenInPlace() {
        return this.isFrozenInPlace;
    }

    public LivingEntity getFleeTarget() {
        return this.fleeTarget;
    }

    public void setFleeTarget(LivingEntity fleeTarget) {
        this.fleeTarget = fleeTarget;
    }

    public int getAttackDelay() {
        return this.attackDelay;
    }

    public void setRegenHealth(float regenHealth) {
        this.regenHealth = regenHealth;
    }
}

