/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.diet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class Diet {
    private final Set<Predicate<ItemStack>> conditions = new HashSet<Predicate<ItemStack>>();
    private final Map<Predicate<ItemStack>, Integer> foodOverrides = new HashMap<Predicate<ItemStack>, Integer>();
    private boolean canEatHaybale;
    private boolean canEatMeatCube;
    @NotNull
    private final Set<AnimalDietType> types = new HashSet<AnimalDietType>();

    public Diet(@NotNull AnimalDietType type) {
        this.types.add(type);
    }

    public Diet(Diet other) {
        this.types.addAll(other.types);
        this.foodOverrides.putAll(other.foodOverrides);
        this.conditions.addAll(other.conditions);
        this.canEatHaybale = other.canEatHaybale;
        this.canEatMeatCube = other.canEatMeatCube;
    }

    public boolean is(AnimalDietType diet) {
        return this.types.stream().anyMatch(d -> d == diet);
    }

    public boolean check(ItemStack stack) {
        if (this.conditions.isEmpty()) {
            System.out.println("Warning, trying to check empty diet.");
            return false;
        }
        for (Predicate<ItemStack> check : this.conditions) {
            if (!check.test(stack)) continue;
            return true;
        }
        return false;
    }

    public Diet addItem(Item item) {
        this.conditions.add(stack -> stack.is(item));
        return this;
    }

    public Diet addItem(Item item, int points) {
        this.conditions.add(stack -> stack.is(item));
        this.foodOverrides.put(stack -> stack.is(item), Math.max(0, points));
        return this;
    }

    public Diet addItemTag(TagKey<Item> tag) {
        this.conditions.add(stack -> stack.is(tag));
        return this;
    }

    public Diet addItemTag(TagKey<Item> tag, int points) {
        this.conditions.add(stack -> stack.is(tag));
        this.foodOverrides.put(stack -> stack.is(tag), Math.max(0, points));
        return this;
    }

    public Diet addBlock(Block block) {
        return this.addItem(block.asItem());
    }

    public Diet addBlockTag(TagKey<Block> tag) {
        this.conditions.add(stack -> {
            Item item = stack.getItem();
            Block block = Block.byItem((Item)item);
            return block.defaultBlockState().is(tag);
        });
        return this;
    }

    public Diet addBlockTag(TagKey<Block> tag, int points) {
        this.conditions.add(stack -> {
            Item item = stack.getItem();
            Block block = Block.byItem((Item)item);
            return block.defaultBlockState().is(tag);
        });
        this.foodOverrides.put(stack -> {
            Item item = stack.getItem();
            Block block = Block.byItem((Item)item);
            return block.defaultBlockState().is(tag);
        }, Math.max(0, points));
        return this;
    }

    public Diet clearFoodOverrides() {
        this.foodOverrides.clear();
        return this;
    }

    public Diet add(Diet diet) {
        this.types.addAll(diet.types);
        this.conditions.addAll(diet.conditions);
        this.foodOverrides.putAll(diet.foodOverrides);
        if (!this.canEatHaybale) {
            this.canEatHaybale = diet.canEatHaybale;
        }
        if (!this.canEatMeatCube) {
            this.canEatMeatCube = diet.canEatMeatCube;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    public Diet copy() {
        return new Diet(this);
    }

    public boolean canEat(JSAnimalBase animal, Entity other) {
        boolean same = animal == other || animal.getType() == other.getType();
        return !same;
    }

    public int getFoodPoints(@NotNull JSAnimalBase animal, @NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        for (Map.Entry<Predicate<ItemStack>, Integer> entry : this.foodOverrides.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue();
        }
        FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
        if (food != null) {
            return (int)JSUtils.toTickMinutes((food.saturation() + (float)food.nutrition()) / 2.0f);
        }
        Block block = Block.byItem((Item)stack.getItem());
        if (block != Blocks.AIR) {
            return 5;
        }
        return 1;
    }

    public boolean canEatItem(@NotNull ItemStack stack) {
        ItemStack check = stack.copy();
        check.setCount(1);
        for (Predicate<ItemStack> i : this.conditions) {
            if (!i.test(check)) continue;
            return true;
        }
        return false;
    }

    public Set<ItemStack> getAllItems() {
        return BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(stack -> this.conditions.stream().anyMatch(pred -> pred.test(stack))).collect(Collectors.toSet());
    }

    public Diet setCanEatMeatCube(boolean canEatMeatCube) {
        this.canEatMeatCube = canEatMeatCube;
        return this;
    }

    public Diet setCanEatHaybale(boolean canEatHaybale) {
        this.canEatHaybale = canEatHaybale;
        return this;
    }

    public boolean isCanEatHaybale() {
        return this.canEatHaybale;
    }

    public boolean isCanEatMeatCube() {
        return this.canEatMeatCube;
    }

    @NotNull
    public Set<AnimalDietType> getTypes() {
        return this.types;
    }
}

