/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.modules;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSAnimalModuleBase;
import jp.jurassicsaga.server.base.animal.obj.GrowthStageData;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSGeneticProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.attributes.EntityBaseProperties;

public class JSGrowthStageModule
extends JSAnimalModuleBase {
    private final JSAnimal<?> animal;
    private EntityDimensions dimensions = null;

    protected JSGrowthStageModule(JSAnimalBase owner) {
        super(owner);
        this.animal = owner.getAnimal();
    }

    @Override
    public void serverAiStep() {
        if (this.owner.isDead()) {
            return;
        }
        if (this.getGrowthProgress() != this.getMaxGrowth() && this.owner.getAnimal().getAnimalAttributes().getGeneticProperties().getBabyData() != null) {
            int growthProgress = this.getGrowthProgress();
            int growthRate = this.getGrowthMultiplier() * this.getGrowthMultiplier();
            this.setGrowthProgress(Math.min(this.getMaxGrowth(), growthProgress + growthRate));
            if (this.getGrowthStage() != AnimalGrowthStage.ADULT) {
                GrowthStageData stage = this.owner.getAnimal().getAnimalAttributes().getGeneticProperties().getBabyData();
                int nextValue = this.getGrowthMultiplier() * this.getGrowthMultiplier();
                int maxGrowth = this.getMaxGrowth();
                if (growthProgress + nextValue > (stage.getMaxGrowth() != -1 ? stage.getMaxGrowth() : maxGrowth)) {
                    this.setGrowthStage(AnimalGrowthStage.ADULT);
                } else {
                    this.setGrowthProgress(Math.min(maxGrowth, growthProgress + growthRate));
                }
                this.owner.heal(0.01f);
            }
        } else if (this.getGrowthStage() != AnimalGrowthStage.ADULT) {
            this.setGrowthStage(AnimalGrowthStage.ADULT);
        }
    }

    public int getGrowthMultiplier() {
        if (TravelersMain.isDebugging()) {
            return 25;
        }
        if (this.owner.level().getGameRules().getBoolean(JSCommon.FASTER_GROWTH)) {
            return 5;
        }
        return 2;
    }

    @Override
    public void saveNbt(CompoundTag nbt) {
        nbt.put("js.growthstage", (Tag)this.toTag());
    }

    private CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("js.growthstage.stage", this.getGrowthStage().getId());
        tag.putInt("js.growthstage.progress", this.getGrowthProgress());
        tag.putInt("js.growthstage.growthspeed", this.getGrowthSpeed());
        return tag;
    }

    @Override
    public void loadNbt(CompoundTag nbt) {
        CompoundTag tag = nbt.getCompound("js.growthstage");
        this.setGrowthStage(AnimalGrowthStage.getById(tag.getInt("js.growthstage.stage")));
        this.setGrowthProgress(tag.getInt("js.growthstage.progress"));
        this.setGrowthSpeed(tag.getInt("js.growthstage.speed"));
        this.refreshData(tag);
    }

    @Override
    public void init() {
    }

    @Override
    public void finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.NATURAL || spawnType == MobSpawnType.MOB_SUMMONED || spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.SPAWNER || spawnType == MobSpawnType.COMMAND) {
            this.setGrowthProgress(this.getMaxGrowth());
        }
        if (spawnType == MobSpawnType.SPAWN_EGG) {
            this.owner.setPersistenceRequired();
        }
        this.refreshData();
    }

    private void refreshData() {
        this.refreshData(this.toTag());
    }

    private void refreshData(CompoundTag tag) {
        this.owner.getEntityData().set(JSEntityDataHolder.growth_data, (Object)tag);
    }

    @NotNull
    public AABB makeBoundingBox(JSAnimal<?> animal1) {
        boolean needsUpdate;
        float y;
        float xz;
        TravelersAnimalAttributes attributes = animal1.getAnimalAttributes();
        float eyeHeightRatio = (float)attributes.getEntityAttributeProperties().getEyeHeight();
        GrowthStageData babyData = attributes.getGeneticProperties().getBabyData();
        float scale = 1.0f;
        if (this.getGrowthProgress() != this.getMaxGrowth() && babyData != null && babyData.getSizeXZ() * scale > 0.0f && babyData.getSizeY() * scale > 0.0f) {
            float curXZ = babyData.getSizeXZ() * scale;
            float curY = babyData.getSizeY() * scale;
            float nextXZ = (float)(this.owner.getModules().getGeneticModule().isMale() && attributes.getEntityBaseProperties().getDimensionsMale() != null ? attributes.getEntityBaseProperties().getDimensionsMale()[0] : attributes.getEntityAttributeProperties().getDimensions()[0]);
            float nextY = (float)(this.owner.getModules().getGeneticModule().isMale() && attributes.getEntityBaseProperties().getDimensionsMale() != null ? attributes.getEntityBaseProperties().getDimensionsMale()[1] : attributes.getEntityAttributeProperties().getDimensions()[1]);
            double progress = this.getPercentage();
            xz = (float)Mth.lerp((double)progress, (double)curXZ, (double)(nextXZ * scale));
            y = (float)Mth.lerp((double)progress, (double)curY, (double)(nextY * scale));
        } else if (this.owner.getModules().getGeneticModule().isMale() && attributes.getEntityBaseProperties().getDimensionsMale() != null) {
            xz = (float)(attributes.getEntityBaseProperties().getDimensionsMale()[0] * (double)scale);
            y = (float)(attributes.getEntityBaseProperties().getDimensionsMale()[1] * (double)scale);
        } else {
            xz = (float)(attributes.getEntityAttributeProperties().getDimensions()[0] * (double)scale);
            y = (float)(attributes.getEntityAttributeProperties().getDimensions()[1] * (double)scale);
        }
        boolean bl = needsUpdate = this.dimensions == null || this.dimensions.width() != xz || this.dimensions.height() != y;
        if (needsUpdate) {
            this.dimensions = EntityDimensions.scalable((float)xz, (float)y);
            if (eyeHeightRatio > 0.0f) {
                this.dimensions = this.dimensions.withEyeHeight(y * eyeHeightRatio);
            }
            this.owner.refreshDimensions();
        }
        return this.dimensions.makeBoundingBox(this.owner.position());
    }

    public float getSize() {
        GrowthStageData data;
        TravelersAnimalAttributes props = this.animal.getAnimalAttributes();
        JSGeneticProperties genetics = props.getGeneticProperties();
        EntityBaseProperties generic = props.getEntityBaseProperties();
        if (this.getGrowthProgress() != this.getMaxGrowth() && (data = genetics.getBabyData()) != null) {
            float scale = data.getScaleMultiplier();
            float nextScale = data.getNextScale() > 0.0f && this.getGrowthStage() != AnimalGrowthStage.ADULT ? data.getNextScale() : ((Boolean)this.owner.getEntityData().get(JSEntityDataHolder.male) != false && generic.getRenderScaleMale() != -1.0 ? (float)generic.getRenderScaleMale() : (float)generic.getRenderScale());
            double progress = this.getPercentage();
            double scaleSize = Mth.lerp((double)progress, (double)scale, (double)nextScale);
            return (float)((scaleSize + (double)this.owner.getModules().getGeneticModule().getGeneData().getSizeDimorphism()) * 1.0);
        }
        double baseScale = (Boolean)this.owner.getEntityData().get(JSEntityDataHolder.male) != false && generic.getRenderScaleMale() != -1.0 ? generic.getRenderScaleMale() : generic.getRenderScale();
        double extraScale = ((Float)this.owner.getEntityData().get(JSEntityDataHolder.additionalScale)).floatValue();
        return (float)((baseScale + extraScale + (double)this.owner.getModules().getGeneticModule().getGeneData().getSizeDimorphism()) * 1.0);
    }

    public AnimalGrowthStage getGrowthStage() {
        CompoundTag data = (CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.growth_data);
        return AnimalGrowthStage.getById(data.getInt("js.growthstage.stage"));
    }

    public int getGrowthProgress() {
        CompoundTag data = (CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.growth_data);
        return data.getInt("js.growthstage.progress");
    }

    public float getPercentage() {
        TravelersAnimalAttributes props = this.animal.getAnimalAttributes();
        JSGeneticProperties genetics = props.getGeneticProperties();
        return (float)this.getGrowthProgress() / (float)genetics.getGrowthProgressCap();
    }

    public int getMaxGrowth() {
        return this.animal.getAnimalAttributes().getGeneticProperties().getGrowthProgressCap();
    }

    public int getGrowthSpeed() {
        CompoundTag data = (CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.growth_data);
        return data.getInt("js.growthstage.growthspeed");
    }

    public void setGrowthStage(AnimalGrowthStage animalGrowthStage) {
        if (animalGrowthStage != this.getGrowthStage()) {
            this.owner.onGrowthStageChange(animalGrowthStage);
        }
        CompoundTag data = ((CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.growth_data)).copy();
        data.putInt("js.growthstage.stage", animalGrowthStage.getId());
        this.owner.getEntityData().set(JSEntityDataHolder.growth_data, (Object)data);
    }

    public void setGrowthProgress(int progress) {
        CompoundTag data = ((CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.growth_data)).copy();
        data.putInt("js.growthstage.progress", progress);
        this.owner.getEntityData().set(JSEntityDataHolder.growth_data, (Object)data);
    }

    public void setGrowthSpeed(int speed) {
        CompoundTag data = ((CompoundTag)this.owner.getEntityData().get(JSEntityDataHolder.growth_data)).copy();
        data.putInt("js.growthstage.speed", speed);
        this.owner.getEntityData().set(JSEntityDataHolder.growth_data, (Object)data);
    }

    public void setMax() {
        this.setGrowthStage(AnimalGrowthStage.ADULT);
        this.setGrowthProgress(this.getMaxGrowth());
    }

    public EntityDimensions getDimensions() {
        return this.dimensions;
    }
}

