/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.nav;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersSwimNodeEvaluator;

public class JSAquaticNavigation
extends TravelersPathNavigation {
    private final boolean allowBreaching;
    private final JSAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public JSAquaticNavigation(JSAnimalBase mob, Level level, boolean allowBreaching) {
        super((SmartAnimalBase)mob, level);
        this.base = mob;
        this.allowBreaching = allowBreaching;
    }

    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, JSAnimalBase mob, Vec3 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        Vec3 nodeCenter = Vec3.atCenterOf((Vec3i)path.getNodePos(nextNodeIndex));
        Vec3 pos = mob.position();
        return nodeCenter.closerThan(pos, Math.max(0.75, (double)(mob.getBbWidth() / 2.0f)), (double)Math.max(0.75f, mob.getBbHeight()));
    }

    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.isInLiquid();
    }

    protected double getGroundY(Vec3 vec) {
        return vec.y;
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    public boolean isStableDestination(BlockPos pos) {
        return !this.level.getBlockState(pos).isSolidRender((BlockGetter)this.level, pos);
    }

    public void setCanFloat(boolean canSwim) {
    }

    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

