/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import java.util.concurrent.CompletableFuture;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSHerdModule;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatFollowTask;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class JSHerdCombatFollowTask
extends JSCombatFollowTask {
    private boolean callOut = false;
    private int callingTicks = 0;
    private int maxCallingTicks = 0;
    private boolean shouldObserve = false;
    private int observeTicks = 0;
    private int maxObserveTicks = 40;
    private State state = State.AGGRESSIVE;
    private static final double RUN_AFTER_SPEED = 1.35;
    private static final double RUN_AWAY_DIST = 10.0;

    public JSHerdCombatFollowTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public JSHerdCombatFollowTask shouldCallout(boolean callOut, int callingTicks) {
        this.callOut = callOut;
        this.callingTicks = callingTicks;
        this.maxCallingTicks = callingTicks;
        return this;
    }

    public JSCombatFollowTask observe() {
        this.shouldObserve = true;
        return this;
    }

    @Override
    public boolean shouldRun() {
        LivingEntity leaderTarget;
        Player player;
        LivingEntity livingEntity;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (this.animal.getTarget() != null && (livingEntity = this.animal.getTarget()) instanceof Player && (player = (Player)livingEntity).isCreative()) {
            this.animal.setTarget(null);
            return false;
        }
        JSHerdModule herdModule = this.animal.getModules().getHerdModule();
        if (herdModule.isFollower() && (leaderTarget = herdModule.getHerdLeader().getTarget()) != null && leaderTarget.isAlive()) {
            return true;
        }
        return this.animal.getTarget() != null && this.animal.getTarget().isAlive();
    }

    @Override
    public void onStart() {
        LivingEntity target;
        LivingEntity leaderTarget;
        JSHerdModule herdModule;
        if (this.animal.isResting() || this.animal.isSleeping()) {
            this.animal.getModules().getMetabolismModule().interrupt(20);
        }
        if ((herdModule = this.animal.getModules().getHerdModule()).isFollower() && (leaderTarget = herdModule.getHerdLeader().getTarget()) != null && leaderTarget.isAlive()) {
            this.animal.setTarget(leaderTarget);
        }
        if ((target = this.animal.getTarget()) == null || !target.isAlive()) {
            return;
        }
        if (this.callOut && this.random.nextDouble() < 0.875 && herdModule.getFollowers().isEmpty()) {
            this.state = State.CALLING;
            this.callingTicks = this.maxCallingTicks;
        } else if (this.shouldObserve) {
            this.state = State.OBSERVING;
            this.observeTicks = this.maxObserveTicks;
            this.animal.setObserving(true);
        } else {
            this.state = State.AGGRESSIVE;
        }
        this.recomputePathTicks = 0;
    }

    @Override
    public void tick() {
        LivingEntity target;
        if (this.animal.isResting() || this.animal.isSleeping()) {
            this.animal.getModules().getMetabolismModule().interrupt(400);
        }
        if ((target = this.animal.getTarget()) == null || !target.isAlive()) {
            this.stop();
            return;
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.animal.setAggressive(false);
                if (this.callingTicks > 0) {
                    --this.callingTicks;
                    this.animal.stopInPlace();
                    if (!(this.random.nextDouble() < (double)0.05f)) break;
                    this.animal.callSounds();
                    break;
                }
                State state = this.state = this.shouldObserve ? State.OBSERVING : State.AGGRESSIVE;
                if (this.state != State.OBSERVING) break;
                this.observeTicks = this.maxObserveTicks;
                this.animal.setObserving(true);
                break;
            }
            case 1: {
                this.animal.setAggressive(false);
                if (this.observeTicks > 0 && !this.extraCheckBeforeSwitch(target, this.animal)) {
                    --this.observeTicks;
                    this.animal.stopInPlace();
                    this.animal.getLookControl().setLookAt(target.position());
                    break;
                }
                this.animal.setObserving(false);
                if (this.extraCheckBeforeSwitch(target, this.animal)) {
                    if (!this.canTargetSeeMe(target, (PathfinderMob)this.animal) && this.shouldStalk) {
                        this.state = State.STALKING;
                        this.animal.setStalking(true);
                        break;
                    }
                    this.state = State.AGGRESSIVE;
                    this.animal.setAggressive(true);
                    break;
                }
                this.stop();
                return;
            }
            case 2: {
                this.animal.setAggressive(false);
                double dist = this.animal.distanceTo((Entity)target);
                if (dist <= (double)(this.animal.getAttackReach() * 2.0f) || this.canTargetSeeMe(target, (PathfinderMob)this.animal)) {
                    this.animal.setStalking(false);
                    this.animal.setAggressive(true);
                    this.state = State.AGGRESSIVE;
                    break;
                }
                this.handleMoveTowards(target, 1.0);
                break;
            }
            case 3: {
                this.animal.setAggressive(true);
                this.handleMoveTowards(target, 1.0);
                if (this.attackCooldown == 0) {
                    if (!(target.distanceToSqr((Entity)this.animal) <= (double)this.animal.getAttackReach())) break;
                    this.attack(target);
                    this.recomputePathTicks += 5;
                    this.attackResetTime = this.attackCooldown;
                    break;
                }
                --this.attackCooldown;
            }
        }
    }

    private void handleMoveTowards(LivingEntity target, double speed) {
        JSAnimalBase base;
        if (target.distanceToSqr((Entity)this.animal) <= (double)(this.animal.getAttackReach() / 2.0f) && target instanceof JSAnimalBase && (base = (JSAnimalBase)target).isDead()) {
            return;
        }
        if (this.animal.getNavigationController().isDone() || this.recomputePathTicks == 0) {
            Vec3 targetPos = target.position();
            Vec3 targetLook = target.getLookAngle().normalize();
            double distanceAhead = 1.0;
            Vec3 aheadPos = targetPos.add(targetLook.scale(distanceAhead));
            CompletableFuture moveTo = this.animal.getNavigationController().moveTo(aheadPos.x, aheadPos.y, aheadPos.z);
            if (moveTo != null) {
                moveTo.thenAccept(path -> {
                    if (path == null) {
                        this.recomputePathTicks += 10;
                    } else {
                        path.advance();
                    }
                });
            } else {
                this.recomputePathTicks += 10;
            }
            this.recomputePathTicks += this.random.nextInt(5, 15);
        } else {
            --this.recomputePathTicks;
        }
    }

    protected void attack(LivingEntity target) {
        this.animal.attack(target);
    }

    protected boolean extraCheckBeforeSwitch(LivingEntity target, JSAnimalBase animal) {
        return true;
    }

    private boolean canTargetSeeMe(LivingEntity target, PathfinderMob entity) {
        if (target.level() != entity.level()) {
            return false;
        }
        Vec3 targetEyes = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        Vec3 entityEyes = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (entityEyes.distanceTo(targetEyes) > 64.0) {
            return false;
        }
        return target.level().clip(new ClipContext(targetEyes, entityEyes, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)target)).getType() == HitResult.Type.MISS;
    }

    private boolean isTargetRunningAway(LivingEntity target) {
        Vec3 targetMove;
        double dist = this.animal.distanceTo((Entity)target);
        if (dist < 10.0) {
            return false;
        }
        Vec3 toAnimal = this.animal.position().subtract(target.position()).normalize();
        return toAnimal.dot(targetMove = target.getDeltaMovement().normalize()) < -0.25;
    }

    @Override
    public void onStop() {
        super.onStop();
        this.callingTicks = this.maxCallingTicks;
        this.animal.setObserving(false);
        this.animal.setTarget(null);
        this.animal.setStalking(false);
        this.animal.setAggressive(false);
        this.state = State.AGGRESSIVE;
    }

    private static enum State {
        CALLING,
        OBSERVING,
        STALKING,
        AGGRESSIVE;

    }
}

