/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSCombatTaskBase;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import travelers.server.animal.entity.task.TaskPriority;

public class JSRevengeOrRunTask
extends JSCombatTaskBase {
    private LivingEntity target;

    public JSRevengeOrRunTask(JSAnimalBase baseAnimal) {
        super(baseAnimal);
    }

    public boolean shouldRun() {
        Player player;
        LivingEntity livingEntity;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getTarget() != null && (livingEntity = this.animal.getTarget()) instanceof Player && (player = (Player)livingEntity).isCreative()) {
            this.animal.setTarget(null);
            return false;
        }
        this.target = this.animal.getLastHurtByMob();
        return this.target != null && this.target.isAlive();
    }

    public boolean canContinueRunning() {
        Player player;
        LivingEntity livingEntity;
        if (this.animal.isDead()) {
            return false;
        }
        if (this.animal.getTarget() != null && (livingEntity = this.animal.getTarget()) instanceof Player && (player = (Player)livingEntity).isCreative()) {
            this.animal.setTarget(null);
            return false;
        }
        return this.target != null && this.target.isAlive();
    }

    public TaskPriority getPriority() {
        return TaskPriority.HIGH;
    }

    public void onStart() {
        if (this.target == null) {
            return;
        }
        this.alertHerd(this.target);
        if (this.animal.getModules().getMetabolismModule().canTarget(true, true, this.target)) {
            this.animal.setTarget(this.target);
            this.alertHerd(this.target);
            this.animal.setFleeTarget(null);
        } else {
            this.animal.setFleeTarget(this.target);
            this.animal.setTarget(null);
        }
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
    }

    private void alertHerd(LivingEntity threat) {
        JSAnimalBase trueLeader = this.animal.getModules().getHerdModule().getTrueLeader();
        if (trueLeader != null) {
            for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                if (follower.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT) {
                    follower.setTarget(threat);
                    continue;
                }
                follower.setFleeTarget(threat);
            }
            trueLeader.setTarget(threat);
        }
    }

    public void onStop() {
        this.target = null;
        this.animal.setTarget(null);
        this.animal.setFleeTarget(null);
    }
}

