/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSTaskBase;
import jp.jurassicsaga.server.base.animal.entity.util.JSTaskUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public class JSFindWaterTask
extends JSTaskBase {
    private Vec3 targetPos;
    private Vec3 targetWater;
    private int drinkingTicks;
    private int ticks;
    private int lastSearchTick = -9999;
    private int checkCooldown;
    private boolean pathStarted;
    private boolean scanning;
    private final ThreadLocalRandom rng = ThreadLocalRandom.current();
    private final AtomicInteger pendingPaths = new AtomicInteger();
    private final List<Candidate> candidates = new ArrayList<Candidate>(32);
    private static final int SEARCH_INTERVAL = 20;
    private static final int MAX_CANDIDATES = 24;
    private static final int MAX_REQS_PER_SEARCH = 3;
    private static final int MAX_CONCURRENT_PATHS = 4;
    private static final int SCAN_STEP = 5;
    private static final int MAX_LAST_DRANK_DIST = 512;
    private static final int SLICE_SIZE = 64;
    private boolean requiresShore = false;
    private int range = 64;

    public JSFindWaterTask(JSAnimalBase animal) {
        super(animal);
        this.getGoals().add(TaskGoal.METABOLISM);
        this.getGoals().add(TaskGoal.MOVEMENT);
    }

    public JSFindWaterTask noShore() {
        this.requiresShore = false;
        return this;
    }

    public JSFindWaterTask setRange(int range) {
        this.range = range;
        return this;
    }

    public TaskPriority getPriority() {
        if (this.animal.isDead()) {
            return TaskPriority.NONE;
        }
        float thirst = (float)this.animal.getModules().getMetabolismModule().thirstPercentage();
        if ((double)thirst > 0.8) {
            return TaskPriority.LOW;
        }
        if ((double)thirst > 0.6) {
            return TaskPriority.MEDIUM;
        }
        if ((double)thirst > 0.4) {
            return TaskPriority.HIGH;
        }
        if ((double)thirst > 0.2) {
            return TaskPriority.VERY_HIGH;
        }
        return TaskPriority.DIRECT;
    }

    public boolean shouldRun() {
        if (this.checkCooldown < 0) {
            this.checkCooldown = 0;
        }
        if (this.checkCooldown-- != 0 || this.animal.isDead()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirsty()) {
            return false;
        }
        if (!this.animal.getAnimal().getAnimalAttributes().getMetabolismProperties().isThirstEnabled()) {
            return false;
        }
        if (this.animal.lastDrankAtPos != null && this.animal.lastDrankAtPos.distSqr((Vec3i)this.animal.blockPosition()) > 262144.0) {
            this.animal.lastDrankAtPos = null;
        }
        if (this.ticks - this.lastSearchTick >= 20 && !this.scanning && this.candidates.isEmpty()) {
            BlockPos center = this.animal.blockPosition();
            this.lastSearchTick = this.ticks;
            this.scanning = true;
            CompletableFuture.runAsync(() -> {
                try {
                    this.collectCandidates(center, this.range);
                }
                finally {
                    this.scanning = false;
                }
            });
        }
        if (this.targetPos != null && this.targetWater != null) {
            return true;
        }
        if (!this.candidates.isEmpty()) {
            this.requestPaths();
        }
        ++this.ticks;
        return this.scanning || this.targetPos != null && this.targetWater != null;
    }

    public boolean canContinueRunning() {
        if (this.animal.isDead()) {
            return false;
        }
        if (!this.animal.getModules().getMetabolismModule().isThirstEnabled()) {
            return false;
        }
        return this.scanning || this.pendingPaths.get() > 0 || !this.candidates.isEmpty() || this.targetPos != null && this.targetWater != null;
    }

    public boolean canInterrupt() {
        return this.targetPos == null;
    }

    public void onStart() {
        this.animal.getNavigationController().stop();
        this.animal.setAggressive(true);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.scanning) {
            return;
        }
        if (this.checkCooldown > 0) {
            --this.checkCooldown;
        }
        ++this.drinkingTicks;
        if (this.drinkingTicks > 200 && this.animal.getNavigationController().isDone() && this.animal.getNavigationController().isStuck()) {
            this.stop();
            this.checkCooldown = 5;
            return;
        }
        if (this.reachedWater()) {
            this.drink();
            return;
        }
        if (this.targetPos == null && !this.candidates.isEmpty()) {
            Candidate next = this.candidates.remove(0);
            this.targetPos = Vec3.atCenterOf((Vec3i)next.land);
            this.targetWater = Vec3.atCenterOf((Vec3i)next.water);
            this.pathStarted = false;
        }
        if (this.targetPos != null && (!this.pathStarted || this.animal.getNavigationController().isDone()) && this.pendingPaths.get() < 4) {
            CompletableFuture future = this.animal.getNavigationController().createPath(this.targetPos.x, this.targetPos.y, this.targetPos.z, 1);
            if (future != null) {
                this.pendingPaths.incrementAndGet();
                future.thenAccept(path -> {
                    try {
                        if (path != null) {
                            this.animal.getNavigationController().moveTo(path);
                            this.pathStarted = true;
                        } else {
                            this.clearTarget();
                        }
                    }
                    finally {
                        this.pendingPaths.decrementAndGet();
                    }
                });
            } else {
                this.clearTarget();
            }
        }
        ++this.ticks;
    }

    public void onStop() {
        this.animal.setAggressive(false);
    }

    public void cleanUp() {
        this.clearAll();
    }

    private void drink() {
        this.animal.getNavigationController().stop();
        if (this.targetWater != null) {
            this.animal.lookAt(EntityAnchorArgument.Anchor.FEET, this.targetWater);
        }
        this.animal.getModules().getMetabolismModule().setThirst(this.animal.getModules().getMetabolismModule().getMaxThirst());
        this.animal.curDrinkTicks = 5;
        if (this.targetWater != null) {
            this.animal.lastDrankAtPos = BlockPos.containing((Position)this.targetWater);
        }
        this.clearTarget();
        this.drinkingTicks = 0;
        this.checkCooldown = 10;
    }

    private boolean reachedWater() {
        return this.targetPos != null && JSTaskUtils.isCloseEnough(this.animal, this.targetPos, 3.0f) || this.animal.isInWater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCandidates(BlockPos center, int halfRange) {
        Level lvl = this.animal.level();
        Vec3 mobPos = this.animal.position();
        List found = Collections.synchronizedList(new ArrayList());
        int minX = center.getX() - halfRange;
        int maxX = center.getX() + halfRange;
        int minZ = center.getZ() - halfRange;
        int maxZ = center.getZ() + halfRange;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (int sx = minX; sx <= maxX; sx += 64) {
            int sliceMaxX = Math.min(maxX, sx + 64 - 1);
            for (int sz = minZ; sz <= maxZ; sz += 64) {
                int sliceMaxZ = Math.min(maxZ, sz + 64 - 1);
                int finalSx = sx;
                int finalSz = sz;
                futures.add(CompletableFuture.runAsync(() -> {
                    BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
                    for (int x = finalSx; x <= sliceMaxX; x += 5) {
                        block1: for (int z = finalSz; z <= sliceMaxZ; z += 5) {
                            int surfaceY = lvl.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
                            BlockPos pos = new BlockPos(x, surfaceY - 1, z);
                            if (!lvl.getFluidState(pos).is(FluidTags.WATER) || !lvl.getBlockState(pos.above()).isAir()) continue;
                            if (this.requiresShore) {
                                for (Direction dir : Direction.Plane.HORIZONTAL) {
                                    check.setWithOffset((Vec3i)pos, dir);
                                    if (!lvl.getBlockState((BlockPos)check).isAir() || !lvl.getBlockState(check.above()).isAir() || !lvl.getBlockState(check.below()).isSolidRender((BlockGetter)lvl, check.below())) continue;
                                    found.add(new Candidate(check.immutable(), pos.immutable(), mobPos.distanceToSqr(Vec3.atCenterOf((Vec3i)check))));
                                    continue block1;
                                }
                                continue;
                            }
                            found.add(new Candidate(pos.immutable(), pos.immutable(), mobPos.distanceToSqr(Vec3.atCenterOf((Vec3i)pos))));
                        }
                    }
                }));
            }
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        found.sort((a, b) -> {
            double da = a.dist * (1.0 + this.rng.nextDouble() * 0.25);
            double db = b.dist * (1.0 + this.rng.nextDouble() * 0.25);
            return Double.compare(da, db);
        });
        if (found.size() > 24) {
            found.subList(24, found.size()).clear();
        }
        List<Candidate> list = this.candidates;
        synchronized (list) {
            this.candidates.removeIf(this::isInvalid);
            this.candidates.addAll(found);
        }
    }

    private boolean isInvalid(Candidate c) {
        Level lvl = this.animal.level();
        if (!lvl.getFluidState(c.water).is(FluidTags.WATER)) {
            return true;
        }
        if (!lvl.getBlockState(c.water.above()).isAir()) {
            return true;
        }
        if (this.requiresShore) {
            if (!lvl.getBlockState(c.land).isAir()) {
                return true;
            }
            if (!lvl.getBlockState(c.land.above()).isAir()) {
                return true;
            }
            return !lvl.getBlockState(c.land.below()).isSolidRender((BlockGetter)lvl, c.land.below());
        }
        return false;
    }

    private void requestPaths() {
        int reqs = 0;
        for (Candidate c : this.candidates) {
            if (reqs >= 3 || this.pendingPaths.get() >= 4 || this.targetPos != null) break;
            CompletableFuture future = this.animal.getNavigationController().createPath(c.land, 0.0);
            if (future == null) continue;
            this.targetPos = Vec3.atCenterOf((Vec3i)c.land);
            this.targetWater = Vec3.atCenterOf((Vec3i)c.water);
            this.pathStarted = false;
            this.pendingPaths.incrementAndGet();
            ++reqs;
            future.thenAccept(path -> {
                try {
                    if (path != null) {
                        this.animal.getNavigationController().moveTo(path);
                        this.pathStarted = true;
                    } else {
                        this.clearTarget();
                    }
                }
                finally {
                    this.pendingPaths.decrementAndGet();
                }
            });
        }
    }

    private void clearTarget() {
        this.targetWater = null;
        this.targetPos = null;
        this.pathStarted = false;
    }

    private void clearAll() {
        this.clearTarget();
        this.checkCooldown = 0;
        this.ticks = 0;
        this.drinkingTicks = 0;
        this.pendingPaths.set(0);
        this.pathStarted = false;
        this.scanning = false;
    }

    private record Candidate(BlockPos land, BlockPos water, double dist) {
    }
}

