/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.block.obj.plant;

import java.util.Random;
import jp.jurassicsaga.server.base.block.obj.JSBlockStateProperties;
import jp.jurassicsaga.server.base.block.obj.plant.JSPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.SegmentPart;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentedTallPlant
extends JSPlantBlock {
    public static final EnumProperty<SegmentPart> PART = JSBlockStateProperties.SEGMENTED;
    public static final EnumProperty<SegmentPart> START_PART = JSBlockStateProperties.START_SEGMENT;
    private final SegmentPart maxSegment;
    private final boolean randomStartHeight;
    private final Random random = new Random();

    public SegmentedTallPlant(BlockBehaviour.Properties properties, SegmentPart maxSegment) {
        this(properties, maxSegment, false);
    }

    public SegmentedTallPlant(BlockBehaviour.Properties properties, SegmentPart maxSegment, boolean randomStartHeight) {
        super(properties);
        this.randomStartHeight = randomStartHeight;
        this.maxSegment = maxSegment;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(START_PART, (Comparable)((Object)maxSegment)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)maxSegment)));
    }

    public static BlockState copyWaterloggedFrom(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return pState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)pState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.isWaterAt(pPos))) : pState;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        return blockpos.getY() < level.getMaxBuildHeight() - 2 && level.getBlockState(blockpos.above()).canBeReplaced(pContext) && level.getBlockState(blockpos.above().above()).canBeReplaced(pContext) ? super.getStateForPlacement(pContext) : null;
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        int startCount;
        BlockState state;
        SegmentPart start = this.maxSegment;
        if (this.randomStartHeight && this.random.nextBoolean()) {
            float nextFloat = this.random.nextFloat();
            start = nextFloat <= 0.4f ? this.maxSegment.getPartBelow() : ((double)nextFloat >= 0.6 ? this.maxSegment.getPartBelow().getPartBelow() : this.maxSegment.getPartBelow().getPartBelow().getPartBelow());
        }
        int segmentCount = this.maxSegment.getOffset() + 1;
        int offset = 0;
        if (segmentCount >= 8) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_8)));
            state = (BlockState)state.setValue(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 8) {
                    pLevel.setBlock(pPos.above(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.setBlock(pPos.above(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 7) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_7)));
            state = (BlockState)state.setValue(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 7) {
                    pLevel.setBlock(pPos.above(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.setBlock(pPos.above(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 6) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_6)));
            state = (BlockState)state.setValue(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 7) {
                    pLevel.setBlock(pPos.above(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.setBlock(pPos.above(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 5) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_5)));
            state = (BlockState)state.setValue(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 5) {
                    pLevel.setBlock(pPos.above(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.setBlock(pPos.above(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 4) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_4)));
            state = (BlockState)state.setValue(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 4) {
                    pLevel.setBlock(pPos.above(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.setBlock(pPos.above(offset), state, 3);
                ++offset;
            }
        }
        if (segmentCount >= 3) {
            state = SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_3)));
            state = (BlockState)state.setValue(START_PART, (Comparable)((Object)start));
            if (this.randomStartHeight) {
                startCount = start.getOffset() + 1;
                if (startCount >= 3) {
                    pLevel.setBlock(pPos.above(offset), state, 3);
                    ++offset;
                }
            } else {
                pLevel.setBlock(pPos.above(offset), state, 3);
                ++offset;
            }
        }
        pLevel.setBlock(pPos.above(offset), SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_2))).setValue(START_PART, (Comparable)((Object)start))), 3);
        pLevel.setBlock(pPos.above(++offset), SegmentedTallPlant.copyWaterloggedFrom((LevelReader)pLevel, pPos, (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)SegmentPart.SEGMENT_1))).setValue(START_PART, (Comparable)((Object)start))), 3);
    }

    public boolean canSurvive(BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        SegmentPart part = (SegmentPart)((Object)pState.getValue(PART));
        SegmentPart startPart = (SegmentPart)((Object)pState.getValue(START_PART));
        if (startPart == SegmentPart.SEGMENT_1) {
            return this.mayPlaceOn(pLevel.getBlockState(pPos.below()), (BlockGetter)pLevel, pPos.below());
        }
        if (part == startPart) {
            return this.mayPlaceOn(pLevel.getBlockState(pPos.below()), (BlockGetter)pLevel, pPos.below()) && pLevel.getBlockState(pPos.above()).is((Block)this);
        }
        if (part != SegmentPart.SEGMENT_1 && !pLevel.getBlockState(pPos.above()).is((Block)this)) {
            return false;
        }
        return pLevel.getBlockState(pPos.below()).hasProperty(PART);
    }

    @NotNull
    public BlockState playerWillDestroy(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.isClientSide && !pPlayer.isCreative()) {
            SegmentedTallPlant.dropResources((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)pPlayer, (ItemStack)pPlayer.getMainHandItem());
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{PART});
        pBuilder.add(new Property[]{START_PART});
    }

    public long getSeed(BlockState pState, BlockPos pPos) {
        return Mth.getSeed((int)pPos.getX(), (int)pPos.below(((SegmentPart)((Object)pState.getValue(PART))).getOffset()).getY(), (int)pPos.getZ());
    }

    public SegmentPart getMaxSegment() {
        return this.maxSegment;
    }
}

