/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.entity.obj.vanilla;

import java.util.function.IntFunction;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class JSBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.defineId(JSBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public JSBoatEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)JSEntities.BOAT.get()), level);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public JSBoatEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public Item getDropItem() {
        return switch (this.getNWBoatEntityType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Item)JSV1Items.ARAUCARIOXYLON_BOAT.get();
            case 1 -> (Item)JSV1Items.GORDONOPTERIS_BOAT.get();
            case 2 -> (Item)JSV1Items.LEPIDODENDRON_BOAT.get();
            case 3 -> (Item)JSV1Items.SPINIFRUCTUS_BOAT.get();
        };
    }

    public CustomType getNWBoatEntityType() {
        return CustomType.byId((Integer)this.entityData.get(BOAT_TYPE));
    }

    public void setNWBoatEntityType(CustomType type) {
        this.entityData.set(BOAT_TYPE, (Object)type.ordinal());
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(BOAT_TYPE, (Object)CustomType.ARAUCARIOXYLON.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("CustomType", this.getNWBoatEntityType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("CustomType", 8)) {
            this.setNWBoatEntityType(CustomType.byName(compound.getString("CustomType")));
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity p_352110_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352110_);
    }

    public static enum CustomType implements StringRepresentable
    {
        ARAUCARIOXYLON((Block)JSV1Blocks.ARAUCARIOXYLON.BLOCK.get(), "araucarioxylon"),
        GORDONPTERIS((Block)JSV1Blocks.GORDONPTERIS.BLOCK.get(), "gordonopteris"),
        LEPIDODENDRON((Block)JSV1Blocks.LEPIDODENDRON.BLOCK.get(), "lepidodendron"),
        SPINIFRUCTUS((Block)JSV1Blocks.SPINIFRUCTUS.BLOCK.get(), "spinifructus");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<CustomType> CODEC;
        private static final IntFunction<CustomType> BY_ID;

        private CustomType(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static CustomType byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static CustomType byName(String pName) {
            return (CustomType)CODEC.byName(pName, (Enum)ARAUCARIOXYLON);
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        static {
            CODEC = StringRepresentable.fromEnum(CustomType::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])CustomType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

