/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.networking.obj;

import io.netty.buffer.ByteBuf;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.AquaticFeederEntity;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.CarnivoreFeederEntity;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder.HerbivoreFeederEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import travelers.server.packet.TravelersPacketsHandler;
import travelers.util.helper.PlatformHelper;

public record UpdateMachine(ResourceLocation level, BlockPos blockPos, String machineName, String dataType, String newData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateMachine> TYPE = new CustomPacketPayload.Type(JSCommon.createId("updatemachine"));
    public static final StreamCodec<ByteBuf, UpdateMachine> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, UpdateMachine::level, (StreamCodec)BlockPos.STREAM_CODEC, UpdateMachine::blockPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateMachine::machineName, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateMachine::dataType, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateMachine::newData, UpdateMachine::new);

    public static TravelersPacketsHandler<UpdateMachine> createHandler() {
        return new TravelersPacketsHandler<UpdateMachine>(){

            public void serverPacket(CustomPacketPayload packet) {
                UpdateMachine updateMachine = (UpdateMachine)packet;
                ResourceKey type = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)updateMachine.level());
                try {
                    ServerLevel level = PlatformHelper.properties.getServer().getLevel(type);
                    if (level != null) {
                        GenericMachineEntity blockEntity;
                        BlockEntity blockEntity2;
                        if (updateMachine.machineName().equalsIgnoreCase("herbivore_feeder") && (blockEntity2 = level.getBlockEntity(updateMachine.blockPos())) instanceof HerbivoreFeederEntity) {
                            blockEntity = (HerbivoreFeederEntity)blockEntity2;
                            ((HerbivoreFeederEntity)blockEntity).setSliderPos(Integer.parseInt(updateMachine.newData()));
                        }
                        if (updateMachine.machineName().equalsIgnoreCase("carnivore_feeder") && (blockEntity2 = level.getBlockEntity(updateMachine.blockPos())) instanceof CarnivoreFeederEntity) {
                            blockEntity = (CarnivoreFeederEntity)blockEntity2;
                            ((CarnivoreFeederEntity)blockEntity).setSliderPos(Integer.parseInt(updateMachine.newData()));
                        }
                        if (updateMachine.machineName().equalsIgnoreCase("aquatic_feeder") && (blockEntity2 = level.getBlockEntity(updateMachine.blockPos())) instanceof AquaticFeederEntity) {
                            blockEntity = (AquaticFeederEntity)blockEntity2;
                            ((AquaticFeederEntity)blockEntity).setSliderPos(Integer.parseInt(updateMachine.newData()));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

