/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.generic.obj;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.List;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.base.generic.util.JSUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public enum Era {
    NONE("none", null, null, false, false, new PossibleResult[0]),
    CAMBRIAN("cambrian", new GenerationSettings(12, JSUtils.eraHeight(13), JSUtils.eraHeight(12), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), false, false, PossibleResult.MARINE_DEPOSIT),
    ORDOVICIAN("ordovician", new GenerationSettings(12, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), false, false, PossibleResult.MARINE_DEPOSIT),
    SILURIAN("silurian", new GenerationSettings(12, JSUtils.eraHeight(11), JSUtils.eraHeight(10), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), false, false, PossibleResult.MARINE_DEPOSIT, PossibleResult.PLANT_FOSSIL),
    DEVONIAN("devonian", new GenerationSettings(12, JSUtils.eraHeight(10), JSUtils.eraHeight(9), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), false, false, PossibleResult.MARINE_DEPOSIT, PossibleResult.PLANT_FOSSIL),
    CARBONIFEROUS("carboniferous", new GenerationSettings(12, JSUtils.eraHeight(9), JSUtils.eraHeight(8), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), true, true, PossibleResult.MEGABUG, PossibleResult.PLANT_FOSSIL, PossibleResult.PLANTS_IN_AMBER, PossibleResult.MARINE_DEPOSIT),
    PERMIAN("permian", new GenerationSettings(12, JSUtils.eraHeight(8), JSUtils.eraHeight(7), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), true, true, PossibleResult.CICADOMORPH_IN_AMBER, PossibleResult.MARINE_DEPOSIT, PossibleResult.PLANT_FOSSIL, PossibleResult.UNIDENTIFIED_SUCKER),
    TRIASSIC("triassic", new GenerationSettings(12, JSUtils.eraHeight(7), JSUtils.eraHeight(6), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), true, true, PossibleResult.CICADA_IN_AMBER, PossibleResult.MARINE_DEPOSIT, PossibleResult.MOSQUITO_IN_AMBER, PossibleResult.PLANT_FOSSIL),
    JURASSIC("jurassic", new GenerationSettings(12, JSUtils.eraHeight(6), JSUtils.eraHeight(5), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), true, true, PossibleResult.CICADA_IN_AMBER, PossibleResult.MARINE_DEPOSIT, PossibleResult.MOSQUITO_IN_AMBER, PossibleResult.PLANT_FOSSIL),
    CRETACEOUS("cretaceous", new GenerationSettings(12, JSUtils.eraHeight(5), JSUtils.eraHeight(4), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), true, true, PossibleResult.CICADA_IN_AMBER, PossibleResult.MARINE_DEPOSIT, PossibleResult.MOSQUITO_IN_AMBER, PossibleResult.PLANT_FOSSIL),
    PALEOGENE("paleogene", new GenerationSettings(12, JSUtils.eraHeight(4), JSUtils.eraHeight(3), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), true, true, PossibleResult.CICADA_IN_AMBER, PossibleResult.MARINE_DEPOSIT, PossibleResult.MOSQUITO_IN_AMBER, PossibleResult.PLANT_FOSSIL),
    NEOGENE("neogene", new GenerationSettings(12, JSUtils.eraHeight(3), JSUtils.eraHeight(2), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), true, true, PossibleResult.CICADA_IN_AMBER, PossibleResult.MARINE_DEPOSIT, PossibleResult.MOSQUITO_IN_AMBER, PossibleResult.PLANT_FOSSIL),
    QUATERNARY("quaternary", new GenerationSettings(12, JSUtils.eraHeight(2), JSUtils.eraHeight(1), 3, new Biome[0]), new GenerationSettings(3, JSUtils.eraHeight(12), JSUtils.eraHeight(11), 3, new Biome[0]), false, true, PossibleResult.CICADA_IN_AMBER, PossibleResult.MARINE_DEPOSIT, PossibleResult.MOSQUITO_IN_AMBER, PossibleResult.PLANT_FOSSIL);

    private final String eraName;
    private final HashMap<PossibleResult, Supplier<Item>> registryMap = new HashMap();
    private final List<PossibleResult> results;
    private final GenerationSettings generationSettings;
    private final GenerationSettings generationSettingsMarine;
    private final boolean hasMarineOre;
    private final boolean hasFossilOre;
    private Supplier<Block> marineOre = null;
    private Supplier<Block> fossilOre = null;

    private Era(String eraName, GenerationSettings generationSettings, GenerationSettings generationSettingsMarine, boolean hasMarineOre, boolean hasFossilOre, PossibleResult ... results) {
        this.eraName = eraName;
        this.generationSettings = generationSettings;
        this.generationSettingsMarine = generationSettingsMarine;
        this.results = List.of(results);
        this.hasFossilOre = hasFossilOre;
        this.hasMarineOre = hasMarineOre;
    }

    public String getEraName() {
        return this.eraName;
    }

    public HashMap<PossibleResult, Supplier<Item>> getRegistryMap() {
        return this.registryMap;
    }

    public List<PossibleResult> getResults() {
        return this.results;
    }

    public GenerationSettings getGenerationSettings() {
        return this.generationSettings;
    }

    public GenerationSettings getGenerationSettingsMarine() {
        return this.generationSettingsMarine;
    }

    public boolean isHasMarineOre() {
        return this.hasMarineOre;
    }

    public boolean isHasFossilOre() {
        return this.hasFossilOre;
    }

    public Supplier<Block> getMarineOre() {
        return this.marineOre;
    }

    public Supplier<Block> getFossilOre() {
        return this.fossilOre;
    }

    public void setMarineOre(Supplier<Block> marineOre) {
        this.marineOre = marineOre;
    }

    public void setFossilOre(Supplier<Block> fossilOre) {
        this.fossilOre = fossilOre;
    }

    public record GenerationSettings(int size, int yMin, int yMax, int maxOres, Biome[] biomes) {
    }
}

