/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.animal.entity.extinct.terrestial;

import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.JSFloatTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSHerdCombatFollowTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSRevengeOrRunTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.combat.JSTargetTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindFoodTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.metabolism.JSFindWaterTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.misc.JSRestTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSFleeTask;
import jp.jurassicsaga.server.base.animal.entity.obj.tasks.navigation.JSRandomStrollTask;
import jp.jurassicsaga.server.base.entity.obj.other.IJSRangedAttack;
import jp.jurassicsaga.server.base.entity.obj.other.VenomSpit;
import jp.jurassicsaga.server.v1.animal.entity.obj.task.DiloSpitTask;
import jp.jurassicsaga.server.v1.sound.JSV1Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.task.TravelerTaskBase;
import travelers.server.animal.entity.task.TravelerTaskController;

public class DilophosaurusEntity
extends JSAnimalBase
implements RangedAttackMob,
IJSRangedAttack {
    public boolean frillDown;
    public boolean frillUp;
    private boolean didSpit;

    public DilophosaurusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
        controller.registerTask((TravelerTaskBase)new JSFloatTask(this));
        controller.registerTask((TravelerTaskBase)new JSFleeTask(this, 30));
        controller.registerTask((TravelerTaskBase)new JSRandomStrollTask(this).setRange(16, 4));
        controller.registerTask((TravelerTaskBase)new JSFindFoodTask(this));
        controller.registerTask((TravelerTaskBase)new JSFindWaterTask(this));
        controller.registerTask((TravelerTaskBase)new JSHerdCombatFollowTask(this));
        controller.registerTask((TravelerTaskBase)new JSRevengeOrRunTask(this));
        controller.registerTask((TravelerTaskBase)new DiloSpitTask(this, 1.0, 40, 80, 32.0f));
        controller.registerTask((TravelerTaskBase)new JSRestTask(this));
        combatTargeting.registerTask((TravelerTaskBase)new JSTargetTask(this, true));
    }

    @Override
    protected int attackAnimLength() {
        return 24;
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        this.getAnimationModule().playTransition(this.frillUp, JSAnimations.FRILL_OUT.wrap(10), JSAnimations.FRILL_SHAKE.wrap(), JSAnimations.FRILL_IN.wrap(10));
    }

    public double jumpHeight() {
        if (this.getModules().getGrowthStageModule().getGrowthStage() == AnimalGrowthStage.ADULT && !this.isInWater()) {
            return 2.0;
        }
        return 1.0;
    }

    @Override
    public void onSuccess() {
        this.didSpit = true;
    }

    @Override
    public boolean shouldContinue() {
        return !this.didSpit && !this.isDead();
    }

    @Override
    public void reset() {
        this.didSpit = false;
    }

    @Override
    public boolean canUse() {
        return false;
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        VenomSpit venomSpit = new VenomSpit(this.level(), this);
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.1) - venomSpit.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        venomSpit.shoot(d0, d1 + d3, d2, 1.5f, 2.0f);
        if (!this.isSilent() && this.getAttackSound() != null) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getAttackSound(), this.getSoundSource(), this.getSoundVolume(), 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity((Entity)venomSpit);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSV1Sounds.DILOPHOSAURUS_LIVING.get();
    }

    @Override
    @Nullable
    protected SoundEvent getAttackSound() {
        return (SoundEvent)JSV1Sounds.DILOPHOSAURUS_ATTACK.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSV1Sounds.DILOPHOSAURUS_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)JSV1Sounds.DILOPHOSAURUS_HURT.get();
    }
}

