/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.block.entity.geo.machine.feeder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.animals.JSAnimations;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalDietType;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.JSMetabolismModule;
import jp.jurassicsaga.server.base.sound.JSSounds;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.block.entity.JSV1BlockEntities;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v1.menu.obj.machine.feeder.AquaticFeederMenu;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AquaticFeederEntity
extends GenericMachineEntity {
    private final ContainerData data;
    private int sliderPos = 50;
    private int openTicks = 0;
    private boolean hasToDispense;
    private int openTime = 0;
    private int closeTicks = 0;
    private int checkForFeedCooldown = 200;
    private boolean hasResult = false;
    private final ArrayList<Entity> dispensed = new ArrayList();

    public AquaticFeederEntity(BlockPos pos, BlockState blockState) {
        super(19, (Block)JSV1Blocks.AQUATIC_FEEDER.get(), (BlockEntityType)JSV1BlockEntities.AQUATIC_FEEDER.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return AquaticFeederEntity.this.sliderPos;
            }

            public void set(int index, int value) {
                AquaticFeederEntity.this.sliderPos = value;
            }

            public int getCount() {
                return 1;
            }
        };
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("sliderPos", this.sliderPos);
        tag.putInt("openTicks", this.openTicks);
        tag.putInt("openTime", this.openTime);
        tag.putBoolean("hasToDispense", this.hasToDispense);
        tag.putInt("closeTicks", this.closeTicks);
        return tag;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("sliderPos", this.sliderPos);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setSliderPos(tag.getInt("sliderPos"));
    }

    @Override
    protected void animate(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof AquaticFeederEntity) {
            AquaticFeederEntity feeder = (AquaticFeederEntity)be;
            if (this.openTicks > 0) {
                if (this.openTicks == 40) {
                    feeder.playSound(state, (SoundEvent)JSSounds.HATCH_DOOR.get());
                }
                --this.openTicks;
                JSAnimations.OPEN.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.openTime > 0) {
                --this.openTime;
                JSAnimations.OPENED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
                return;
            }
            if (this.closeTicks > 0) {
                if (this.closeTicks == 39) {
                    feeder.playSound(state, (SoundEvent)JSSounds.HATCH_DOOR.get());
                }
                --this.closeTicks;
                JSAnimations.CLOSE.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
            } else {
                JSAnimations.CLOSED.getAzureAnimation().getCommand().sendForBlockEntity((BlockEntity)be);
            }
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public void setSliderPos(int sliderPos) {
        this.sliderPos = sliderPos;
        this.data.set(0, sliderPos);
        this.setChanged();
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.empty();
    }

    @Override
    public void workTick(Level level, GenericMachineEntity be, BlockState state, BlockPos pos) {
        if (be instanceof AquaticFeederEntity) {
            AquaticFeederEntity herbivoreFeederEntity = (AquaticFeederEntity)be;
            if (this.openTicks == 0 && this.openTime == 10 && this.hasToDispense) {
                for (int i = 0; i < 6 && this.tryDispenseOne(); ++i) {
                }
                if (!level.isClientSide) {
                    this.hasResult = false;
                    this.hasToDispense = false;
                    if (!this.dispensed.isEmpty()) {
                        List entities = level.getEntitiesOfClass(JSAnimalBase.class, new AABB(-24.0, -16.0, -24.0, 24.0, 32.0, 24.0).move(pos), base -> base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.CARNIVORE) || base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.PISCIVORE) && !base.isDead() && base.isSwimming());
                        for (JSAnimalBase entity : entities) {
                            Optional<Entity> randomEntity = this.dispensed.stream().filter(e -> e instanceof LivingEntity).findAny();
                            if (!entity.getModules().getMetabolismModule().isHungry()) continue;
                            if (!randomEntity.isPresent()) break;
                            entity.setTarget((LivingEntity)randomEntity.get());
                        }
                        this.dispensed.clear();
                    }
                }
            }
            if (level.isClientSide && this.hasResult) {
                Vec3 center = pos.getCenter();
                for (int i = 0; i < 50; ++i) {
                    level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 8.0f), center.x() + this.random.nextDouble() * 2.0 - 1.0, center.y() + 0.25 + this.random.nextDouble() - 1.0, center.z() + this.random.nextDouble() * 2.0 - 1.0, 4.0, 16.0, 4.0);
                }
                this.hasResult = false;
                this.hasToDispense = false;
            }
            if (level.isClientSide) {
                return;
            }
            if (this.checkForFeedCooldown > 0) {
                --this.checkForFeedCooldown;
            } else {
                List entities = level.getEntitiesOfClass(JSAnimalBase.class, new AABB(-24.0, -16.0, -24.0, 24.0, 16.0, 24.0).move(pos), base -> base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.CARNIVORE) || base.getModules().getMetabolismModule().getDiet().is(AnimalDietType.PISCIVORE) && !base.isDead() && base.isSwimming());
                if (!entities.isEmpty()) {
                    for (JSAnimalBase entity : entities) {
                        JSMetabolismModule metabolism = entity.getModules().getMetabolismModule();
                        float percentage = (float)metabolism.hungerPercentage();
                        if (!(percentage * 100.0f < (float)(herbivoreFeederEntity.getSliderPos() + 20))) continue;
                        this.dispense();
                        this.checkForFeedCooldown = 1000;
                        return;
                    }
                }
                this.checkForFeedCooldown = 200;
            }
        }
    }

    private boolean tryDispenseOne() {
        int slot = -1;
        ItemStack stack = null;
        EntityType type = null;
        for (int i = 0; i < 5; ++i) {
            ItemStack itemSlot = (ItemStack)this.getItems().get(i);
            if (!itemSlot.is(ItemTags.FISHES) && !itemSlot.is(JSItemTags.CARNIVORE_EDIBLE) && !itemSlot.is(JSItemTags.PISCIVORE_EDIBLE) || itemSlot.getCount() <= 1) continue;
            slot = i;
            stack = itemSlot;
            if (stack.is(Items.COD) || stack.is(Items.COOKED_COD)) {
                type = EntityType.COD;
                break;
            }
            if (stack.is(Items.SALMON) || stack.is(Items.COOKED_SALMON)) {
                type = EntityType.SALMON;
                break;
            }
            if (stack.is(Items.TROPICAL_FISH)) {
                type = EntityType.TROPICAL_FISH;
                break;
            }
            if (stack.is((Item)JSV1Animals.BONITO.getItems().getRawMeat().get())) {
                type = (EntityType)JSV1Animals.BONITO.getEntityType().get();
                break;
            }
            if (!stack.is((Item)JSV1Items.SQUID.get()) && !stack.is((Item)JSV1Items.SQUID_COOKED.get())) break;
            type = EntityType.SQUID;
            break;
        }
        if (slot == -1) {
            return false;
        }
        this.hasResult = true;
        if (type == null) {
            return false;
        }
        assert (this.level != null);
        if (this.level.getEntitiesOfClass(type.getBaseClass(), new AABB(this.getBlockPos()).inflate(8.0)).size() > 5) {
            return false;
        }
        if (this.level.isClientSide) {
            return true;
        }
        if (this.level.getGameRules().getBoolean(JSCommon.FEEDER_DISPENSE_DRAIN)) {
            stack.shrink(2);
        }
        this.getItems().set(slot, (Object)stack);
        LivingEntity entity = (LivingEntity)type.create(this.level);
        if (entity == null) {
            return false;
        }
        if (entity instanceof TropicalFish) {
            TropicalFish.Variant tropicalfish$variant;
            TropicalFish fish = (TropicalFish)entity;
            RandomSource randomsource = this.level.getRandom();
            if ((double)randomsource.nextFloat() < 0.9) {
                tropicalfish$variant = (TropicalFish.Variant)Util.getRandom((List)TropicalFish.COMMON_VARIANTS, (RandomSource)randomsource);
            } else {
                Object[] atropicalfish$pattern = TropicalFish.Pattern.values();
                Object[] adyecolor = DyeColor.values();
                TropicalFish.Pattern tropicalfish$pattern = (TropicalFish.Pattern)Util.getRandom((Object[])atropicalfish$pattern, (RandomSource)randomsource);
                DyeColor dyecolor = (DyeColor)Util.getRandom((Object[])adyecolor, (RandomSource)randomsource);
                DyeColor dyecolor1 = (DyeColor)Util.getRandom((Object[])adyecolor, (RandomSource)randomsource);
                tropicalfish$variant = new TropicalFish.Variant(tropicalfish$pattern, dyecolor, dyecolor1);
            }
            fish.setVariant(tropicalfish$variant.pattern());
        }
        Vec3 pos = this.getBlockPos().getCenter().add(0.0, -0.5, 0.0);
        entity.setPos(pos);
        float rot = switch ((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        entity.setYRot(rot);
        entity.setYBodyRot(rot);
        entity.setYHeadRot(rot);
        float radians = (float)Math.toRadians(entity.getYRot());
        double x = -Math.sin(radians);
        double z = Math.cos(radians);
        double speed = 0.5;
        entity.setDeltaMovement(x * speed, 0.0, z * speed);
        this.level.addFreshEntity((Entity)entity);
        this.dispensed.add((Entity)entity);
        this.checkForFeedCooldown = 2000;
        return true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new AquaticFeederMenu(containerId, playerInventory, this, null);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void dispense() {
        BlockState thisState = this.level.getBlockState(this.getBlockPos());
        if (thisState.getFluidState().isEmpty()) {
            this.playSound(this.getBlockState(), SoundEvents.CHEST_LOCKED);
            this.hasResult = false;
            this.openTicks = 0;
            this.openTime = 0;
            this.closeTicks = 0;
            this.hasToDispense = false;
            return;
        }
        if (this.openTicks > 0 || this.openTime > 0 || this.closeTicks > 0) {
            return;
        }
        this.openTicks = 40;
        this.openTime = 40;
        this.closeTicks = 40;
        this.hasToDispense = true;
        this.setChanged();
    }

    public int getSliderPos() {
        return this.sliderPos;
    }
}

