/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.menu.obj.machine;

import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GeneExtractorMachineEntity;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.menu.JSV1Menus;
import jp.jurassicsaga.server.v1.menu.obj.GenericMachineMenu;
import jp.jurassicsaga.server.v1.menu.obj.JSSlotItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

public class GeneExtractorMenu
extends GenericMachineMenu {
    public GeneExtractorMenu(int pContainerId, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(pContainerId, inv, (GenericMachineEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public GeneExtractorMenu(int pContainerId, Inventory inv, BlockPos pos) {
        this(pContainerId, inv, (GenericMachineEntity)inv.player.level().getBlockEntity(pos), (ContainerData)new SimpleContainerData(5));
    }

    public GeneExtractorMenu(int pContainerId, Inventory inv, GenericMachineEntity blockEntity, ContainerData data) {
        super(JSV1Menus.GENE_EXTRACTOR.get(), pContainerId, inv, blockEntity, data);
    }

    @Override
    protected void addSlots(SimpleContainer container) {
        this.addSlot(new Slot((Container)container, 0, 80, -6){

            public boolean mayPlace(@NotNull ItemStack stack) {
                if (stack.getItem() instanceof DnaItem) {
                    JSGeneData geneData = JSGeneUtil.readFromStack(stack);
                    return geneData.getTotalCompletion() == 100;
                }
                return GeneExtractorMachineEntity.ACCEPTED_ITEMS.contains(stack.getItem());
            }

            public int getMaxStackSize() {
                return 1;
            }

            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }

            public void onTake(Player player, ItemStack stack) {
                ((GeneExtractorMachineEntity)GeneExtractorMenu.this.blockEntity).onTookFromInputSlot(stack);
                super.onTake(player, stack);
            }
        });
        for (int i = 0; i < 7; ++i) {
            this.addSlot(new JSSlotItemHandler((Container)container, i + 1, 29 + i * 18 - 3, 49){

                public boolean mayPlace(@NotNull ItemStack p_39918_) {
                    return false;
                }

                @Override
                public void onTake(Player player, ItemStack stack, ItemStack oldStack) {
                    ((GeneExtractorMachineEntity)GeneExtractorMenu.this.blockEntity).onTookFromOutputSlot(oldStack);
                }

                public void onTake(Player player, ItemStack stack) {
                    ((GeneExtractorMachineEntity)GeneExtractorMenu.this.blockEntity).onTookFromOutputSlot(stack);
                }
            });
        }
    }

    @Override
    public int getInvExtraYOffset() {
        return -10;
    }

    @Override
    public int getHotbarExtraYOffset() {
        return 0;
    }

    @Override
    public Vector2d getPlayerInventoryLabelOffset() {
        return new Vector2d(0.0, 2.0);
    }

    @Override
    public Vector2d getLabelOffset() {
        return new Vector2d(5.0, -26.0);
    }
}

