/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.v1.menu.obj.machine;

import jp.jurassicsaga.server.base.item.JSDataComponents;
import jp.jurassicsaga.server.base.item.obj.FossilItem;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalItem;
import jp.jurassicsaga.server.base.item.obj.animal.AnimalRemains;
import jp.jurassicsaga.server.base.item.obj.genetics.SyringeItem;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GenericMachineEntity;
import jp.jurassicsaga.server.v1.block.entity.geo.machine.GeneticAnalyzerMachineEntity;
import jp.jurassicsaga.server.v1.menu.JSV1Menus;
import jp.jurassicsaga.server.v1.menu.obj.GenericMachineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

public class GeneticAnalyzerMachineMenu
extends GenericMachineMenu {
    public GeneticAnalyzerMachineMenu(int pContainerId, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this(pContainerId, inv, (GenericMachineEntity)inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public GeneticAnalyzerMachineMenu(int pContainerId, Inventory inv, BlockPos pos) {
        this(pContainerId, inv, (GenericMachineEntity)inv.player.level().getBlockEntity(pos), (ContainerData)new SimpleContainerData(5));
    }

    public GeneticAnalyzerMachineMenu(int pContainerId, Inventory inv, GenericMachineEntity blockEntity, ContainerData data) {
        super(JSV1Menus.GENETIC_ANALYZER.get(), pContainerId, inv, blockEntity, data);
    }

    @Override
    protected void addSlots(SimpleContainer container) {
        int yOffset;
        int xOffset;
        int j;
        int i;
        int slotCount = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                xOffset = i == 0 ? 0 : 18 * i;
                yOffset = j == 0 ? 0 : 18 * j;
                this.addSlot(new Slot((Container)container, slotCount, 8 + xOffset, 16 + yOffset){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        Item item = stack.getItem();
                        if (item instanceof SyringeItem) {
                            SyringeItem item2 = (SyringeItem)item;
                            boolean hasNone = ((String)stack.getOrDefault((DataComponentType)JSDataComponents.SPECIES_NAME.get(), (Object)"")).isEmpty();
                            return !hasNone;
                        }
                        Item hasNone = stack.getItem();
                        if (hasNone instanceof FossilItem) {
                            FossilItem fossilItem = (FossilItem)hasNone;
                            GenericMachineEntity genericMachineEntity = GeneticAnalyzerMachineMenu.this.blockEntity;
                            if (genericMachineEntity instanceof GeneticAnalyzerMachineEntity) {
                                GeneticAnalyzerMachineEntity e = (GeneticAnalyzerMachineEntity)genericMachineEntity;
                                boolean containsResultType = GeneticAnalyzerMachineEntity.getResultPossibilityHashMap().containsKey((Object)fossilItem.getResult().getResultType());
                                if (containsResultType) {
                                    AnimalItem animalItem;
                                    Item item3;
                                    boolean containsActualItem = GeneticAnalyzerMachineEntity.getResultPossibilityHashMap().get((Object)fossilItem.getResult().getResultType()).containsKey((Object)fossilItem.getEra());
                                    if (containsActualItem) {
                                        return true;
                                    }
                                    return stack.getItem() instanceof SyringeItem && stack.has((DataComponentType)JSDataComponents.SPECIES_NAME.get()) || (item3 = stack.getItem()) instanceof AnimalItem && (animalItem = (AnimalItem)item3).canExtractDNA();
                                }
                                return stack.getItem() instanceof AnimalRemains;
                            }
                        }
                        return false;
                    }
                });
                ++slotCount;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                xOffset = i == 0 ? 0 : 18 * i;
                yOffset = j == 0 ? 0 : 18 * j;
                this.addSlot(new Slot(this, (Container)container, slotCount, 116 + xOffset, 16 + yOffset){

                    public boolean mayPlace(@NotNull ItemStack p_39918_) {
                        return false;
                    }
                });
                ++slotCount;
            }
        }
    }

    @Override
    public int getInvExtraYOffset() {
        return -4;
    }

    @Override
    public int getHotbarExtraYOffset() {
        return 6;
    }

    @Override
    public Vector2d getPlayerInventoryLabelOffset() {
        return new Vector2d(0.0, 7.0);
    }

    @Override
    public Vector2d getLabelOffset() {
        return super.getLabelOffset();
    }
}

