/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import org.jetbrains.annotations.Nullable;

public class FeedbackParticle
extends TextureSheetParticle {
    protected FeedbackParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.lifetime = 0;
        this.gravity = 0.0f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
    }

    public void tick() {
        if (this.age++ >= this.lifetime || this.alpha <= 0.0f) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(ParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FeedbackParticle particle = new FeedbackParticle(level, x, y, z);
            particle.quadSize = (float)ySpeed;
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

